package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class AuthProviderConfigBuilder extends io.fabric8.kubernetes.api.model.AuthProviderConfigFluentImpl<io.fabric8.kubernetes.api.model.AuthProviderConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.AuthProviderConfig,io.fabric8.kubernetes.api.model.AuthProviderConfigBuilder>{
  public AuthProviderConfigBuilder() {
    this(false);
  }
  public AuthProviderConfigBuilder(java.lang.Boolean validationEnabled) {
    this(new AuthProviderConfig(), validationEnabled);
  }
  public AuthProviderConfigBuilder(io.fabric8.kubernetes.api.model.AuthProviderConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public AuthProviderConfigBuilder(io.fabric8.kubernetes.api.model.AuthProviderConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AuthProviderConfig(), validationEnabled);
  }
  public AuthProviderConfigBuilder(io.fabric8.kubernetes.api.model.AuthProviderConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.AuthProviderConfig instance) {
    this(fluent, instance, false);
  }
  public AuthProviderConfigBuilder(io.fabric8.kubernetes.api.model.AuthProviderConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.AuthProviderConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConfig(instance.getConfig()); 
    fluent.withName(instance.getName()); 
    this.validationEnabled = validationEnabled; 
  }
  public AuthProviderConfigBuilder(io.fabric8.kubernetes.api.model.AuthProviderConfig instance) {
    this(instance,false);
  }
  public AuthProviderConfigBuilder(io.fabric8.kubernetes.api.model.AuthProviderConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConfig(instance.getConfig()); 
    this.withName(instance.getName()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.AuthProviderConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.AuthProviderConfig build() {
    AuthProviderConfig buildable = new AuthProviderConfig(fluent.getConfig(),fluent.getName());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AuthProviderConfigBuilder that = (AuthProviderConfigBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}