package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ResourceRequirementsBuilder extends io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl<io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ResourceRequirements,io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder> {

    io.fabric8.kubernetes.api.model.ResourceRequirementsFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ResourceRequirementsBuilder() {
        this(true);
    }

    public ResourceRequirementsBuilder(java.lang.Boolean validationEnabled) {
        this(new ResourceRequirements(), validationEnabled);
    }

    public ResourceRequirementsBuilder(io.fabric8.kubernetes.api.model.ResourceRequirementsFluent<?> fluent) {
        this(fluent, true);
    }

    public ResourceRequirementsBuilder(io.fabric8.kubernetes.api.model.ResourceRequirementsFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ResourceRequirements(), validationEnabled);
    }

    public ResourceRequirementsBuilder(io.fabric8.kubernetes.api.model.ResourceRequirementsFluent<?> fluent,io.fabric8.kubernetes.api.model.ResourceRequirements instance) {
        this(fluent, instance, true);
    }

    public ResourceRequirementsBuilder(io.fabric8.kubernetes.api.model.ResourceRequirementsFluent<?> fluent,io.fabric8.kubernetes.api.model.ResourceRequirements instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLimits(instance.getLimits()); 
        fluent.withRequests(instance.getRequests()); 
        this.validationEnabled = validationEnabled; 
    }

    public ResourceRequirementsBuilder(io.fabric8.kubernetes.api.model.ResourceRequirements instance) {
        this(instance,true);
    }

    public ResourceRequirementsBuilder(io.fabric8.kubernetes.api.model.ResourceRequirements instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withLimits(instance.getLimits()); 
        this.withRequests(instance.getRequests()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.ResourceRequirements build() {
        ResourceRequirements buildable = new ResourceRequirements(fluent.getLimits(),fluent.getRequests());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ResourceRequirementsBuilder that = (ResourceRequirementsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
