package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExecConfigBuilder extends io.fabric8.kubernetes.api.model.ExecConfigFluentImpl<io.fabric8.kubernetes.api.model.ExecConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ExecConfig,io.fabric8.kubernetes.api.model.ExecConfigBuilder> {

    io.fabric8.kubernetes.api.model.ExecConfigFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ExecConfigBuilder() {
        this(true);
    }

    public ExecConfigBuilder(java.lang.Boolean validationEnabled) {
        this(new ExecConfig(), validationEnabled);
    }

    public ExecConfigBuilder(io.fabric8.kubernetes.api.model.ExecConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public ExecConfigBuilder(io.fabric8.kubernetes.api.model.ExecConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ExecConfig(), validationEnabled);
    }

    public ExecConfigBuilder(io.fabric8.kubernetes.api.model.ExecConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.ExecConfig instance) {
        this(fluent, instance, true);
    }

    public ExecConfigBuilder(io.fabric8.kubernetes.api.model.ExecConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.ExecConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withArgs(instance.getArgs()); 
        fluent.withCommand(instance.getCommand()); 
        fluent.withEnv(instance.getEnv()); 
        fluent.withInstallHint(instance.getInstallHint()); 
        fluent.withProvideClusterInfo(instance.getProvideClusterInfo()); 
        this.validationEnabled = validationEnabled; 
    }

    public ExecConfigBuilder(io.fabric8.kubernetes.api.model.ExecConfig instance) {
        this(instance,true);
    }

    public ExecConfigBuilder(io.fabric8.kubernetes.api.model.ExecConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withArgs(instance.getArgs()); 
        this.withCommand(instance.getCommand()); 
        this.withEnv(instance.getEnv()); 
        this.withInstallHint(instance.getInstallHint()); 
        this.withProvideClusterInfo(instance.getProvideClusterInfo()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.ExecConfig build() {
        ExecConfig buildable = new ExecConfig(fluent.getApiVersion(),fluent.getArgs(),fluent.getCommand(),fluent.getEnv(),fluent.getInstallHint(),fluent.getProvideClusterInfo());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ExecConfigBuilder that = (ExecConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
