package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class WindowsSecurityContextOptionsBuilder extends io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsFluentImpl<io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.WindowsSecurityContextOptions,io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsBuilder> {

    io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public WindowsSecurityContextOptionsBuilder() {
        this(true);
    }

    public WindowsSecurityContextOptionsBuilder(java.lang.Boolean validationEnabled) {
        this(new WindowsSecurityContextOptions(), validationEnabled);
    }

    public WindowsSecurityContextOptionsBuilder(io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsFluent<?> fluent) {
        this(fluent, true);
    }

    public WindowsSecurityContextOptionsBuilder(io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new WindowsSecurityContextOptions(), validationEnabled);
    }

    public WindowsSecurityContextOptionsBuilder(io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.WindowsSecurityContextOptions instance) {
        this(fluent, instance, true);
    }

    public WindowsSecurityContextOptionsBuilder(io.fabric8.kubernetes.api.model.WindowsSecurityContextOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.WindowsSecurityContextOptions instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withGmsaCredentialSpec(instance.getGmsaCredentialSpec()); 
        fluent.withGmsaCredentialSpecName(instance.getGmsaCredentialSpecName()); 
        fluent.withRunAsUserName(instance.getRunAsUserName()); 
        this.validationEnabled = validationEnabled; 
    }

    public WindowsSecurityContextOptionsBuilder(io.fabric8.kubernetes.api.model.WindowsSecurityContextOptions instance) {
        this(instance,true);
    }

    public WindowsSecurityContextOptionsBuilder(io.fabric8.kubernetes.api.model.WindowsSecurityContextOptions instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withGmsaCredentialSpec(instance.getGmsaCredentialSpec()); 
        this.withGmsaCredentialSpecName(instance.getGmsaCredentialSpecName()); 
        this.withRunAsUserName(instance.getRunAsUserName()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.WindowsSecurityContextOptions build() {
        WindowsSecurityContextOptions buildable = new WindowsSecurityContextOptions(fluent.getGmsaCredentialSpec(),fluent.getGmsaCredentialSpecName(),fluent.getRunAsUserName());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        WindowsSecurityContextOptionsBuilder that = (WindowsSecurityContextOptionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
