package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NamespaceListBuilder extends io.fabric8.kubernetes.api.model.NamespaceListFluentImpl<io.fabric8.kubernetes.api.model.NamespaceListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.NamespaceList,io.fabric8.kubernetes.api.model.NamespaceListBuilder> {

    io.fabric8.kubernetes.api.model.NamespaceListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public NamespaceListBuilder() {
        this(true);
    }

    public NamespaceListBuilder(java.lang.Boolean validationEnabled) {
        this(new NamespaceList(), validationEnabled);
    }

    public NamespaceListBuilder(io.fabric8.kubernetes.api.model.NamespaceListFluent<?> fluent) {
        this(fluent, true);
    }

    public NamespaceListBuilder(io.fabric8.kubernetes.api.model.NamespaceListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new NamespaceList(), validationEnabled);
    }

    public NamespaceListBuilder(io.fabric8.kubernetes.api.model.NamespaceListFluent<?> fluent,io.fabric8.kubernetes.api.model.NamespaceList instance) {
        this(fluent, instance, true);
    }

    public NamespaceListBuilder(io.fabric8.kubernetes.api.model.NamespaceListFluent<?> fluent,io.fabric8.kubernetes.api.model.NamespaceList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public NamespaceListBuilder(io.fabric8.kubernetes.api.model.NamespaceList instance) {
        this(instance,true);
    }

    public NamespaceListBuilder(io.fabric8.kubernetes.api.model.NamespaceList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.NamespaceList build() {
        NamespaceList buildable = new NamespaceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NamespaceListBuilder that = (NamespaceListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
