package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NamedContextBuilder extends io.fabric8.kubernetes.api.model.NamedContextFluentImpl<io.fabric8.kubernetes.api.model.NamedContextBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.NamedContext,io.fabric8.kubernetes.api.model.NamedContextBuilder> {

    io.fabric8.kubernetes.api.model.NamedContextFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public NamedContextBuilder() {
        this(true);
    }

    public NamedContextBuilder(java.lang.Boolean validationEnabled) {
        this(new NamedContext(), validationEnabled);
    }

    public NamedContextBuilder(io.fabric8.kubernetes.api.model.NamedContextFluent<?> fluent) {
        this(fluent, true);
    }

    public NamedContextBuilder(io.fabric8.kubernetes.api.model.NamedContextFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new NamedContext(), validationEnabled);
    }

    public NamedContextBuilder(io.fabric8.kubernetes.api.model.NamedContextFluent<?> fluent,io.fabric8.kubernetes.api.model.NamedContext instance) {
        this(fluent, instance, true);
    }

    public NamedContextBuilder(io.fabric8.kubernetes.api.model.NamedContextFluent<?> fluent,io.fabric8.kubernetes.api.model.NamedContext instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withContext(instance.getContext()); 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public NamedContextBuilder(io.fabric8.kubernetes.api.model.NamedContext instance) {
        this(instance,true);
    }

    public NamedContextBuilder(io.fabric8.kubernetes.api.model.NamedContext instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withContext(instance.getContext()); 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.NamedContext build() {
        NamedContext buildable = new NamedContext(fluent.getContext(),fluent.getName());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NamedContextBuilder that = (NamedContextBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
