package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerImageBuilder extends io.fabric8.kubernetes.api.model.ContainerImageFluentImpl<io.fabric8.kubernetes.api.model.ContainerImageBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ContainerImage,io.fabric8.kubernetes.api.model.ContainerImageBuilder> {

    io.fabric8.kubernetes.api.model.ContainerImageFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ContainerImageBuilder() {
        this(true);
    }

    public ContainerImageBuilder(java.lang.Boolean validationEnabled) {
        this(new ContainerImage(), validationEnabled);
    }

    public ContainerImageBuilder(io.fabric8.kubernetes.api.model.ContainerImageFluent<?> fluent) {
        this(fluent, true);
    }

    public ContainerImageBuilder(io.fabric8.kubernetes.api.model.ContainerImageFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ContainerImage(), validationEnabled);
    }

    public ContainerImageBuilder(io.fabric8.kubernetes.api.model.ContainerImageFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerImage instance) {
        this(fluent, instance, true);
    }

    public ContainerImageBuilder(io.fabric8.kubernetes.api.model.ContainerImageFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerImage instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withNames(instance.getNames()); 
        fluent.withSizeBytes(instance.getSizeBytes()); 
        this.validationEnabled = validationEnabled; 
    }

    public ContainerImageBuilder(io.fabric8.kubernetes.api.model.ContainerImage instance) {
        this(instance,true);
    }

    public ContainerImageBuilder(io.fabric8.kubernetes.api.model.ContainerImage instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withNames(instance.getNames()); 
        this.withSizeBytes(instance.getSizeBytes()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.ContainerImage build() {
        ContainerImage buildable = new ContainerImage(fluent.getNames(),fluent.getSizeBytes());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ContainerImageBuilder that = (ContainerImageBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
