package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NodeSelectorTermBuilder extends io.fabric8.kubernetes.api.model.NodeSelectorTermFluentImpl<io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.NodeSelectorTerm,io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder> {

    io.fabric8.kubernetes.api.model.NodeSelectorTermFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public NodeSelectorTermBuilder() {
        this(true);
    }

    public NodeSelectorTermBuilder(java.lang.Boolean validationEnabled) {
        this(new NodeSelectorTerm(), validationEnabled);
    }

    public NodeSelectorTermBuilder(io.fabric8.kubernetes.api.model.NodeSelectorTermFluent<?> fluent) {
        this(fluent, true);
    }

    public NodeSelectorTermBuilder(io.fabric8.kubernetes.api.model.NodeSelectorTermFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new NodeSelectorTerm(), validationEnabled);
    }

    public NodeSelectorTermBuilder(io.fabric8.kubernetes.api.model.NodeSelectorTermFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeSelectorTerm instance) {
        this(fluent, instance, true);
    }

    public NodeSelectorTermBuilder(io.fabric8.kubernetes.api.model.NodeSelectorTermFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeSelectorTerm instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withMatchExpressions(instance.getMatchExpressions()); 
        fluent.withMatchFields(instance.getMatchFields()); 
        this.validationEnabled = validationEnabled; 
    }

    public NodeSelectorTermBuilder(io.fabric8.kubernetes.api.model.NodeSelectorTerm instance) {
        this(instance,true);
    }

    public NodeSelectorTermBuilder(io.fabric8.kubernetes.api.model.NodeSelectorTerm instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withMatchExpressions(instance.getMatchExpressions()); 
        this.withMatchFields(instance.getMatchFields()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.NodeSelectorTerm build() {
        NodeSelectorTerm buildable = new NodeSelectorTerm(fluent.getMatchExpressions(),fluent.getMatchFields());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NodeSelectorTermBuilder that = (NodeSelectorTermBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
