package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NodeDaemonEndpointsBuilder extends io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluentImpl<io.fabric8.kubernetes.api.model.NodeDaemonEndpointsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.NodeDaemonEndpoints,io.fabric8.kubernetes.api.model.NodeDaemonEndpointsBuilder> {

    io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public NodeDaemonEndpointsBuilder() {
        this(true);
    }

    public NodeDaemonEndpointsBuilder(java.lang.Boolean validationEnabled) {
        this(new NodeDaemonEndpoints(), validationEnabled);
    }

    public NodeDaemonEndpointsBuilder(io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluent<?> fluent) {
        this(fluent, true);
    }

    public NodeDaemonEndpointsBuilder(io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new NodeDaemonEndpoints(), validationEnabled);
    }

    public NodeDaemonEndpointsBuilder(io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeDaemonEndpoints instance) {
        this(fluent, instance, true);
    }

    public NodeDaemonEndpointsBuilder(io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeDaemonEndpoints instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withKubeletEndpoint(instance.getKubeletEndpoint()); 
        this.validationEnabled = validationEnabled; 
    }

    public NodeDaemonEndpointsBuilder(io.fabric8.kubernetes.api.model.NodeDaemonEndpoints instance) {
        this(instance,true);
    }

    public NodeDaemonEndpointsBuilder(io.fabric8.kubernetes.api.model.NodeDaemonEndpoints instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withKubeletEndpoint(instance.getKubeletEndpoint()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.NodeDaemonEndpoints build() {
        NodeDaemonEndpoints buildable = new NodeDaemonEndpoints(fluent.getKubeletEndpoint());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NodeDaemonEndpointsBuilder that = (NodeDaemonEndpointsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
