package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ListOptionsBuilder extends io.fabric8.kubernetes.api.model.ListOptionsFluentImpl<io.fabric8.kubernetes.api.model.ListOptionsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ListOptions,io.fabric8.kubernetes.api.model.ListOptionsBuilder> {

    io.fabric8.kubernetes.api.model.ListOptionsFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ListOptionsBuilder() {
        this(true);
    }

    public ListOptionsBuilder(java.lang.Boolean validationEnabled) {
        this(new ListOptions(), validationEnabled);
    }

    public ListOptionsBuilder(io.fabric8.kubernetes.api.model.ListOptionsFluent<?> fluent) {
        this(fluent, true);
    }

    public ListOptionsBuilder(io.fabric8.kubernetes.api.model.ListOptionsFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ListOptions(), validationEnabled);
    }

    public ListOptionsBuilder(io.fabric8.kubernetes.api.model.ListOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.ListOptions instance) {
        this(fluent, instance, true);
    }

    public ListOptionsBuilder(io.fabric8.kubernetes.api.model.ListOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.ListOptions instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAllowWatchBookmarks(instance.getAllowWatchBookmarks()); 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withContinue(instance.getContinue()); 
        fluent.withFieldSelector(instance.getFieldSelector()); 
        fluent.withKind(instance.getKind()); 
        fluent.withLabelSelector(instance.getLabelSelector()); 
        fluent.withLimit(instance.getLimit()); 
        fluent.withResourceVersion(instance.getResourceVersion()); 
        fluent.withResourceVersionMatch(instance.getResourceVersionMatch()); 
        fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        fluent.withWatch(instance.getWatch()); 
        this.validationEnabled = validationEnabled; 
    }

    public ListOptionsBuilder(io.fabric8.kubernetes.api.model.ListOptions instance) {
        this(instance,true);
    }

    public ListOptionsBuilder(io.fabric8.kubernetes.api.model.ListOptions instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAllowWatchBookmarks(instance.getAllowWatchBookmarks()); 
        this.withApiVersion(instance.getApiVersion()); 
        this.withContinue(instance.getContinue()); 
        this.withFieldSelector(instance.getFieldSelector()); 
        this.withKind(instance.getKind()); 
        this.withLabelSelector(instance.getLabelSelector()); 
        this.withLimit(instance.getLimit()); 
        this.withResourceVersion(instance.getResourceVersion()); 
        this.withResourceVersionMatch(instance.getResourceVersionMatch()); 
        this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        this.withWatch(instance.getWatch()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.ListOptions build() {
        ListOptions buildable = new ListOptions(fluent.getAllowWatchBookmarks(),fluent.getApiVersion(),fluent.getContinue(),fluent.getFieldSelector(),fluent.getKind(),fluent.getLabelSelector(),fluent.getLimit(),fluent.getResourceVersion(),fluent.getResourceVersionMatch(),fluent.getTimeoutSeconds(),fluent.getWatch());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ListOptionsBuilder that = (ListOptionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
