package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HostPathVolumeSourceBuilder extends io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.HostPathVolumeSource,io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder> {

    io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public HostPathVolumeSourceBuilder() {
        this(true);
    }

    public HostPathVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new HostPathVolumeSource(), validationEnabled);
    }

    public HostPathVolumeSourceBuilder(io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public HostPathVolumeSourceBuilder(io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new HostPathVolumeSource(), validationEnabled);
    }

    public HostPathVolumeSourceBuilder(io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.HostPathVolumeSource instance) {
        this(fluent, instance, true);
    }

    public HostPathVolumeSourceBuilder(io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.HostPathVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withPath(instance.getPath()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public HostPathVolumeSourceBuilder(io.fabric8.kubernetes.api.model.HostPathVolumeSource instance) {
        this(instance,true);
    }

    public HostPathVolumeSourceBuilder(io.fabric8.kubernetes.api.model.HostPathVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withPath(instance.getPath()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.HostPathVolumeSource build() {
        HostPathVolumeSource buildable = new HostPathVolumeSource(fluent.getPath(),fluent.getType());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        HostPathVolumeSourceBuilder that = (HostPathVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
