package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EnvVarBuilder extends io.fabric8.kubernetes.api.model.EnvVarFluentImpl<io.fabric8.kubernetes.api.model.EnvVarBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.EnvVar,io.fabric8.kubernetes.api.model.EnvVarBuilder> {

    io.fabric8.kubernetes.api.model.EnvVarFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public EnvVarBuilder() {
        this(true);
    }

    public EnvVarBuilder(java.lang.Boolean validationEnabled) {
        this(new EnvVar(), validationEnabled);
    }

    public EnvVarBuilder(io.fabric8.kubernetes.api.model.EnvVarFluent<?> fluent) {
        this(fluent, true);
    }

    public EnvVarBuilder(io.fabric8.kubernetes.api.model.EnvVarFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new EnvVar(), validationEnabled);
    }

    public EnvVarBuilder(io.fabric8.kubernetes.api.model.EnvVarFluent<?> fluent,io.fabric8.kubernetes.api.model.EnvVar instance) {
        this(fluent, instance, true);
    }

    public EnvVarBuilder(io.fabric8.kubernetes.api.model.EnvVarFluent<?> fluent,io.fabric8.kubernetes.api.model.EnvVar instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        fluent.withValue(instance.getValue()); 
        fluent.withValueFrom(instance.getValueFrom()); 
        this.validationEnabled = validationEnabled; 
    }

    public EnvVarBuilder(io.fabric8.kubernetes.api.model.EnvVar instance) {
        this(instance,true);
    }

    public EnvVarBuilder(io.fabric8.kubernetes.api.model.EnvVar instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.withValue(instance.getValue()); 
        this.withValueFrom(instance.getValueFrom()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.EnvVar build() {
        EnvVar buildable = new EnvVar(fluent.getName(),fluent.getValue(),fluent.getValueFrom());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EnvVarBuilder that = (EnvVarBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
