package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIServiceSpecBuilder extends io.fabric8.kubernetes.api.model.APIServiceSpecFluentImpl<io.fabric8.kubernetes.api.model.APIServiceSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.APIServiceSpec,io.fabric8.kubernetes.api.model.APIServiceSpecBuilder> {

    io.fabric8.kubernetes.api.model.APIServiceSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public APIServiceSpecBuilder() {
        this(true);
    }

    public APIServiceSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new APIServiceSpec(), validationEnabled);
    }

    public APIServiceSpecBuilder(io.fabric8.kubernetes.api.model.APIServiceSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public APIServiceSpecBuilder(io.fabric8.kubernetes.api.model.APIServiceSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new APIServiceSpec(), validationEnabled);
    }

    public APIServiceSpecBuilder(io.fabric8.kubernetes.api.model.APIServiceSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.APIServiceSpec instance) {
        this(fluent, instance, true);
    }

    public APIServiceSpecBuilder(io.fabric8.kubernetes.api.model.APIServiceSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.APIServiceSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCaBundle(instance.getCaBundle()); 
        fluent.withGroup(instance.getGroup()); 
        fluent.withGroupPriorityMinimum(instance.getGroupPriorityMinimum()); 
        fluent.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify()); 
        fluent.withService(instance.getService()); 
        fluent.withVersion(instance.getVersion()); 
        fluent.withVersionPriority(instance.getVersionPriority()); 
        this.validationEnabled = validationEnabled; 
    }

    public APIServiceSpecBuilder(io.fabric8.kubernetes.api.model.APIServiceSpec instance) {
        this(instance,true);
    }

    public APIServiceSpecBuilder(io.fabric8.kubernetes.api.model.APIServiceSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCaBundle(instance.getCaBundle()); 
        this.withGroup(instance.getGroup()); 
        this.withGroupPriorityMinimum(instance.getGroupPriorityMinimum()); 
        this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify()); 
        this.withService(instance.getService()); 
        this.withVersion(instance.getVersion()); 
        this.withVersionPriority(instance.getVersionPriority()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.APIServiceSpec build() {
        APIServiceSpec buildable = new APIServiceSpec(fluent.getCaBundle(),fluent.getGroup(),fluent.getGroupPriorityMinimum(),fluent.getInsecureSkipTLSVerify(),fluent.getService(),fluent.getVersion(),fluent.getVersionPriority());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        APIServiceSpecBuilder that = (APIServiceSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
