package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIGroupListBuilder extends io.fabric8.kubernetes.api.model.APIGroupListFluentImpl<io.fabric8.kubernetes.api.model.APIGroupListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.APIGroupList,io.fabric8.kubernetes.api.model.APIGroupListBuilder> {

    io.fabric8.kubernetes.api.model.APIGroupListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public APIGroupListBuilder() {
        this(true);
    }

    public APIGroupListBuilder(java.lang.Boolean validationEnabled) {
        this(new APIGroupList(), validationEnabled);
    }

    public APIGroupListBuilder(io.fabric8.kubernetes.api.model.APIGroupListFluent<?> fluent) {
        this(fluent, true);
    }

    public APIGroupListBuilder(io.fabric8.kubernetes.api.model.APIGroupListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new APIGroupList(), validationEnabled);
    }

    public APIGroupListBuilder(io.fabric8.kubernetes.api.model.APIGroupListFluent<?> fluent,io.fabric8.kubernetes.api.model.APIGroupList instance) {
        this(fluent, instance, true);
    }

    public APIGroupListBuilder(io.fabric8.kubernetes.api.model.APIGroupListFluent<?> fluent,io.fabric8.kubernetes.api.model.APIGroupList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withGroups(instance.getGroups()); 
        fluent.withKind(instance.getKind()); 
        this.validationEnabled = validationEnabled; 
    }

    public APIGroupListBuilder(io.fabric8.kubernetes.api.model.APIGroupList instance) {
        this(instance,true);
    }

    public APIGroupListBuilder(io.fabric8.kubernetes.api.model.APIGroupList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withGroups(instance.getGroups()); 
        this.withKind(instance.getKind()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.APIGroupList build() {
        APIGroupList buildable = new APIGroupList(fluent.getApiVersion(),fluent.getGroups(),fluent.getKind());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        APIGroupListBuilder that = (APIGroupListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
