package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GlusterfsVolumeSourceBuilder extends io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.GlusterfsVolumeSource,io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilder> {

    io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public GlusterfsVolumeSourceBuilder() {
        this(true);
    }

    public GlusterfsVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new GlusterfsVolumeSource(), validationEnabled);
    }

    public GlusterfsVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public GlusterfsVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new GlusterfsVolumeSource(), validationEnabled);
    }

    public GlusterfsVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.GlusterfsVolumeSource instance) {
        this(fluent, instance, true);
    }

    public GlusterfsVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.GlusterfsVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withEndpoints(instance.getEndpoints()); 
        fluent.withPath(instance.getPath()); 
        fluent.withReadOnly(instance.getReadOnly()); 
        this.validationEnabled = validationEnabled; 
    }

    public GlusterfsVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsVolumeSource instance) {
        this(instance,true);
    }

    public GlusterfsVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withEndpoints(instance.getEndpoints()); 
        this.withPath(instance.getPath()); 
        this.withReadOnly(instance.getReadOnly()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.GlusterfsVolumeSource build() {
        GlusterfsVolumeSource buildable = new GlusterfsVolumeSource(fluent.getEndpoints(),fluent.getPath(),fluent.getReadOnly());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GlusterfsVolumeSourceBuilder that = (GlusterfsVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
