package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StorageOSVolumeSourceBuilder extends io.fabric8.kubernetes.api.model.StorageOSVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.StorageOSVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.StorageOSVolumeSource,io.fabric8.kubernetes.api.model.StorageOSVolumeSourceBuilder> {

    io.fabric8.kubernetes.api.model.StorageOSVolumeSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public StorageOSVolumeSourceBuilder() {
        this(true);
    }

    public StorageOSVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new StorageOSVolumeSource(), validationEnabled);
    }

    public StorageOSVolumeSourceBuilder(io.fabric8.kubernetes.api.model.StorageOSVolumeSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public StorageOSVolumeSourceBuilder(io.fabric8.kubernetes.api.model.StorageOSVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new StorageOSVolumeSource(), validationEnabled);
    }

    public StorageOSVolumeSourceBuilder(io.fabric8.kubernetes.api.model.StorageOSVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.StorageOSVolumeSource instance) {
        this(fluent, instance, true);
    }

    public StorageOSVolumeSourceBuilder(io.fabric8.kubernetes.api.model.StorageOSVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.StorageOSVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withFsType(instance.getFsType()); 
        fluent.withReadOnly(instance.getReadOnly()); 
        fluent.withSecretRef(instance.getSecretRef()); 
        fluent.withVolumeName(instance.getVolumeName()); 
        fluent.withVolumeNamespace(instance.getVolumeNamespace()); 
        this.validationEnabled = validationEnabled; 
    }

    public StorageOSVolumeSourceBuilder(io.fabric8.kubernetes.api.model.StorageOSVolumeSource instance) {
        this(instance,true);
    }

    public StorageOSVolumeSourceBuilder(io.fabric8.kubernetes.api.model.StorageOSVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withFsType(instance.getFsType()); 
        this.withReadOnly(instance.getReadOnly()); 
        this.withSecretRef(instance.getSecretRef()); 
        this.withVolumeName(instance.getVolumeName()); 
        this.withVolumeNamespace(instance.getVolumeNamespace()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.StorageOSVolumeSource build() {
        StorageOSVolumeSource buildable = new StorageOSVolumeSource(fluent.getFsType(),fluent.getReadOnly(),fluent.getSecretRef(),fluent.getVolumeName(),fluent.getVolumeNamespace());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StorageOSVolumeSourceBuilder that = (StorageOSVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
