package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SeccompProfileBuilder extends io.fabric8.kubernetes.api.model.SeccompProfileFluentImpl<io.fabric8.kubernetes.api.model.SeccompProfileBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.SeccompProfile,io.fabric8.kubernetes.api.model.SeccompProfileBuilder> {

    io.fabric8.kubernetes.api.model.SeccompProfileFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public SeccompProfileBuilder() {
        this(true);
    }

    public SeccompProfileBuilder(java.lang.Boolean validationEnabled) {
        this(new SeccompProfile(), validationEnabled);
    }

    public SeccompProfileBuilder(io.fabric8.kubernetes.api.model.SeccompProfileFluent<?> fluent) {
        this(fluent, true);
    }

    public SeccompProfileBuilder(io.fabric8.kubernetes.api.model.SeccompProfileFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new SeccompProfile(), validationEnabled);
    }

    public SeccompProfileBuilder(io.fabric8.kubernetes.api.model.SeccompProfileFluent<?> fluent,io.fabric8.kubernetes.api.model.SeccompProfile instance) {
        this(fluent, instance, true);
    }

    public SeccompProfileBuilder(io.fabric8.kubernetes.api.model.SeccompProfileFluent<?> fluent,io.fabric8.kubernetes.api.model.SeccompProfile instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLocalhostProfile(instance.getLocalhostProfile()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public SeccompProfileBuilder(io.fabric8.kubernetes.api.model.SeccompProfile instance) {
        this(instance,true);
    }

    public SeccompProfileBuilder(io.fabric8.kubernetes.api.model.SeccompProfile instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withLocalhostProfile(instance.getLocalhostProfile()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.SeccompProfile build() {
        SeccompProfile buildable = new SeccompProfile(fluent.getLocalhostProfile(),fluent.getType());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SeccompProfileBuilder that = (SeccompProfileBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
