package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ScaleIOPersistentVolumeSourceBuilder extends io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSource,io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSourceBuilder> {

    io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ScaleIOPersistentVolumeSourceBuilder() {
        this(true);
    }

    public ScaleIOPersistentVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new ScaleIOPersistentVolumeSource(), validationEnabled);
    }

    public ScaleIOPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public ScaleIOPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ScaleIOPersistentVolumeSource(), validationEnabled);
    }

    public ScaleIOPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSource instance) {
        this(fluent, instance, true);
    }

    public ScaleIOPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withFsType(instance.getFsType()); 
        fluent.withGateway(instance.getGateway()); 
        fluent.withProtectionDomain(instance.getProtectionDomain()); 
        fluent.withReadOnly(instance.getReadOnly()); 
        fluent.withSecretRef(instance.getSecretRef()); 
        fluent.withSslEnabled(instance.getSslEnabled()); 
        fluent.withStorageMode(instance.getStorageMode()); 
        fluent.withStoragePool(instance.getStoragePool()); 
        fluent.withSystem(instance.getSystem()); 
        fluent.withVolumeName(instance.getVolumeName()); 
        this.validationEnabled = validationEnabled; 
    }

    public ScaleIOPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSource instance) {
        this(instance,true);
    }

    public ScaleIOPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withFsType(instance.getFsType()); 
        this.withGateway(instance.getGateway()); 
        this.withProtectionDomain(instance.getProtectionDomain()); 
        this.withReadOnly(instance.getReadOnly()); 
        this.withSecretRef(instance.getSecretRef()); 
        this.withSslEnabled(instance.getSslEnabled()); 
        this.withStorageMode(instance.getStorageMode()); 
        this.withStoragePool(instance.getStoragePool()); 
        this.withSystem(instance.getSystem()); 
        this.withVolumeName(instance.getVolumeName()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSource build() {
        ScaleIOPersistentVolumeSource buildable = new ScaleIOPersistentVolumeSource(fluent.getFsType(),fluent.getGateway(),fluent.getProtectionDomain(),fluent.getReadOnly(),fluent.getSecretRef(),fluent.getSslEnabled(),fluent.getStorageMode(),fluent.getStoragePool(),fluent.getSystem(),fluent.getVolumeName());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ScaleIOPersistentVolumeSourceBuilder that = (ScaleIOPersistentVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
