package io.fabric8.kubernetes.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class PreconditionsFluentImpl<A extends PreconditionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PreconditionsFluent<A> {

    private String resourceVersion;
    private String uid;

    public PreconditionsFluentImpl() {
    }

    public PreconditionsFluentImpl(Preconditions instance) {
        this.withResourceVersion(instance.getResourceVersion()); 
        this.withUid(instance.getUid()); 
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public A withResourceVersion(String resourceVersion) {
        this.resourceVersion=resourceVersion; return (A) this;
    }

    public Boolean hasResourceVersion() {
        return this.resourceVersion != null;
    }

    public A withNewResourceVersion(StringBuilder arg1) {
        return (A)withResourceVersion(new String(arg1));
    }

    public A withNewResourceVersion(int[] arg1,int arg2,int arg3) {
        return (A)withResourceVersion(new String(arg1, arg2, arg3));
    }

    public A withNewResourceVersion(char[] arg1) {
        return (A)withResourceVersion(new String(arg1));
    }

    public A withNewResourceVersion(StringBuffer arg1) {
        return (A)withResourceVersion(new String(arg1));
    }

    public A withNewResourceVersion(byte[] arg1,int arg2) {
        return (A)withResourceVersion(new String(arg1, arg2));
    }

    public A withNewResourceVersion(byte[] arg1) {
        return (A)withResourceVersion(new String(arg1));
    }

    public A withNewResourceVersion(char[] arg1,int arg2,int arg3) {
        return (A)withResourceVersion(new String(arg1, arg2, arg3));
    }

    public A withNewResourceVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withResourceVersion(new String(arg1, arg2, arg3));
    }

    public A withNewResourceVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withResourceVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewResourceVersion(String arg1) {
        return (A)withResourceVersion(new String(arg1));
    }

    public String getUid() {
        return this.uid;
    }

    public A withUid(String uid) {
        this.uid=uid; return (A) this;
    }

    public Boolean hasUid() {
        return this.uid != null;
    }

    public A withNewUid(StringBuilder arg1) {
        return (A)withUid(new String(arg1));
    }

    public A withNewUid(int[] arg1,int arg2,int arg3) {
        return (A)withUid(new String(arg1, arg2, arg3));
    }

    public A withNewUid(char[] arg1) {
        return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuffer arg1) {
        return (A)withUid(new String(arg1));
    }

    public A withNewUid(byte[] arg1,int arg2) {
        return (A)withUid(new String(arg1, arg2));
    }

    public A withNewUid(byte[] arg1) {
        return (A)withUid(new String(arg1));
    }

    public A withNewUid(char[] arg1,int arg2,int arg3) {
        return (A)withUid(new String(arg1, arg2, arg3));
    }

    public A withNewUid(byte[] arg1,int arg2,int arg3) {
        return (A)withUid(new String(arg1, arg2, arg3));
    }

    public A withNewUid(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withUid(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewUid(String arg1) {
        return (A)withUid(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PreconditionsFluentImpl that = (PreconditionsFluentImpl) o;
        if (resourceVersion != null ? !resourceVersion.equals(that.resourceVersion) :that.resourceVersion != null) return false;
        if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(resourceVersion,  uid,  super.hashCode());
    }

}
