package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;
import java.lang.StringBuffer;

public interface PodSpecFluent<A extends PodSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Long getActiveDeadlineSeconds();
    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds);
    public Boolean hasActiveDeadlineSeconds();
    public A withNewActiveDeadlineSeconds(long arg1);
    
/**
 * This method has been deprecated, please use method buildAffinity instead.
 * @return The buildable object.
 */
@Deprecated public Affinity getAffinity();
    public Affinity buildAffinity();
    public A withAffinity(Affinity affinity);
    public Boolean hasAffinity();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.AffinityNested<A> withNewAffinity();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.AffinityNested<A> withNewAffinityLike(Affinity item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.AffinityNested<A> editAffinity();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.AffinityNested<A> editOrNewAffinity();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.AffinityNested<A> editOrNewAffinityLike(Affinity item);
    public Boolean getAutomountServiceAccountToken();
    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken);
    public Boolean hasAutomountServiceAccountToken();
    public A withNewAutomountServiceAccountToken(String arg1);
    public A withNewAutomountServiceAccountToken(boolean arg1);
    public A addToContainers(int index,Container item);
    public A setToContainers(int index,Container item);
    public A addToContainers(Container... items);
    public A addAllToContainers(Collection<Container> items);
    public A removeFromContainers(Container... items);
    public A removeAllFromContainers(Collection<Container> items);
    public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<Container> getContainers();
    public List<Container> buildContainers();
    public Container buildContainer(int index);
    public Container buildFirstContainer();
    public Container buildLastContainer();
    public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate);
    public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate);
    public A withContainers(List<Container> containers);
    public A withContainers(Container... containers);
    public Boolean hasContainers();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ContainersNested<A> addNewContainer();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ContainersNested<A> addNewContainerLike(Container item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ContainersNested<A> setNewContainerLike(int index,Container item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ContainersNested<A> editContainer(int index);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ContainersNested<A> editFirstContainer();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ContainersNested<A> editLastContainer();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildDnsConfig instead.
 * @return The buildable object.
 */
@Deprecated public PodDNSConfig getDnsConfig();
    public PodDNSConfig buildDnsConfig();
    public A withDnsConfig(PodDNSConfig dnsConfig);
    public Boolean hasDnsConfig();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.DnsConfigNested<A> withNewDnsConfig();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.DnsConfigNested<A> withNewDnsConfigLike(PodDNSConfig item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.DnsConfigNested<A> editDnsConfig();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.DnsConfigNested<A> editOrNewDnsConfig();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.DnsConfigNested<A> editOrNewDnsConfigLike(PodDNSConfig item);
    public String getDnsPolicy();
    public A withDnsPolicy(String dnsPolicy);
    public Boolean hasDnsPolicy();
    public A withNewDnsPolicy(StringBuilder arg1);
    public A withNewDnsPolicy(int[] arg1,int arg2,int arg3);
    public A withNewDnsPolicy(char[] arg1);
    public A withNewDnsPolicy(StringBuffer arg1);
    public A withNewDnsPolicy(byte[] arg1,int arg2);
    public A withNewDnsPolicy(byte[] arg1);
    public A withNewDnsPolicy(char[] arg1,int arg2,int arg3);
    public A withNewDnsPolicy(byte[] arg1,int arg2,int arg3);
    public A withNewDnsPolicy(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewDnsPolicy(String arg1);
    public Boolean getEnableServiceLinks();
    public A withEnableServiceLinks(Boolean enableServiceLinks);
    public Boolean hasEnableServiceLinks();
    public A withNewEnableServiceLinks(String arg1);
    public A withNewEnableServiceLinks(boolean arg1);
    public A addToEphemeralContainers(int index,EphemeralContainer item);
    public A setToEphemeralContainers(int index,EphemeralContainer item);
    public A addToEphemeralContainers(EphemeralContainer... items);
    public A addAllToEphemeralContainers(Collection<EphemeralContainer> items);
    public A removeFromEphemeralContainers(EphemeralContainer... items);
    public A removeAllFromEphemeralContainers(Collection<EphemeralContainer> items);
    public A removeMatchingFromEphemeralContainers(Predicate<EphemeralContainerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildEphemeralContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<EphemeralContainer> getEphemeralContainers();
    public List<EphemeralContainer> buildEphemeralContainers();
    public EphemeralContainer buildEphemeralContainer(int index);
    public EphemeralContainer buildFirstEphemeralContainer();
    public EphemeralContainer buildLastEphemeralContainer();
    public EphemeralContainer buildMatchingEphemeralContainer(Predicate<EphemeralContainerBuilder> predicate);
    public Boolean hasMatchingEphemeralContainer(Predicate<EphemeralContainerBuilder> predicate);
    public A withEphemeralContainers(List<EphemeralContainer> ephemeralContainers);
    public A withEphemeralContainers(EphemeralContainer... ephemeralContainers);
    public Boolean hasEphemeralContainers();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.EphemeralContainersNested<A> addNewEphemeralContainer();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.EphemeralContainersNested<A> addNewEphemeralContainerLike(EphemeralContainer item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.EphemeralContainersNested<A> setNewEphemeralContainerLike(int index,EphemeralContainer item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.EphemeralContainersNested<A> editEphemeralContainer(int index);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.EphemeralContainersNested<A> editFirstEphemeralContainer();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.EphemeralContainersNested<A> editLastEphemeralContainer();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.EphemeralContainersNested<A> editMatchingEphemeralContainer(Predicate<EphemeralContainerBuilder> predicate);
    public A addToHostAliases(int index,HostAlias item);
    public A setToHostAliases(int index,HostAlias item);
    public A addToHostAliases(HostAlias... items);
    public A addAllToHostAliases(Collection<HostAlias> items);
    public A removeFromHostAliases(HostAlias... items);
    public A removeAllFromHostAliases(Collection<HostAlias> items);
    public A removeMatchingFromHostAliases(Predicate<HostAliasBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildHostAliases instead.
 * @return The buildable object.
 */
@Deprecated public List<HostAlias> getHostAliases();
    public List<HostAlias> buildHostAliases();
    public HostAlias buildHostAlias(int index);
    public HostAlias buildFirstHostAlias();
    public HostAlias buildLastHostAlias();
    public HostAlias buildMatchingHostAlias(Predicate<HostAliasBuilder> predicate);
    public Boolean hasMatchingHostAlias(Predicate<HostAliasBuilder> predicate);
    public A withHostAliases(List<HostAlias> hostAliases);
    public A withHostAliases(HostAlias... hostAliases);
    public Boolean hasHostAliases();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.HostAliasesNested<A> addNewHostAlias();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.HostAliasesNested<A> addNewHostAliasLike(HostAlias item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.HostAliasesNested<A> setNewHostAliasLike(int index,HostAlias item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.HostAliasesNested<A> editHostAlias(int index);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.HostAliasesNested<A> editFirstHostAlias();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.HostAliasesNested<A> editLastHostAlias();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.HostAliasesNested<A> editMatchingHostAlias(Predicate<HostAliasBuilder> predicate);
    public Boolean getHostIPC();
    public A withHostIPC(Boolean hostIPC);
    public Boolean hasHostIPC();
    public A withNewHostIPC(String arg1);
    public A withNewHostIPC(boolean arg1);
    public Boolean getHostNetwork();
    public A withHostNetwork(Boolean hostNetwork);
    public Boolean hasHostNetwork();
    public A withNewHostNetwork(String arg1);
    public A withNewHostNetwork(boolean arg1);
    public Boolean getHostPID();
    public A withHostPID(Boolean hostPID);
    public Boolean hasHostPID();
    public A withNewHostPID(String arg1);
    public A withNewHostPID(boolean arg1);
    public String getHostname();
    public A withHostname(String hostname);
    public Boolean hasHostname();
    public A withNewHostname(StringBuilder arg1);
    public A withNewHostname(int[] arg1,int arg2,int arg3);
    public A withNewHostname(char[] arg1);
    public A withNewHostname(StringBuffer arg1);
    public A withNewHostname(byte[] arg1,int arg2);
    public A withNewHostname(byte[] arg1);
    public A withNewHostname(char[] arg1,int arg2,int arg3);
    public A withNewHostname(byte[] arg1,int arg2,int arg3);
    public A withNewHostname(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewHostname(String arg1);
    public A addToImagePullSecrets(int index,LocalObjectReference item);
    public A setToImagePullSecrets(int index,LocalObjectReference item);
    public A addToImagePullSecrets(LocalObjectReference... items);
    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items);
    public A removeFromImagePullSecrets(LocalObjectReference... items);
    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items);
    public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildImagePullSecrets instead.
 * @return The buildable object.
 */
@Deprecated public List<LocalObjectReference> getImagePullSecrets();
    public List<LocalObjectReference> buildImagePullSecrets();
    public LocalObjectReference buildImagePullSecret(int index);
    public LocalObjectReference buildFirstImagePullSecret();
    public LocalObjectReference buildLastImagePullSecret();
    public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
    public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets);
    public A withImagePullSecrets(LocalObjectReference... imagePullSecrets);
    public Boolean hasImagePullSecrets();
    public A addNewImagePullSecret(String name);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,LocalObjectReference item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(int index);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
    public A addToInitContainers(int index,Container item);
    public A setToInitContainers(int index,Container item);
    public A addToInitContainers(Container... items);
    public A addAllToInitContainers(Collection<Container> items);
    public A removeFromInitContainers(Container... items);
    public A removeAllFromInitContainers(Collection<Container> items);
    public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildInitContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<Container> getInitContainers();
    public List<Container> buildInitContainers();
    public Container buildInitContainer(int index);
    public Container buildFirstInitContainer();
    public Container buildLastInitContainer();
    public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate);
    public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate);
    public A withInitContainers(List<Container> initContainers);
    public A withInitContainers(Container... initContainers);
    public Boolean hasInitContainers();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.InitContainersNested<A> addNewInitContainer();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.InitContainersNested<A> addNewInitContainerLike(Container item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.InitContainersNested<A> setNewInitContainerLike(int index,Container item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.InitContainersNested<A> editInitContainer(int index);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.InitContainersNested<A> editFirstInitContainer();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.InitContainersNested<A> editLastInitContainer();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate);
    public String getNodeName();
    public A withNodeName(String nodeName);
    public Boolean hasNodeName();
    public A withNewNodeName(StringBuilder arg1);
    public A withNewNodeName(int[] arg1,int arg2,int arg3);
    public A withNewNodeName(char[] arg1);
    public A withNewNodeName(StringBuffer arg1);
    public A withNewNodeName(byte[] arg1,int arg2);
    public A withNewNodeName(byte[] arg1);
    public A withNewNodeName(char[] arg1,int arg2,int arg3);
    public A withNewNodeName(byte[] arg1,int arg2,int arg3);
    public A withNewNodeName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewNodeName(String arg1);
    public A addToNodeSelector(String key,String value);
    public A addToNodeSelector(java.util.Map<String,String> map);
    public A removeFromNodeSelector(String key);
    public A removeFromNodeSelector(java.util.Map<String,String> map);
    public java.util.Map<String,String> getNodeSelector();
    public <K extends Object,V extends Object>A withNodeSelector(java.util.Map<String,String> nodeSelector);
    public Boolean hasNodeSelector();
    public A addToOverhead(String key,Quantity value);
    public A addToOverhead(java.util.Map<String,Quantity> map);
    public A removeFromOverhead(String key);
    public A removeFromOverhead(java.util.Map<String,Quantity> map);
    public java.util.Map<String,Quantity> getOverhead();
    public <K extends Object,V extends Object>A withOverhead(java.util.Map<String,Quantity> overhead);
    public Boolean hasOverhead();
    public String getPreemptionPolicy();
    public A withPreemptionPolicy(String preemptionPolicy);
    public Boolean hasPreemptionPolicy();
    public A withNewPreemptionPolicy(StringBuilder arg1);
    public A withNewPreemptionPolicy(int[] arg1,int arg2,int arg3);
    public A withNewPreemptionPolicy(char[] arg1);
    public A withNewPreemptionPolicy(StringBuffer arg1);
    public A withNewPreemptionPolicy(byte[] arg1,int arg2);
    public A withNewPreemptionPolicy(byte[] arg1);
    public A withNewPreemptionPolicy(char[] arg1,int arg2,int arg3);
    public A withNewPreemptionPolicy(byte[] arg1,int arg2,int arg3);
    public A withNewPreemptionPolicy(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewPreemptionPolicy(String arg1);
    public Integer getPriority();
    public A withPriority(Integer priority);
    public Boolean hasPriority();
    public A withNewPriority(int arg0);
    public String getPriorityClassName();
    public A withPriorityClassName(String priorityClassName);
    public Boolean hasPriorityClassName();
    public A withNewPriorityClassName(StringBuilder arg1);
    public A withNewPriorityClassName(int[] arg1,int arg2,int arg3);
    public A withNewPriorityClassName(char[] arg1);
    public A withNewPriorityClassName(StringBuffer arg1);
    public A withNewPriorityClassName(byte[] arg1,int arg2);
    public A withNewPriorityClassName(byte[] arg1);
    public A withNewPriorityClassName(char[] arg1,int arg2,int arg3);
    public A withNewPriorityClassName(byte[] arg1,int arg2,int arg3);
    public A withNewPriorityClassName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewPriorityClassName(String arg1);
    public A addToReadinessGates(int index,PodReadinessGate item);
    public A setToReadinessGates(int index,PodReadinessGate item);
    public A addToReadinessGates(PodReadinessGate... items);
    public A addAllToReadinessGates(Collection<PodReadinessGate> items);
    public A removeFromReadinessGates(PodReadinessGate... items);
    public A removeAllFromReadinessGates(Collection<PodReadinessGate> items);
    public A removeMatchingFromReadinessGates(Predicate<PodReadinessGateBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildReadinessGates instead.
 * @return The buildable object.
 */
@Deprecated public List<PodReadinessGate> getReadinessGates();
    public List<PodReadinessGate> buildReadinessGates();
    public PodReadinessGate buildReadinessGate(int index);
    public PodReadinessGate buildFirstReadinessGate();
    public PodReadinessGate buildLastReadinessGate();
    public PodReadinessGate buildMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate);
    public Boolean hasMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate);
    public A withReadinessGates(List<PodReadinessGate> readinessGates);
    public A withReadinessGates(PodReadinessGate... readinessGates);
    public Boolean hasReadinessGates();
    public A addNewReadinessGate(String conditionType);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ReadinessGatesNested<A> addNewReadinessGate();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ReadinessGatesNested<A> addNewReadinessGateLike(PodReadinessGate item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ReadinessGatesNested<A> setNewReadinessGateLike(int index,PodReadinessGate item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ReadinessGatesNested<A> editReadinessGate(int index);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ReadinessGatesNested<A> editFirstReadinessGate();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ReadinessGatesNested<A> editLastReadinessGate();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.ReadinessGatesNested<A> editMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate);
    public String getRestartPolicy();
    public A withRestartPolicy(String restartPolicy);
    public Boolean hasRestartPolicy();
    public A withNewRestartPolicy(StringBuilder arg1);
    public A withNewRestartPolicy(int[] arg1,int arg2,int arg3);
    public A withNewRestartPolicy(char[] arg1);
    public A withNewRestartPolicy(StringBuffer arg1);
    public A withNewRestartPolicy(byte[] arg1,int arg2);
    public A withNewRestartPolicy(byte[] arg1);
    public A withNewRestartPolicy(char[] arg1,int arg2,int arg3);
    public A withNewRestartPolicy(byte[] arg1,int arg2,int arg3);
    public A withNewRestartPolicy(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewRestartPolicy(String arg1);
    public String getRuntimeClassName();
    public A withRuntimeClassName(String runtimeClassName);
    public Boolean hasRuntimeClassName();
    public A withNewRuntimeClassName(StringBuilder arg1);
    public A withNewRuntimeClassName(int[] arg1,int arg2,int arg3);
    public A withNewRuntimeClassName(char[] arg1);
    public A withNewRuntimeClassName(StringBuffer arg1);
    public A withNewRuntimeClassName(byte[] arg1,int arg2);
    public A withNewRuntimeClassName(byte[] arg1);
    public A withNewRuntimeClassName(char[] arg1,int arg2,int arg3);
    public A withNewRuntimeClassName(byte[] arg1,int arg2,int arg3);
    public A withNewRuntimeClassName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewRuntimeClassName(String arg1);
    public String getSchedulerName();
    public A withSchedulerName(String schedulerName);
    public Boolean hasSchedulerName();
    public A withNewSchedulerName(StringBuilder arg1);
    public A withNewSchedulerName(int[] arg1,int arg2,int arg3);
    public A withNewSchedulerName(char[] arg1);
    public A withNewSchedulerName(StringBuffer arg1);
    public A withNewSchedulerName(byte[] arg1,int arg2);
    public A withNewSchedulerName(byte[] arg1);
    public A withNewSchedulerName(char[] arg1,int arg2,int arg3);
    public A withNewSchedulerName(byte[] arg1,int arg2,int arg3);
    public A withNewSchedulerName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewSchedulerName(String arg1);
    
/**
 * This method has been deprecated, please use method buildSecurityContext instead.
 * @return The buildable object.
 */
@Deprecated public PodSecurityContext getSecurityContext();
    public PodSecurityContext buildSecurityContext();
    public A withSecurityContext(PodSecurityContext securityContext);
    public Boolean hasSecurityContext();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.SecurityContextNested<A> withNewSecurityContext();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.SecurityContextNested<A> withNewSecurityContextLike(PodSecurityContext item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.SecurityContextNested<A> editSecurityContext();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContext();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContextLike(PodSecurityContext item);
    public String getServiceAccount();
    public A withServiceAccount(String serviceAccount);
    public Boolean hasServiceAccount();
    public A withNewServiceAccount(StringBuilder arg1);
    public A withNewServiceAccount(int[] arg1,int arg2,int arg3);
    public A withNewServiceAccount(char[] arg1);
    public A withNewServiceAccount(StringBuffer arg1);
    public A withNewServiceAccount(byte[] arg1,int arg2);
    public A withNewServiceAccount(byte[] arg1);
    public A withNewServiceAccount(char[] arg1,int arg2,int arg3);
    public A withNewServiceAccount(byte[] arg1,int arg2,int arg3);
    public A withNewServiceAccount(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewServiceAccount(String arg1);
    public String getServiceAccountName();
    public A withServiceAccountName(String serviceAccountName);
    public Boolean hasServiceAccountName();
    public A withNewServiceAccountName(StringBuilder arg1);
    public A withNewServiceAccountName(int[] arg1,int arg2,int arg3);
    public A withNewServiceAccountName(char[] arg1);
    public A withNewServiceAccountName(StringBuffer arg1);
    public A withNewServiceAccountName(byte[] arg1,int arg2);
    public A withNewServiceAccountName(byte[] arg1);
    public A withNewServiceAccountName(char[] arg1,int arg2,int arg3);
    public A withNewServiceAccountName(byte[] arg1,int arg2,int arg3);
    public A withNewServiceAccountName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewServiceAccountName(String arg1);
    public Boolean getSetHostnameAsFQDN();
    public A withSetHostnameAsFQDN(Boolean setHostnameAsFQDN);
    public Boolean hasSetHostnameAsFQDN();
    public A withNewSetHostnameAsFQDN(String arg1);
    public A withNewSetHostnameAsFQDN(boolean arg1);
    public Boolean getShareProcessNamespace();
    public A withShareProcessNamespace(Boolean shareProcessNamespace);
    public Boolean hasShareProcessNamespace();
    public A withNewShareProcessNamespace(String arg1);
    public A withNewShareProcessNamespace(boolean arg1);
    public String getSubdomain();
    public A withSubdomain(String subdomain);
    public Boolean hasSubdomain();
    public A withNewSubdomain(StringBuilder arg1);
    public A withNewSubdomain(int[] arg1,int arg2,int arg3);
    public A withNewSubdomain(char[] arg1);
    public A withNewSubdomain(StringBuffer arg1);
    public A withNewSubdomain(byte[] arg1,int arg2);
    public A withNewSubdomain(byte[] arg1);
    public A withNewSubdomain(char[] arg1,int arg2,int arg3);
    public A withNewSubdomain(byte[] arg1,int arg2,int arg3);
    public A withNewSubdomain(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewSubdomain(String arg1);
    public Long getTerminationGracePeriodSeconds();
    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds);
    public Boolean hasTerminationGracePeriodSeconds();
    public A withNewTerminationGracePeriodSeconds(long arg1);
    public A addToTolerations(int index,Toleration item);
    public A setToTolerations(int index,Toleration item);
    public A addToTolerations(Toleration... items);
    public A addAllToTolerations(Collection<Toleration> items);
    public A removeFromTolerations(Toleration... items);
    public A removeAllFromTolerations(Collection<Toleration> items);
    public A removeMatchingFromTolerations(Predicate<TolerationBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTolerations instead.
 * @return The buildable object.
 */
@Deprecated public List<Toleration> getTolerations();
    public List<Toleration> buildTolerations();
    public Toleration buildToleration(int index);
    public Toleration buildFirstToleration();
    public Toleration buildLastToleration();
    public Toleration buildMatchingToleration(Predicate<TolerationBuilder> predicate);
    public Boolean hasMatchingToleration(Predicate<TolerationBuilder> predicate);
    public A withTolerations(List<Toleration> tolerations);
    public A withTolerations(Toleration... tolerations);
    public Boolean hasTolerations();
    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.TolerationsNested<A> addNewToleration();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.TolerationsNested<A> addNewTolerationLike(Toleration item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.TolerationsNested<A> setNewTolerationLike(int index,Toleration item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.TolerationsNested<A> editToleration(int index);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.TolerationsNested<A> editFirstToleration();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.TolerationsNested<A> editLastToleration();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.TolerationsNested<A> editMatchingToleration(Predicate<TolerationBuilder> predicate);
    public A addToTopologySpreadConstraints(int index,TopologySpreadConstraint item);
    public A setToTopologySpreadConstraints(int index,TopologySpreadConstraint item);
    public A addToTopologySpreadConstraints(TopologySpreadConstraint... items);
    public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items);
    public A removeFromTopologySpreadConstraints(TopologySpreadConstraint... items);
    public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items);
    public A removeMatchingFromTopologySpreadConstraints(Predicate<TopologySpreadConstraintBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTopologySpreadConstraints instead.
 * @return The buildable object.
 */
@Deprecated public List<TopologySpreadConstraint> getTopologySpreadConstraints();
    public List<TopologySpreadConstraint> buildTopologySpreadConstraints();
    public TopologySpreadConstraint buildTopologySpreadConstraint(int index);
    public TopologySpreadConstraint buildFirstTopologySpreadConstraint();
    public TopologySpreadConstraint buildLastTopologySpreadConstraint();
    public TopologySpreadConstraint buildMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintBuilder> predicate);
    public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintBuilder> predicate);
    public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints);
    public A withTopologySpreadConstraints(TopologySpreadConstraint... topologySpreadConstraints);
    public Boolean hasTopologySpreadConstraints();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.TopologySpreadConstraintsNested<A> addNewTopologySpreadConstraint();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.TopologySpreadConstraintsNested<A> addNewTopologySpreadConstraintLike(TopologySpreadConstraint item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.TopologySpreadConstraintsNested<A> setNewTopologySpreadConstraintLike(int index,TopologySpreadConstraint item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.TopologySpreadConstraintsNested<A> editTopologySpreadConstraint(int index);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.TopologySpreadConstraintsNested<A> editFirstTopologySpreadConstraint();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.TopologySpreadConstraintsNested<A> editLastTopologySpreadConstraint();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.TopologySpreadConstraintsNested<A> editMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintBuilder> predicate);
    public A addToVolumes(int index,Volume item);
    public A setToVolumes(int index,Volume item);
    public A addToVolumes(Volume... items);
    public A addAllToVolumes(Collection<Volume> items);
    public A removeFromVolumes(Volume... items);
    public A removeAllFromVolumes(Collection<Volume> items);
    public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildVolumes instead.
 * @return The buildable object.
 */
@Deprecated public List<Volume> getVolumes();
    public List<Volume> buildVolumes();
    public Volume buildVolume(int index);
    public Volume buildFirstVolume();
    public Volume buildLastVolume();
    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate);
    public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate);
    public A withVolumes(List<Volume> volumes);
    public A withVolumes(Volume... volumes);
    public Boolean hasVolumes();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.VolumesNested<A> addNewVolume();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.VolumesNested<A> setNewVolumeLike(int index,Volume item);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.VolumesNested<A> editVolume(int index);
    public io.fabric8.kubernetes.api.model.PodSpecFluent.VolumesNested<A> editFirstVolume();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.VolumesNested<A> editLastVolume();
    public io.fabric8.kubernetes.api.model.PodSpecFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate);
    public interface AffinityNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AffinityFluent<io.fabric8.kubernetes.api.model.PodSpecFluent.AffinityNested<N>> {

            public N and();
            public N endAffinity();    }


    public interface ContainersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerFluent<io.fabric8.kubernetes.api.model.PodSpecFluent.ContainersNested<N>> {

            public N and();
            public N endContainer();    }


    public interface DnsConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodDNSConfigFluent<io.fabric8.kubernetes.api.model.PodSpecFluent.DnsConfigNested<N>> {

            public N and();
            public N endDnsConfig();    }


    public interface EphemeralContainersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EphemeralContainerFluent<io.fabric8.kubernetes.api.model.PodSpecFluent.EphemeralContainersNested<N>> {

            public N and();
            public N endEphemeralContainer();    }


    public interface HostAliasesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HostAliasFluent<io.fabric8.kubernetes.api.model.PodSpecFluent.HostAliasesNested<N>> {

            public N and();
            public N endHostAlias();    }


    public interface ImagePullSecretsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LocalObjectReferenceFluent<io.fabric8.kubernetes.api.model.PodSpecFluent.ImagePullSecretsNested<N>> {

            public N and();
            public N endImagePullSecret();    }


    public interface InitContainersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerFluent<io.fabric8.kubernetes.api.model.PodSpecFluent.InitContainersNested<N>> {

            public N and();
            public N endInitContainer();    }


    public interface ReadinessGatesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodReadinessGateFluent<io.fabric8.kubernetes.api.model.PodSpecFluent.ReadinessGatesNested<N>> {

            public N and();
            public N endReadinessGate();    }


    public interface SecurityContextNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodSecurityContextFluent<io.fabric8.kubernetes.api.model.PodSpecFluent.SecurityContextNested<N>> {

            public N and();
            public N endSecurityContext();    }


    public interface TolerationsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TolerationFluent<io.fabric8.kubernetes.api.model.PodSpecFluent.TolerationsNested<N>> {

            public N and();
            public N endToleration();    }


    public interface TopologySpreadConstraintsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TopologySpreadConstraintFluent<io.fabric8.kubernetes.api.model.PodSpecFluent.TopologySpreadConstraintsNested<N>> {

            public N and();
            public N endTopologySpreadConstraint();    }


    public interface VolumesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,VolumeFluent<io.fabric8.kubernetes.api.model.PodSpecFluent.VolumesNested<N>> {

            public N and();
            public N endVolume();    }


}
