package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface PodListFluent<A extends PodListFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToItems(int index,Pod item);
    public A setToItems(int index,Pod item);
    public A addToItems(Pod... items);
    public A addAllToItems(Collection<Pod> items);
    public A removeFromItems(Pod... items);
    public A removeAllFromItems(Collection<Pod> items);
    public A removeMatchingFromItems(Predicate<PodBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Pod> getItems();
    public List<Pod> buildItems();
    public Pod buildItem(int index);
    public Pod buildFirstItem();
    public Pod buildLastItem();
    public Pod buildMatchingItem(Predicate<PodBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<PodBuilder> predicate);
    public A withItems(List<Pod> items);
    public A withItems(Pod... items);
    public Boolean hasItems();
    public io.fabric8.kubernetes.api.model.PodListFluent.ItemsNested<A> addNewItem();
    public io.fabric8.kubernetes.api.model.PodListFluent.ItemsNested<A> addNewItemLike(Pod item);
    public io.fabric8.kubernetes.api.model.PodListFluent.ItemsNested<A> setNewItemLike(int index,Pod item);
    public io.fabric8.kubernetes.api.model.PodListFluent.ItemsNested<A> editItem(int index);
    public io.fabric8.kubernetes.api.model.PodListFluent.ItemsNested<A> editFirstItem();
    public io.fabric8.kubernetes.api.model.PodListFluent.ItemsNested<A> editLastItem();
    public io.fabric8.kubernetes.api.model.PodListFluent.ItemsNested<A> editMatchingItem(Predicate<PodBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ListMeta getMetadata();
    public ListMeta buildMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public io.fabric8.kubernetes.api.model.PodListFluent.MetadataNested<A> withNewMetadata();
    public io.fabric8.kubernetes.api.model.PodListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public io.fabric8.kubernetes.api.model.PodListFluent.MetadataNested<A> editMetadata();
    public io.fabric8.kubernetes.api.model.PodListFluent.MetadataNested<A> editOrNewMetadata();
    public io.fabric8.kubernetes.api.model.PodListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodFluent<io.fabric8.kubernetes.api.model.PodListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<io.fabric8.kubernetes.api.model.PodListFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


}
