package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.StringBuffer;

public interface NodeStatusFluent<A extends NodeStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToAddresses(int index,NodeAddress item);
    public A setToAddresses(int index,NodeAddress item);
    public A addToAddresses(NodeAddress... items);
    public A addAllToAddresses(Collection<NodeAddress> items);
    public A removeFromAddresses(NodeAddress... items);
    public A removeAllFromAddresses(Collection<NodeAddress> items);
    public A removeMatchingFromAddresses(Predicate<NodeAddressBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildAddresses instead.
 * @return The buildable object.
 */
@Deprecated public List<NodeAddress> getAddresses();
    public List<NodeAddress> buildAddresses();
    public NodeAddress buildAddress(int index);
    public NodeAddress buildFirstAddress();
    public NodeAddress buildLastAddress();
    public NodeAddress buildMatchingAddress(Predicate<NodeAddressBuilder> predicate);
    public Boolean hasMatchingAddress(Predicate<NodeAddressBuilder> predicate);
    public A withAddresses(List<NodeAddress> addresses);
    public A withAddresses(NodeAddress... addresses);
    public Boolean hasAddresses();
    public A addNewAddress(String address,String type);
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.AddressesNested<A> addNewAddress();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.AddressesNested<A> addNewAddressLike(NodeAddress item);
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.AddressesNested<A> setNewAddressLike(int index,NodeAddress item);
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.AddressesNested<A> editAddress(int index);
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.AddressesNested<A> editFirstAddress();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.AddressesNested<A> editLastAddress();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.AddressesNested<A> editMatchingAddress(Predicate<NodeAddressBuilder> predicate);
    public A addToAllocatable(String key,Quantity value);
    public A addToAllocatable(java.util.Map<String,Quantity> map);
    public A removeFromAllocatable(String key);
    public A removeFromAllocatable(java.util.Map<String,Quantity> map);
    public java.util.Map<String,Quantity> getAllocatable();
    public <K extends Object,V extends Object>A withAllocatable(java.util.Map<String,Quantity> allocatable);
    public Boolean hasAllocatable();
    public A addToCapacity(String key,Quantity value);
    public A addToCapacity(java.util.Map<String,Quantity> map);
    public A removeFromCapacity(String key);
    public A removeFromCapacity(java.util.Map<String,Quantity> map);
    public java.util.Map<String,Quantity> getCapacity();
    public <K extends Object,V extends Object>A withCapacity(java.util.Map<String,Quantity> capacity);
    public Boolean hasCapacity();
    public A addToConditions(int index,NodeCondition item);
    public A setToConditions(int index,NodeCondition item);
    public A addToConditions(NodeCondition... items);
    public A addAllToConditions(Collection<NodeCondition> items);
    public A removeFromConditions(NodeCondition... items);
    public A removeAllFromConditions(Collection<NodeCondition> items);
    public A removeMatchingFromConditions(Predicate<NodeConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<NodeCondition> getConditions();
    public List<NodeCondition> buildConditions();
    public NodeCondition buildCondition(int index);
    public NodeCondition buildFirstCondition();
    public NodeCondition buildLastCondition();
    public NodeCondition buildMatchingCondition(Predicate<NodeConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<NodeConditionBuilder> predicate);
    public A withConditions(List<NodeCondition> conditions);
    public A withConditions(NodeCondition... conditions);
    public Boolean hasConditions();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConditionsNested<A> addNewCondition();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConditionsNested<A> addNewConditionLike(NodeCondition item);
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConditionsNested<A> setNewConditionLike(int index,NodeCondition item);
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConditionsNested<A> editCondition(int index);
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConditionsNested<A> editFirstCondition();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConditionsNested<A> editLastCondition();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<NodeConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConfig instead.
 * @return The buildable object.
 */
@Deprecated public NodeConfigStatus getConfig();
    public NodeConfigStatus buildConfig();
    public A withConfig(NodeConfigStatus config);
    public Boolean hasConfig();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConfigNested<A> withNewConfig();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConfigNested<A> withNewConfigLike(NodeConfigStatus item);
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConfigNested<A> editConfig();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConfigNested<A> editOrNewConfig();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.ConfigNested<A> editOrNewConfigLike(NodeConfigStatus item);
    
/**
 * This method has been deprecated, please use method buildDaemonEndpoints instead.
 * @return The buildable object.
 */
@Deprecated public NodeDaemonEndpoints getDaemonEndpoints();
    public NodeDaemonEndpoints buildDaemonEndpoints();
    public A withDaemonEndpoints(NodeDaemonEndpoints daemonEndpoints);
    public Boolean hasDaemonEndpoints();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.DaemonEndpointsNested<A> withNewDaemonEndpoints();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.DaemonEndpointsNested<A> withNewDaemonEndpointsLike(NodeDaemonEndpoints item);
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.DaemonEndpointsNested<A> editDaemonEndpoints();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.DaemonEndpointsNested<A> editOrNewDaemonEndpoints();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.DaemonEndpointsNested<A> editOrNewDaemonEndpointsLike(NodeDaemonEndpoints item);
    public A addToImages(int index,ContainerImage item);
    public A setToImages(int index,ContainerImage item);
    public A addToImages(ContainerImage... items);
    public A addAllToImages(Collection<ContainerImage> items);
    public A removeFromImages(ContainerImage... items);
    public A removeAllFromImages(Collection<ContainerImage> items);
    public A removeMatchingFromImages(Predicate<ContainerImageBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildImages instead.
 * @return The buildable object.
 */
@Deprecated public List<ContainerImage> getImages();
    public List<ContainerImage> buildImages();
    public ContainerImage buildImage(int index);
    public ContainerImage buildFirstImage();
    public ContainerImage buildLastImage();
    public ContainerImage buildMatchingImage(Predicate<ContainerImageBuilder> predicate);
    public Boolean hasMatchingImage(Predicate<ContainerImageBuilder> predicate);
    public A withImages(List<ContainerImage> images);
    public A withImages(ContainerImage... images);
    public Boolean hasImages();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.ImagesNested<A> addNewImage();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.ImagesNested<A> addNewImageLike(ContainerImage item);
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.ImagesNested<A> setNewImageLike(int index,ContainerImage item);
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.ImagesNested<A> editImage(int index);
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.ImagesNested<A> editFirstImage();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.ImagesNested<A> editLastImage();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.ImagesNested<A> editMatchingImage(Predicate<ContainerImageBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildNodeInfo instead.
 * @return The buildable object.
 */
@Deprecated public NodeSystemInfo getNodeInfo();
    public NodeSystemInfo buildNodeInfo();
    public A withNodeInfo(NodeSystemInfo nodeInfo);
    public Boolean hasNodeInfo();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.NodeInfoNested<A> withNewNodeInfo();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.NodeInfoNested<A> withNewNodeInfoLike(NodeSystemInfo item);
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.NodeInfoNested<A> editNodeInfo();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.NodeInfoNested<A> editOrNewNodeInfo();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.NodeInfoNested<A> editOrNewNodeInfoLike(NodeSystemInfo item);
    public String getPhase();
    public A withPhase(String phase);
    public Boolean hasPhase();
    public A withNewPhase(StringBuilder arg1);
    public A withNewPhase(int[] arg1,int arg2,int arg3);
    public A withNewPhase(char[] arg1);
    public A withNewPhase(StringBuffer arg1);
    public A withNewPhase(byte[] arg1,int arg2);
    public A withNewPhase(byte[] arg1);
    public A withNewPhase(char[] arg1,int arg2,int arg3);
    public A withNewPhase(byte[] arg1,int arg2,int arg3);
    public A withNewPhase(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewPhase(String arg1);
    public A addToVolumesAttached(int index,AttachedVolume item);
    public A setToVolumesAttached(int index,AttachedVolume item);
    public A addToVolumesAttached(AttachedVolume... items);
    public A addAllToVolumesAttached(Collection<AttachedVolume> items);
    public A removeFromVolumesAttached(AttachedVolume... items);
    public A removeAllFromVolumesAttached(Collection<AttachedVolume> items);
    public A removeMatchingFromVolumesAttached(Predicate<AttachedVolumeBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildVolumesAttached instead.
 * @return The buildable object.
 */
@Deprecated public List<AttachedVolume> getVolumesAttached();
    public List<AttachedVolume> buildVolumesAttached();
    public AttachedVolume buildVolumesAttached(int index);
    public AttachedVolume buildFirstVolumesAttached();
    public AttachedVolume buildLastVolumesAttached();
    public AttachedVolume buildMatchingVolumesAttached(Predicate<AttachedVolumeBuilder> predicate);
    public Boolean hasMatchingVolumesAttached(Predicate<AttachedVolumeBuilder> predicate);
    public A withVolumesAttached(List<AttachedVolume> volumesAttached);
    public A withVolumesAttached(AttachedVolume... volumesAttached);
    public Boolean hasVolumesAttached();
    public A addNewVolumesAttached(String devicePath,String name);
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.VolumesAttachedNested<A> addNewVolumesAttached();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.VolumesAttachedNested<A> addNewVolumesAttachedLike(AttachedVolume item);
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.VolumesAttachedNested<A> setNewVolumesAttachedLike(int index,AttachedVolume item);
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.VolumesAttachedNested<A> editVolumesAttached(int index);
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.VolumesAttachedNested<A> editFirstVolumesAttached();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.VolumesAttachedNested<A> editLastVolumesAttached();
    public io.fabric8.kubernetes.api.model.NodeStatusFluent.VolumesAttachedNested<A> editMatchingVolumesAttached(Predicate<AttachedVolumeBuilder> predicate);
    public A addToVolumesInUse(int index,String item);
    public A setToVolumesInUse(int index,String item);
    public A addToVolumesInUse(String... items);
    public A addAllToVolumesInUse(Collection<String> items);
    public A removeFromVolumesInUse(String... items);
    public A removeAllFromVolumesInUse(Collection<String> items);
    public List<String> getVolumesInUse();
    public String getVolumesInUse(int index);
    public String getFirstVolumesInUse();
    public String getLastVolumesInUse();
    public String getMatchingVolumesInUse(Predicate<String> predicate);
    public Boolean hasMatchingVolumesInUse(Predicate<String> predicate);
    public A withVolumesInUse(List<String> volumesInUse);
    public A withVolumesInUse(String... volumesInUse);
    public Boolean hasVolumesInUse();
    public A addNewVolumesInUse(StringBuilder arg1);
    public A addNewVolumesInUse(int[] arg1,int arg2,int arg3);
    public A addNewVolumesInUse(char[] arg1);
    public A addNewVolumesInUse(StringBuffer arg1);
    public A addNewVolumesInUse(byte[] arg1,int arg2);
    public A addNewVolumesInUse(byte[] arg1);
    public A addNewVolumesInUse(char[] arg1,int arg2,int arg3);
    public A addNewVolumesInUse(byte[] arg1,int arg2,int arg3);
    public A addNewVolumesInUse(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewVolumesInUse(String arg1);
    public interface AddressesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NodeAddressFluent<io.fabric8.kubernetes.api.model.NodeStatusFluent.AddressesNested<N>> {

            public N and();
            public N endAddress();    }


    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NodeConditionFluent<io.fabric8.kubernetes.api.model.NodeStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface ConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NodeConfigStatusFluent<io.fabric8.kubernetes.api.model.NodeStatusFluent.ConfigNested<N>> {

            public N and();
            public N endConfig();    }


    public interface DaemonEndpointsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NodeDaemonEndpointsFluent<io.fabric8.kubernetes.api.model.NodeStatusFluent.DaemonEndpointsNested<N>> {

            public N and();
            public N endDaemonEndpoints();    }


    public interface ImagesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerImageFluent<io.fabric8.kubernetes.api.model.NodeStatusFluent.ImagesNested<N>> {

            public N and();
            public N endImage();    }


    public interface NodeInfoNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NodeSystemInfoFluent<io.fabric8.kubernetes.api.model.NodeStatusFluent.NodeInfoNested<N>> {

            public N and();
            public N endNodeInfo();    }


    public interface VolumesAttachedNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AttachedVolumeFluent<io.fabric8.kubernetes.api.model.NodeStatusFluent.VolumesAttachedNested<N>> {

            public N and();
            public N endVolumesAttached();    }


}
