package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CreateOptionsBuilder extends CreateOptionsFluentImpl<CreateOptionsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<CreateOptions,CreateOptionsBuilder> {

    CreateOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public CreateOptionsBuilder() {
        this(true);
    }

    public CreateOptionsBuilder(Boolean validationEnabled) {
        this(new CreateOptions(), validationEnabled);
    }

    public CreateOptionsBuilder(CreateOptionsFluent<?> fluent) {
        this(fluent, true);
    }

    public CreateOptionsBuilder(CreateOptionsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CreateOptions(), validationEnabled);
    }

    public CreateOptionsBuilder(CreateOptionsFluent<?> fluent,CreateOptions instance) {
        this(fluent, instance, true);
    }

    public CreateOptionsBuilder(CreateOptionsFluent<?> fluent,CreateOptions instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withDryRun(instance.getDryRun()); 
        fluent.withFieldManager(instance.getFieldManager()); 
        fluent.withKind(instance.getKind()); 
        this.validationEnabled = validationEnabled; 
    }

    public CreateOptionsBuilder(CreateOptions instance) {
        this(instance,true);
    }

    public CreateOptionsBuilder(CreateOptions instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withDryRun(instance.getDryRun()); 
        this.withFieldManager(instance.getFieldManager()); 
        this.withKind(instance.getKind()); 
        this.validationEnabled = validationEnabled; 
    }

    public CreateOptions build() {
        CreateOptions buildable = new CreateOptions(fluent.getApiVersion(),fluent.getDryRun(),fluent.getFieldManager(),fluent.getKind());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CreateOptionsBuilder that = (CreateOptionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
