package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class UpdateOptionsBuilder extends UpdateOptionsFluentImpl<UpdateOptionsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<UpdateOptions,UpdateOptionsBuilder> {

    UpdateOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public UpdateOptionsBuilder() {
        this(true);
    }

    public UpdateOptionsBuilder(Boolean validationEnabled) {
        this(new UpdateOptions(), validationEnabled);
    }

    public UpdateOptionsBuilder(UpdateOptionsFluent<?> fluent) {
        this(fluent, true);
    }

    public UpdateOptionsBuilder(UpdateOptionsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new UpdateOptions(), validationEnabled);
    }

    public UpdateOptionsBuilder(UpdateOptionsFluent<?> fluent,UpdateOptions instance) {
        this(fluent, instance, true);
    }

    public UpdateOptionsBuilder(UpdateOptionsFluent<?> fluent,UpdateOptions instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withDryRun(instance.getDryRun()); 
        fluent.withFieldManager(instance.getFieldManager()); 
        fluent.withKind(instance.getKind()); 
        this.validationEnabled = validationEnabled; 
    }

    public UpdateOptionsBuilder(UpdateOptions instance) {
        this(instance,true);
    }

    public UpdateOptionsBuilder(UpdateOptions instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withDryRun(instance.getDryRun()); 
        this.withFieldManager(instance.getFieldManager()); 
        this.withKind(instance.getKind()); 
        this.validationEnabled = validationEnabled; 
    }

    public UpdateOptions build() {
        UpdateOptions buildable = new UpdateOptions(fluent.getApiVersion(),fluent.getDryRun(),fluent.getFieldManager(),fluent.getKind());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        UpdateOptionsBuilder that = (UpdateOptionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
