package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class TopologySpreadConstraintFluentImpl<A extends TopologySpreadConstraintFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TopologySpreadConstraintFluent<A> {

    private LabelSelectorBuilder labelSelector;
    private Integer maxSkew;
    private String topologyKey;
    private String whenUnsatisfiable;

    public TopologySpreadConstraintFluentImpl() {
    }

    public TopologySpreadConstraintFluentImpl(TopologySpreadConstraint instance) {
        this.withLabelSelector(instance.getLabelSelector()); 
        this.withMaxSkew(instance.getMaxSkew()); 
        this.withTopologyKey(instance.getTopologyKey()); 
        this.withWhenUnsatisfiable(instance.getWhenUnsatisfiable()); 
    }

    
/**
 * This method has been deprecated, please use method buildLabelSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getLabelSelector() {
        return this.labelSelector!=null?this.labelSelector.build():null;
    }

    public LabelSelector buildLabelSelector() {
        return this.labelSelector!=null?this.labelSelector.build():null;
    }

    public A withLabelSelector(LabelSelector labelSelector) {
        _visitables.get("labelSelector").remove(this.labelSelector);
        if (labelSelector!=null){ this.labelSelector= new LabelSelectorBuilder(labelSelector); _visitables.get("labelSelector").add(this.labelSelector);} return (A) this;
    }

    public Boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    public io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent.LabelSelectorNested<A> withNewLabelSelector() {
        return new LabelSelectorNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent.LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelector item) {
        return new LabelSelectorNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent.LabelSelectorNested<A> editLabelSelector() {
        return withNewLabelSelectorLike(getLabelSelector());
    }

    public io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent.LabelSelectorNested<A> editOrNewLabelSelector() {
        return withNewLabelSelectorLike(getLabelSelector() != null ? getLabelSelector(): new LabelSelectorBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent.LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelector item) {
        return withNewLabelSelectorLike(getLabelSelector() != null ? getLabelSelector(): item);
    }

    public Integer getMaxSkew() {
        return this.maxSkew;
    }

    public A withMaxSkew(Integer maxSkew) {
        this.maxSkew=maxSkew; return (A) this;
    }

    public Boolean hasMaxSkew() {
        return this.maxSkew != null;
    }

    public A withNewMaxSkew(int arg0) {
        return (A)withMaxSkew(new Integer(arg0));
    }

    public String getTopologyKey() {
        return this.topologyKey;
    }

    public A withTopologyKey(String topologyKey) {
        this.topologyKey=topologyKey; return (A) this;
    }

    public Boolean hasTopologyKey() {
        return this.topologyKey != null;
    }

    public A withNewTopologyKey(StringBuilder arg1) {
        return (A)withTopologyKey(new String(arg1));
    }

    public A withNewTopologyKey(int[] arg1,int arg2,int arg3) {
        return (A)withTopologyKey(new String(arg1, arg2, arg3));
    }

    public A withNewTopologyKey(char[] arg1) {
        return (A)withTopologyKey(new String(arg1));
    }

    public A withNewTopologyKey(StringBuffer arg1) {
        return (A)withTopologyKey(new String(arg1));
    }

    public A withNewTopologyKey(byte[] arg1,int arg2) {
        return (A)withTopologyKey(new String(arg1, arg2));
    }

    public A withNewTopologyKey(byte[] arg1) {
        return (A)withTopologyKey(new String(arg1));
    }

    public A withNewTopologyKey(char[] arg1,int arg2,int arg3) {
        return (A)withTopologyKey(new String(arg1, arg2, arg3));
    }

    public A withNewTopologyKey(byte[] arg1,int arg2,int arg3) {
        return (A)withTopologyKey(new String(arg1, arg2, arg3));
    }

    public A withNewTopologyKey(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withTopologyKey(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewTopologyKey(String arg1) {
        return (A)withTopologyKey(new String(arg1));
    }

    public String getWhenUnsatisfiable() {
        return this.whenUnsatisfiable;
    }

    public A withWhenUnsatisfiable(String whenUnsatisfiable) {
        this.whenUnsatisfiable=whenUnsatisfiable; return (A) this;
    }

    public Boolean hasWhenUnsatisfiable() {
        return this.whenUnsatisfiable != null;
    }

    public A withNewWhenUnsatisfiable(StringBuilder arg1) {
        return (A)withWhenUnsatisfiable(new String(arg1));
    }

    public A withNewWhenUnsatisfiable(int[] arg1,int arg2,int arg3) {
        return (A)withWhenUnsatisfiable(new String(arg1, arg2, arg3));
    }

    public A withNewWhenUnsatisfiable(char[] arg1) {
        return (A)withWhenUnsatisfiable(new String(arg1));
    }

    public A withNewWhenUnsatisfiable(StringBuffer arg1) {
        return (A)withWhenUnsatisfiable(new String(arg1));
    }

    public A withNewWhenUnsatisfiable(byte[] arg1,int arg2) {
        return (A)withWhenUnsatisfiable(new String(arg1, arg2));
    }

    public A withNewWhenUnsatisfiable(byte[] arg1) {
        return (A)withWhenUnsatisfiable(new String(arg1));
    }

    public A withNewWhenUnsatisfiable(char[] arg1,int arg2,int arg3) {
        return (A)withWhenUnsatisfiable(new String(arg1, arg2, arg3));
    }

    public A withNewWhenUnsatisfiable(byte[] arg1,int arg2,int arg3) {
        return (A)withWhenUnsatisfiable(new String(arg1, arg2, arg3));
    }

    public A withNewWhenUnsatisfiable(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withWhenUnsatisfiable(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewWhenUnsatisfiable(String arg1) {
        return (A)withWhenUnsatisfiable(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TopologySpreadConstraintFluentImpl that = (TopologySpreadConstraintFluentImpl) o;
        if (labelSelector != null ? !labelSelector.equals(that.labelSelector) :that.labelSelector != null) return false;
        if (maxSkew != null ? !maxSkew.equals(that.maxSkew) :that.maxSkew != null) return false;
        if (topologyKey != null ? !topologyKey.equals(that.topologyKey) :that.topologyKey != null) return false;
        if (whenUnsatisfiable != null ? !whenUnsatisfiable.equals(that.whenUnsatisfiable) :that.whenUnsatisfiable != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(labelSelector,  maxSkew,  topologyKey,  whenUnsatisfiable,  super.hashCode());
    }

    public class LabelSelectorNestedImpl<N> extends LabelSelectorFluentImpl<io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent.LabelSelectorNested<N>> implements io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent.LabelSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

            LabelSelectorNestedImpl(LabelSelector item) {
                this.builder = new LabelSelectorBuilder(this, item);
                        
            }

            LabelSelectorNestedImpl() {
                this.builder = new LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) TopologySpreadConstraintFluentImpl.this.withLabelSelector(builder.build());
            }

            public N endLabelSelector() {
                return and();
            }
    }


}
