package io.fabric8.kubernetes.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class TaintFluentImpl<A extends TaintFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TaintFluent<A> {

    private String effect;
    private String key;
    private String timeAdded;
    private String value;

    public TaintFluentImpl() {
    }

    public TaintFluentImpl(Taint instance) {
        this.withEffect(instance.getEffect()); 
        this.withKey(instance.getKey()); 
        this.withTimeAdded(instance.getTimeAdded()); 
        this.withValue(instance.getValue()); 
    }

    public String getEffect() {
        return this.effect;
    }

    public A withEffect(String effect) {
        this.effect=effect; return (A) this;
    }

    public Boolean hasEffect() {
        return this.effect != null;
    }

    public A withNewEffect(StringBuilder arg1) {
        return (A)withEffect(new String(arg1));
    }

    public A withNewEffect(int[] arg1,int arg2,int arg3) {
        return (A)withEffect(new String(arg1, arg2, arg3));
    }

    public A withNewEffect(char[] arg1) {
        return (A)withEffect(new String(arg1));
    }

    public A withNewEffect(StringBuffer arg1) {
        return (A)withEffect(new String(arg1));
    }

    public A withNewEffect(byte[] arg1,int arg2) {
        return (A)withEffect(new String(arg1, arg2));
    }

    public A withNewEffect(byte[] arg1) {
        return (A)withEffect(new String(arg1));
    }

    public A withNewEffect(char[] arg1,int arg2,int arg3) {
        return (A)withEffect(new String(arg1, arg2, arg3));
    }

    public A withNewEffect(byte[] arg1,int arg2,int arg3) {
        return (A)withEffect(new String(arg1, arg2, arg3));
    }

    public A withNewEffect(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withEffect(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewEffect(String arg1) {
        return (A)withEffect(new String(arg1));
    }

    public String getKey() {
        return this.key;
    }

    public A withKey(String key) {
        this.key=key; return (A) this;
    }

    public Boolean hasKey() {
        return this.key != null;
    }

    public A withNewKey(StringBuilder arg1) {
        return (A)withKey(new String(arg1));
    }

    public A withNewKey(int[] arg1,int arg2,int arg3) {
        return (A)withKey(new String(arg1, arg2, arg3));
    }

    public A withNewKey(char[] arg1) {
        return (A)withKey(new String(arg1));
    }

    public A withNewKey(StringBuffer arg1) {
        return (A)withKey(new String(arg1));
    }

    public A withNewKey(byte[] arg1,int arg2) {
        return (A)withKey(new String(arg1, arg2));
    }

    public A withNewKey(byte[] arg1) {
        return (A)withKey(new String(arg1));
    }

    public A withNewKey(char[] arg1,int arg2,int arg3) {
        return (A)withKey(new String(arg1, arg2, arg3));
    }

    public A withNewKey(byte[] arg1,int arg2,int arg3) {
        return (A)withKey(new String(arg1, arg2, arg3));
    }

    public A withNewKey(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKey(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKey(String arg1) {
        return (A)withKey(new String(arg1));
    }

    public String getTimeAdded() {
        return this.timeAdded;
    }

    public A withTimeAdded(String timeAdded) {
        this.timeAdded=timeAdded; return (A) this;
    }

    public Boolean hasTimeAdded() {
        return this.timeAdded != null;
    }

    public A withNewTimeAdded(StringBuilder arg1) {
        return (A)withTimeAdded(new String(arg1));
    }

    public A withNewTimeAdded(int[] arg1,int arg2,int arg3) {
        return (A)withTimeAdded(new String(arg1, arg2, arg3));
    }

    public A withNewTimeAdded(char[] arg1) {
        return (A)withTimeAdded(new String(arg1));
    }

    public A withNewTimeAdded(StringBuffer arg1) {
        return (A)withTimeAdded(new String(arg1));
    }

    public A withNewTimeAdded(byte[] arg1,int arg2) {
        return (A)withTimeAdded(new String(arg1, arg2));
    }

    public A withNewTimeAdded(byte[] arg1) {
        return (A)withTimeAdded(new String(arg1));
    }

    public A withNewTimeAdded(char[] arg1,int arg2,int arg3) {
        return (A)withTimeAdded(new String(arg1, arg2, arg3));
    }

    public A withNewTimeAdded(byte[] arg1,int arg2,int arg3) {
        return (A)withTimeAdded(new String(arg1, arg2, arg3));
    }

    public A withNewTimeAdded(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withTimeAdded(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewTimeAdded(String arg1) {
        return (A)withTimeAdded(new String(arg1));
    }

    public String getValue() {
        return this.value;
    }

    public A withValue(String value) {
        this.value=value; return (A) this;
    }

    public Boolean hasValue() {
        return this.value != null;
    }

    public A withNewValue(StringBuilder arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(int[] arg1,int arg2,int arg3) {
        return (A)withValue(new String(arg1, arg2, arg3));
    }

    public A withNewValue(char[] arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuffer arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(byte[] arg1,int arg2) {
        return (A)withValue(new String(arg1, arg2));
    }

    public A withNewValue(byte[] arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(char[] arg1,int arg2,int arg3) {
        return (A)withValue(new String(arg1, arg2, arg3));
    }

    public A withNewValue(byte[] arg1,int arg2,int arg3) {
        return (A)withValue(new String(arg1, arg2, arg3));
    }

    public A withNewValue(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withValue(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewValue(String arg1) {
        return (A)withValue(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TaintFluentImpl that = (TaintFluentImpl) o;
        if (effect != null ? !effect.equals(that.effect) :that.effect != null) return false;
        if (key != null ? !key.equals(that.key) :that.key != null) return false;
        if (timeAdded != null ? !timeAdded.equals(that.timeAdded) :that.timeAdded != null) return false;
        if (value != null ? !value.equals(that.value) :that.value != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(effect,  key,  timeAdded,  value,  super.hashCode());
    }

}
