package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface SecretVolumeSourceFluent<A extends SecretVolumeSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Integer getDefaultMode();
    public A withDefaultMode(Integer defaultMode);
    public Boolean hasDefaultMode();
    public A withNewDefaultMode(int arg0);
    public A addToItems(int index,KeyToPath item);
    public A setToItems(int index,KeyToPath item);
    public A addToItems(KeyToPath... items);
    public A addAllToItems(Collection<KeyToPath> items);
    public A removeFromItems(KeyToPath... items);
    public A removeAllFromItems(Collection<KeyToPath> items);
    public A removeMatchingFromItems(Predicate<KeyToPathBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<KeyToPath> getItems();
    public List<KeyToPath> buildItems();
    public KeyToPath buildItem(int index);
    public KeyToPath buildFirstItem();
    public KeyToPath buildLastItem();
    public KeyToPath buildMatchingItem(Predicate<KeyToPathBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<KeyToPathBuilder> predicate);
    public A withItems(List<KeyToPath> items);
    public A withItems(KeyToPath... items);
    public Boolean hasItems();
    public A addNewItem(String key,Integer mode,String path);
    public io.fabric8.kubernetes.api.model.SecretVolumeSourceFluent.ItemsNested<A> addNewItem();
    public io.fabric8.kubernetes.api.model.SecretVolumeSourceFluent.ItemsNested<A> addNewItemLike(KeyToPath item);
    public io.fabric8.kubernetes.api.model.SecretVolumeSourceFluent.ItemsNested<A> setNewItemLike(int index,KeyToPath item);
    public io.fabric8.kubernetes.api.model.SecretVolumeSourceFluent.ItemsNested<A> editItem(int index);
    public io.fabric8.kubernetes.api.model.SecretVolumeSourceFluent.ItemsNested<A> editFirstItem();
    public io.fabric8.kubernetes.api.model.SecretVolumeSourceFluent.ItemsNested<A> editLastItem();
    public io.fabric8.kubernetes.api.model.SecretVolumeSourceFluent.ItemsNested<A> editMatchingItem(Predicate<KeyToPathBuilder> predicate);
    public Boolean getOptional();
    public A withOptional(Boolean optional);
    public Boolean hasOptional();
    public A withNewOptional(String arg1);
    public A withNewOptional(boolean arg1);
    public String getSecretName();
    public A withSecretName(String secretName);
    public Boolean hasSecretName();
    public A withNewSecretName(StringBuilder arg1);
    public A withNewSecretName(int[] arg1,int arg2,int arg3);
    public A withNewSecretName(char[] arg1);
    public A withNewSecretName(StringBuffer arg1);
    public A withNewSecretName(byte[] arg1,int arg2);
    public A withNewSecretName(byte[] arg1);
    public A withNewSecretName(char[] arg1,int arg2,int arg3);
    public A withNewSecretName(byte[] arg1,int arg2,int arg3);
    public A withNewSecretName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewSecretName(String arg1);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KeyToPathFluent<io.fabric8.kubernetes.api.model.SecretVolumeSourceFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
