package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface SecretFluent<A extends SecretFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToData(String key,String value);
    public A addToData(java.util.Map<String,String> map);
    public A removeFromData(String key);
    public A removeFromData(java.util.Map<String,String> map);
    public java.util.Map<String,String> getData();
    public <K extends Object,V extends Object>A withData(java.util.Map<String,String> data);
    public Boolean hasData();
    public Boolean getImmutable();
    public A withImmutable(Boolean immutable);
    public Boolean hasImmutable();
    public A withNewImmutable(String arg1);
    public A withNewImmutable(boolean arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public io.fabric8.kubernetes.api.model.SecretFluent.MetadataNested<A> withNewMetadata();
    public io.fabric8.kubernetes.api.model.SecretFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public io.fabric8.kubernetes.api.model.SecretFluent.MetadataNested<A> editMetadata();
    public io.fabric8.kubernetes.api.model.SecretFluent.MetadataNested<A> editOrNewMetadata();
    public io.fabric8.kubernetes.api.model.SecretFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public A addToStringData(String key,String value);
    public A addToStringData(java.util.Map<String,String> map);
    public A removeFromStringData(String key);
    public A removeFromStringData(java.util.Map<String,String> map);
    public java.util.Map<String,String> getStringData();
    public <K extends Object,V extends Object>A withStringData(java.util.Map<String,String> stringData);
    public Boolean hasStringData();
    public String getType();
    public A withType(String type);
    public Boolean hasType();
    public A withNewType(StringBuilder arg1);
    public A withNewType(int[] arg1,int arg2,int arg3);
    public A withNewType(char[] arg1);
    public A withNewType(StringBuffer arg1);
    public A withNewType(byte[] arg1,int arg2);
    public A withNewType(byte[] arg1);
    public A withNewType(char[] arg1,int arg2,int arg3);
    public A withNewType(byte[] arg1,int arg2,int arg3);
    public A withNewType(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewType(String arg1);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<io.fabric8.kubernetes.api.model.SecretFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


}
