package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ReplicationControllerStatusFluent<A extends ReplicationControllerStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Integer getAvailableReplicas();
    public A withAvailableReplicas(Integer availableReplicas);
    public Boolean hasAvailableReplicas();
    public A withNewAvailableReplicas(int arg0);
    public A addToConditions(int index,ReplicationControllerCondition item);
    public A setToConditions(int index,ReplicationControllerCondition item);
    public A addToConditions(ReplicationControllerCondition... items);
    public A addAllToConditions(Collection<ReplicationControllerCondition> items);
    public A removeFromConditions(ReplicationControllerCondition... items);
    public A removeAllFromConditions(Collection<ReplicationControllerCondition> items);
    public A removeMatchingFromConditions(Predicate<ReplicationControllerConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<ReplicationControllerCondition> getConditions();
    public List<ReplicationControllerCondition> buildConditions();
    public ReplicationControllerCondition buildCondition(int index);
    public ReplicationControllerCondition buildFirstCondition();
    public ReplicationControllerCondition buildLastCondition();
    public ReplicationControllerCondition buildMatchingCondition(Predicate<ReplicationControllerConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<ReplicationControllerConditionBuilder> predicate);
    public A withConditions(List<ReplicationControllerCondition> conditions);
    public A withConditions(ReplicationControllerCondition... conditions);
    public Boolean hasConditions();
    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
    public io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluent.ConditionsNested<A> addNewCondition();
    public io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluent.ConditionsNested<A> addNewConditionLike(ReplicationControllerCondition item);
    public io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluent.ConditionsNested<A> setNewConditionLike(int index,ReplicationControllerCondition item);
    public io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluent.ConditionsNested<A> editCondition(int index);
    public io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluent.ConditionsNested<A> editFirstCondition();
    public io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluent.ConditionsNested<A> editLastCondition();
    public io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ReplicationControllerConditionBuilder> predicate);
    public Integer getFullyLabeledReplicas();
    public A withFullyLabeledReplicas(Integer fullyLabeledReplicas);
    public Boolean hasFullyLabeledReplicas();
    public A withNewFullyLabeledReplicas(int arg0);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public A withNewObservedGeneration(long arg1);
    public Integer getReadyReplicas();
    public A withReadyReplicas(Integer readyReplicas);
    public Boolean hasReadyReplicas();
    public A withNewReadyReplicas(int arg0);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public A withNewReplicas(int arg0);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ReplicationControllerConditionFluent<io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


}
