package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ReplicationControllerSpecFluent<A extends ReplicationControllerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Integer getMinReadySeconds();
    public A withMinReadySeconds(Integer minReadySeconds);
    public Boolean hasMinReadySeconds();
    public A withNewMinReadySeconds(int arg0);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public A withNewReplicas(int arg0);
    public A addToSelector(String key,String value);
    public A addToSelector(java.util.Map<String,String> map);
    public A removeFromSelector(String key);
    public A removeFromSelector(java.util.Map<String,String> map);
    public java.util.Map<String,String> getSelector();
    public <K extends Object,V extends Object>A withSelector(java.util.Map<String,String> selector);
    public Boolean hasSelector();
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplateSpec getTemplate();
    public PodTemplateSpec buildTemplate();
    public A withTemplate(PodTemplateSpec template);
    public Boolean hasTemplate();
    public io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent.TemplateNested<A> withNewTemplate();
    public io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
    public io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent.TemplateNested<A> editTemplate();
    public io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent.TemplateNested<A> editOrNewTemplate();
    public io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item);
    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodTemplateSpecFluent<io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent.TemplateNested<N>> {

            public N and();
            public N endTemplate();    }


}
