package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodExecOptionsBuilder extends PodExecOptionsFluentImpl<PodExecOptionsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<PodExecOptions,PodExecOptionsBuilder> {

    PodExecOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public PodExecOptionsBuilder() {
        this(true);
    }

    public PodExecOptionsBuilder(Boolean validationEnabled) {
        this(new PodExecOptions(), validationEnabled);
    }

    public PodExecOptionsBuilder(PodExecOptionsFluent<?> fluent) {
        this(fluent, true);
    }

    public PodExecOptionsBuilder(PodExecOptionsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PodExecOptions(), validationEnabled);
    }

    public PodExecOptionsBuilder(PodExecOptionsFluent<?> fluent,PodExecOptions instance) {
        this(fluent, instance, true);
    }

    public PodExecOptionsBuilder(PodExecOptionsFluent<?> fluent,PodExecOptions instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withCommand(instance.getCommand()); 
        fluent.withContainer(instance.getContainer()); 
        fluent.withKind(instance.getKind()); 
        fluent.withStderr(instance.getStderr()); 
        fluent.withStdin(instance.getStdin()); 
        fluent.withStdout(instance.getStdout()); 
        fluent.withTty(instance.getTty()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodExecOptionsBuilder(PodExecOptions instance) {
        this(instance,true);
    }

    public PodExecOptionsBuilder(PodExecOptions instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withCommand(instance.getCommand()); 
        this.withContainer(instance.getContainer()); 
        this.withKind(instance.getKind()); 
        this.withStderr(instance.getStderr()); 
        this.withStdin(instance.getStdin()); 
        this.withStdout(instance.getStdout()); 
        this.withTty(instance.getTty()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodExecOptions build() {
        PodExecOptions buildable = new PodExecOptions(fluent.getApiVersion(),fluent.getCommand(),fluent.getContainer(),fluent.getKind(),fluent.getStderr(),fluent.getStdin(),fluent.getStdout(),fluent.getTty());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodExecOptionsBuilder that = (PodExecOptionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
