package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class LimitRangeItemFluentImpl<A extends LimitRangeItemFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements LimitRangeItemFluent<A> {

    private java.util.Map<String,Quantity> _default;
    private java.util.Map<String,Quantity> defaultRequest;
    private java.util.Map<String,Quantity> max;
    private java.util.Map<String,Quantity> maxLimitRequestRatio;
    private java.util.Map<String,Quantity> min;
    private String type;

    public LimitRangeItemFluentImpl() {
    }

    public LimitRangeItemFluentImpl(LimitRangeItem instance) {
        this.withDefault(instance.getDefault()); 
        this.withDefaultRequest(instance.getDefaultRequest()); 
        this.withMax(instance.getMax()); 
        this.withMaxLimitRequestRatio(instance.getMaxLimitRequestRatio()); 
        this.withMin(instance.getMin()); 
        this.withType(instance.getType()); 
    }

    public A addToDefault(String key,Quantity value) {
        if(this._default == null && key != null && value != null) { this._default = new LinkedHashMap<String,Quantity>(); }
        if(key != null && value != null) {this._default.put(key, value);} return (A)this;
    }

    public A addToDefault(java.util.Map<String,Quantity> map) {
        if(this._default == null && map != null) { this._default = new LinkedHashMap<String,Quantity>(); }
        if(map != null) { this._default.putAll(map);} return (A)this;
    }

    public A removeFromDefault(String key) {
        if(this._default == null) { return (A) this; }
        if(key != null && this._default != null) {this._default.remove(key);} return (A)this;
    }

    public A removeFromDefault(java.util.Map<String,Quantity> map) {
        if(this._default == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this._default != null){this._default.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,Quantity> getDefault() {
        return this._default;
    }

    public <K extends Object,V extends Object>A withDefault(java.util.Map<String,Quantity> _default) {
        if (_default == null) { this._default =  null;} else {this._default = new LinkedHashMap<String,Quantity>(_default);} return (A) this;
    }

    public Boolean hasDefault() {
        return this._default != null;
    }

    public A addToDefaultRequest(String key,Quantity value) {
        if(this.defaultRequest == null && key != null && value != null) { this.defaultRequest = new LinkedHashMap<String,Quantity>(); }
        if(key != null && value != null) {this.defaultRequest.put(key, value);} return (A)this;
    }

    public A addToDefaultRequest(java.util.Map<String,Quantity> map) {
        if(this.defaultRequest == null && map != null) { this.defaultRequest = new LinkedHashMap<String,Quantity>(); }
        if(map != null) { this.defaultRequest.putAll(map);} return (A)this;
    }

    public A removeFromDefaultRequest(String key) {
        if(this.defaultRequest == null) { return (A) this; }
        if(key != null && this.defaultRequest != null) {this.defaultRequest.remove(key);} return (A)this;
    }

    public A removeFromDefaultRequest(java.util.Map<String,Quantity> map) {
        if(this.defaultRequest == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.defaultRequest != null){this.defaultRequest.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,Quantity> getDefaultRequest() {
        return this.defaultRequest;
    }

    public <K extends Object,V extends Object>A withDefaultRequest(java.util.Map<String,Quantity> defaultRequest) {
        if (defaultRequest == null) { this.defaultRequest =  null;} else {this.defaultRequest = new LinkedHashMap<String,Quantity>(defaultRequest);} return (A) this;
    }

    public Boolean hasDefaultRequest() {
        return this.defaultRequest != null;
    }

    public A addToMax(String key,Quantity value) {
        if(this.max == null && key != null && value != null) { this.max = new LinkedHashMap<String,Quantity>(); }
        if(key != null && value != null) {this.max.put(key, value);} return (A)this;
    }

    public A addToMax(java.util.Map<String,Quantity> map) {
        if(this.max == null && map != null) { this.max = new LinkedHashMap<String,Quantity>(); }
        if(map != null) { this.max.putAll(map);} return (A)this;
    }

    public A removeFromMax(String key) {
        if(this.max == null) { return (A) this; }
        if(key != null && this.max != null) {this.max.remove(key);} return (A)this;
    }

    public A removeFromMax(java.util.Map<String,Quantity> map) {
        if(this.max == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.max != null){this.max.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,Quantity> getMax() {
        return this.max;
    }

    public <K extends Object,V extends Object>A withMax(java.util.Map<String,Quantity> max) {
        if (max == null) { this.max =  null;} else {this.max = new LinkedHashMap<String,Quantity>(max);} return (A) this;
    }

    public Boolean hasMax() {
        return this.max != null;
    }

    public A addToMaxLimitRequestRatio(String key,Quantity value) {
        if(this.maxLimitRequestRatio == null && key != null && value != null) { this.maxLimitRequestRatio = new LinkedHashMap<String,Quantity>(); }
        if(key != null && value != null) {this.maxLimitRequestRatio.put(key, value);} return (A)this;
    }

    public A addToMaxLimitRequestRatio(java.util.Map<String,Quantity> map) {
        if(this.maxLimitRequestRatio == null && map != null) { this.maxLimitRequestRatio = new LinkedHashMap<String,Quantity>(); }
        if(map != null) { this.maxLimitRequestRatio.putAll(map);} return (A)this;
    }

    public A removeFromMaxLimitRequestRatio(String key) {
        if(this.maxLimitRequestRatio == null) { return (A) this; }
        if(key != null && this.maxLimitRequestRatio != null) {this.maxLimitRequestRatio.remove(key);} return (A)this;
    }

    public A removeFromMaxLimitRequestRatio(java.util.Map<String,Quantity> map) {
        if(this.maxLimitRequestRatio == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.maxLimitRequestRatio != null){this.maxLimitRequestRatio.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,Quantity> getMaxLimitRequestRatio() {
        return this.maxLimitRequestRatio;
    }

    public <K extends Object,V extends Object>A withMaxLimitRequestRatio(java.util.Map<String,Quantity> maxLimitRequestRatio) {
        if (maxLimitRequestRatio == null) { this.maxLimitRequestRatio =  null;} else {this.maxLimitRequestRatio = new LinkedHashMap<String,Quantity>(maxLimitRequestRatio);} return (A) this;
    }

    public Boolean hasMaxLimitRequestRatio() {
        return this.maxLimitRequestRatio != null;
    }

    public A addToMin(String key,Quantity value) {
        if(this.min == null && key != null && value != null) { this.min = new LinkedHashMap<String,Quantity>(); }
        if(key != null && value != null) {this.min.put(key, value);} return (A)this;
    }

    public A addToMin(java.util.Map<String,Quantity> map) {
        if(this.min == null && map != null) { this.min = new LinkedHashMap<String,Quantity>(); }
        if(map != null) { this.min.putAll(map);} return (A)this;
    }

    public A removeFromMin(String key) {
        if(this.min == null) { return (A) this; }
        if(key != null && this.min != null) {this.min.remove(key);} return (A)this;
    }

    public A removeFromMin(java.util.Map<String,Quantity> map) {
        if(this.min == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.min != null){this.min.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,Quantity> getMin() {
        return this.min;
    }

    public <K extends Object,V extends Object>A withMin(java.util.Map<String,Quantity> min) {
        if (min == null) { this.min =  null;} else {this.min = new LinkedHashMap<String,Quantity>(min);} return (A) this;
    }

    public Boolean hasMin() {
        return this.min != null;
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(int[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(char[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(byte[] arg1,int arg2) {
        return (A)withType(new String(arg1, arg2));
    }

    public A withNewType(byte[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(char[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LimitRangeItemFluentImpl that = (LimitRangeItemFluentImpl) o;
        if (_default != null ? !_default.equals(that._default) :that._default != null) return false;
        if (defaultRequest != null ? !defaultRequest.equals(that.defaultRequest) :that.defaultRequest != null) return false;
        if (max != null ? !max.equals(that.max) :that.max != null) return false;
        if (maxLimitRequestRatio != null ? !maxLimitRequestRatio.equals(that.maxLimitRequestRatio) :that.maxLimitRequestRatio != null) return false;
        if (min != null ? !min.equals(that.min) :that.min != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(_default,  defaultRequest,  max,  maxLimitRequestRatio,  min,  type,  super.hashCode());
    }

}
