package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FieldsV1Builder extends FieldsV1FluentImpl<FieldsV1Builder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<FieldsV1,FieldsV1Builder> {

    FieldsV1Fluent<?> fluent;
    Boolean validationEnabled;

    public FieldsV1Builder() {
        this(true);
    }

    public FieldsV1Builder(Boolean validationEnabled) {
        this(new FieldsV1(), validationEnabled);
    }

    public FieldsV1Builder(FieldsV1Fluent<?> fluent) {
        this(fluent, true);
    }

    public FieldsV1Builder(FieldsV1Fluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new FieldsV1(), validationEnabled);
    }

    public FieldsV1Builder(FieldsV1Fluent<?> fluent,FieldsV1 instance) {
        this(fluent, instance, true);
    }

    public FieldsV1Builder(FieldsV1Fluent<?> fluent,FieldsV1 instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public FieldsV1Builder(FieldsV1 instance) {
        this(instance,true);
    }

    public FieldsV1Builder(FieldsV1 instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public FieldsV1 build() {
        FieldsV1 buildable = new FieldsV1();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        FieldsV1Builder that = (FieldsV1Builder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
