package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ComponentStatusFluent<A extends ComponentStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToConditions(int index,ComponentCondition item);
    public A setToConditions(int index,ComponentCondition item);
    public A addToConditions(ComponentCondition... items);
    public A addAllToConditions(Collection<ComponentCondition> items);
    public A removeFromConditions(ComponentCondition... items);
    public A removeAllFromConditions(Collection<ComponentCondition> items);
    public A removeMatchingFromConditions(Predicate<ComponentConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<ComponentCondition> getConditions();
    public List<ComponentCondition> buildConditions();
    public ComponentCondition buildCondition(int index);
    public ComponentCondition buildFirstCondition();
    public ComponentCondition buildLastCondition();
    public ComponentCondition buildMatchingCondition(Predicate<ComponentConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<ComponentConditionBuilder> predicate);
    public A withConditions(List<ComponentCondition> conditions);
    public A withConditions(ComponentCondition... conditions);
    public Boolean hasConditions();
    public A addNewCondition(String error,String message,String status,String type);
    public io.fabric8.kubernetes.api.model.ComponentStatusFluent.ConditionsNested<A> addNewCondition();
    public io.fabric8.kubernetes.api.model.ComponentStatusFluent.ConditionsNested<A> addNewConditionLike(ComponentCondition item);
    public io.fabric8.kubernetes.api.model.ComponentStatusFluent.ConditionsNested<A> setNewConditionLike(int index,ComponentCondition item);
    public io.fabric8.kubernetes.api.model.ComponentStatusFluent.ConditionsNested<A> editCondition(int index);
    public io.fabric8.kubernetes.api.model.ComponentStatusFluent.ConditionsNested<A> editFirstCondition();
    public io.fabric8.kubernetes.api.model.ComponentStatusFluent.ConditionsNested<A> editLastCondition();
    public io.fabric8.kubernetes.api.model.ComponentStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ComponentConditionBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public io.fabric8.kubernetes.api.model.ComponentStatusFluent.MetadataNested<A> withNewMetadata();
    public io.fabric8.kubernetes.api.model.ComponentStatusFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public io.fabric8.kubernetes.api.model.ComponentStatusFluent.MetadataNested<A> editMetadata();
    public io.fabric8.kubernetes.api.model.ComponentStatusFluent.MetadataNested<A> editOrNewMetadata();
    public io.fabric8.kubernetes.api.model.ComponentStatusFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ComponentConditionFluent<io.fabric8.kubernetes.api.model.ComponentStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<io.fabric8.kubernetes.api.model.ComponentStatusFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


}
