package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CSIVolumeSourceBuilder extends CSIVolumeSourceFluentImpl<CSIVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<CSIVolumeSource,CSIVolumeSourceBuilder> {

    CSIVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public CSIVolumeSourceBuilder() {
        this(true);
    }

    public CSIVolumeSourceBuilder(Boolean validationEnabled) {
        this(new CSIVolumeSource(), validationEnabled);
    }

    public CSIVolumeSourceBuilder(CSIVolumeSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public CSIVolumeSourceBuilder(CSIVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CSIVolumeSource(), validationEnabled);
    }

    public CSIVolumeSourceBuilder(CSIVolumeSourceFluent<?> fluent,CSIVolumeSource instance) {
        this(fluent, instance, true);
    }

    public CSIVolumeSourceBuilder(CSIVolumeSourceFluent<?> fluent,CSIVolumeSource instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDriver(instance.getDriver()); 
        fluent.withFsType(instance.getFsType()); 
        fluent.withNodePublishSecretRef(instance.getNodePublishSecretRef()); 
        fluent.withReadOnly(instance.getReadOnly()); 
        fluent.withVolumeAttributes(instance.getVolumeAttributes()); 
        this.validationEnabled = validationEnabled; 
    }

    public CSIVolumeSourceBuilder(CSIVolumeSource instance) {
        this(instance,true);
    }

    public CSIVolumeSourceBuilder(CSIVolumeSource instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDriver(instance.getDriver()); 
        this.withFsType(instance.getFsType()); 
        this.withNodePublishSecretRef(instance.getNodePublishSecretRef()); 
        this.withReadOnly(instance.getReadOnly()); 
        this.withVolumeAttributes(instance.getVolumeAttributes()); 
        this.validationEnabled = validationEnabled; 
    }

    public CSIVolumeSource build() {
        CSIVolumeSource buildable = new CSIVolumeSource(fluent.getDriver(),fluent.getFsType(),fluent.getNodePublishSecretRef(),fluent.getReadOnly(),fluent.getVolumeAttributes());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CSIVolumeSourceBuilder that = (CSIVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
