package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface APIGroupFluent<A extends APIGroupFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(StringBuilder arg1);
    public A withNewName(int[] arg1,int arg2,int arg3);
    public A withNewName(char[] arg1);
    public A withNewName(StringBuffer arg1);
    public A withNewName(byte[] arg1,int arg2);
    public A withNewName(byte[] arg1);
    public A withNewName(char[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewName(String arg1);
    
/**
 * This method has been deprecated, please use method buildPreferredVersion instead.
 * @return The buildable object.
 */
@Deprecated public GroupVersionForDiscovery getPreferredVersion();
    public GroupVersionForDiscovery buildPreferredVersion();
    public A withPreferredVersion(GroupVersionForDiscovery preferredVersion);
    public Boolean hasPreferredVersion();
    public A withNewPreferredVersion(String groupVersion,String version);
    public io.fabric8.kubernetes.api.model.APIGroupFluent.PreferredVersionNested<A> withNewPreferredVersion();
    public io.fabric8.kubernetes.api.model.APIGroupFluent.PreferredVersionNested<A> withNewPreferredVersionLike(GroupVersionForDiscovery item);
    public io.fabric8.kubernetes.api.model.APIGroupFluent.PreferredVersionNested<A> editPreferredVersion();
    public io.fabric8.kubernetes.api.model.APIGroupFluent.PreferredVersionNested<A> editOrNewPreferredVersion();
    public io.fabric8.kubernetes.api.model.APIGroupFluent.PreferredVersionNested<A> editOrNewPreferredVersionLike(GroupVersionForDiscovery item);
    public A addToServerAddressByClientCIDRs(int index,ServerAddressByClientCIDR item);
    public A setToServerAddressByClientCIDRs(int index,ServerAddressByClientCIDR item);
    public A addToServerAddressByClientCIDRs(ServerAddressByClientCIDR... items);
    public A addAllToServerAddressByClientCIDRs(Collection<ServerAddressByClientCIDR> items);
    public A removeFromServerAddressByClientCIDRs(ServerAddressByClientCIDR... items);
    public A removeAllFromServerAddressByClientCIDRs(Collection<ServerAddressByClientCIDR> items);
    public A removeMatchingFromServerAddressByClientCIDRs(Predicate<ServerAddressByClientCIDRBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildServerAddressByClientCIDRs instead.
 * @return The buildable object.
 */
@Deprecated public List<ServerAddressByClientCIDR> getServerAddressByClientCIDRs();
    public List<ServerAddressByClientCIDR> buildServerAddressByClientCIDRs();
    public ServerAddressByClientCIDR buildServerAddressByClientCIDR(int index);
    public ServerAddressByClientCIDR buildFirstServerAddressByClientCIDR();
    public ServerAddressByClientCIDR buildLastServerAddressByClientCIDR();
    public ServerAddressByClientCIDR buildMatchingServerAddressByClientCIDR(Predicate<ServerAddressByClientCIDRBuilder> predicate);
    public Boolean hasMatchingServerAddressByClientCIDR(Predicate<ServerAddressByClientCIDRBuilder> predicate);
    public A withServerAddressByClientCIDRs(List<ServerAddressByClientCIDR> serverAddressByClientCIDRs);
    public A withServerAddressByClientCIDRs(ServerAddressByClientCIDR... serverAddressByClientCIDRs);
    public Boolean hasServerAddressByClientCIDRs();
    public A addNewServerAddressByClientCIDR(String clientCIDR,String serverAddress);
    public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDR();
    public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDRLike(ServerAddressByClientCIDR item);
    public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> setNewServerAddressByClientCIDRLike(int index,ServerAddressByClientCIDR item);
    public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> editServerAddressByClientCIDR(int index);
    public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> editFirstServerAddressByClientCIDR();
    public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> editLastServerAddressByClientCIDR();
    public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> editMatchingServerAddressByClientCIDR(Predicate<ServerAddressByClientCIDRBuilder> predicate);
    public A addToVersions(int index,GroupVersionForDiscovery item);
    public A setToVersions(int index,GroupVersionForDiscovery item);
    public A addToVersions(GroupVersionForDiscovery... items);
    public A addAllToVersions(Collection<GroupVersionForDiscovery> items);
    public A removeFromVersions(GroupVersionForDiscovery... items);
    public A removeAllFromVersions(Collection<GroupVersionForDiscovery> items);
    public A removeMatchingFromVersions(Predicate<GroupVersionForDiscoveryBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildVersions instead.
 * @return The buildable object.
 */
@Deprecated public List<GroupVersionForDiscovery> getVersions();
    public List<GroupVersionForDiscovery> buildVersions();
    public GroupVersionForDiscovery buildVersion(int index);
    public GroupVersionForDiscovery buildFirstVersion();
    public GroupVersionForDiscovery buildLastVersion();
    public GroupVersionForDiscovery buildMatchingVersion(Predicate<GroupVersionForDiscoveryBuilder> predicate);
    public Boolean hasMatchingVersion(Predicate<GroupVersionForDiscoveryBuilder> predicate);
    public A withVersions(List<GroupVersionForDiscovery> versions);
    public A withVersions(GroupVersionForDiscovery... versions);
    public Boolean hasVersions();
    public A addNewVersion(String groupVersion,String version);
    public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> addNewVersion();
    public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> addNewVersionLike(GroupVersionForDiscovery item);
    public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> setNewVersionLike(int index,GroupVersionForDiscovery item);
    public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> editVersion(int index);
    public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> editFirstVersion();
    public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> editLastVersion();
    public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> editMatchingVersion(Predicate<GroupVersionForDiscoveryBuilder> predicate);
    public interface PreferredVersionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GroupVersionForDiscoveryFluent<io.fabric8.kubernetes.api.model.APIGroupFluent.PreferredVersionNested<N>> {

            public N and();
            public N endPreferredVersion();    }


    public interface ServerAddressByClientCIDRsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServerAddressByClientCIDRFluent<io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<N>> {

            public N and();
            public N endServerAddressByClientCIDR();    }


    public interface VersionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GroupVersionForDiscoveryFluent<io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<N>> {

            public N and();
            public N endVersion();    }


}
