package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIServiceStatusBuilder extends APIServiceStatusFluentImpl<APIServiceStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<APIServiceStatus,APIServiceStatusBuilder> {

    APIServiceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public APIServiceStatusBuilder() {
        this(true);
    }

    public APIServiceStatusBuilder(Boolean validationEnabled) {
        this(new APIServiceStatus(), validationEnabled);
    }

    public APIServiceStatusBuilder(APIServiceStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public APIServiceStatusBuilder(APIServiceStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new APIServiceStatus(), validationEnabled);
    }

    public APIServiceStatusBuilder(APIServiceStatusFluent<?> fluent,APIServiceStatus instance) {
        this(fluent, instance, true);
    }

    public APIServiceStatusBuilder(APIServiceStatusFluent<?> fluent,APIServiceStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions()); 
        this.validationEnabled = validationEnabled; 
    }

    public APIServiceStatusBuilder(APIServiceStatus instance) {
        this(instance,true);
    }

    public APIServiceStatusBuilder(APIServiceStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withConditions(instance.getConditions()); 
        this.validationEnabled = validationEnabled; 
    }

    public APIServiceStatus build() {
        APIServiceStatus buildable = new APIServiceStatus(fluent.getConditions());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        APIServiceStatusBuilder that = (APIServiceStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
