package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ServiceStatusFluent<A extends ServiceStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToConditions(int index,Condition item);
    public A setToConditions(int index,Condition item);
    public A addToConditions(Condition... items);
    public A addAllToConditions(Collection<Condition> items);
    public A removeFromConditions(Condition... items);
    public A removeAllFromConditions(Collection<Condition> items);
    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<Condition> getConditions();
    public List<Condition> buildConditions();
    public Condition buildCondition(int index);
    public Condition buildFirstCondition();
    public Condition buildLastCondition();
    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate);
    public A withConditions(List<Condition> conditions);
    public A withConditions(Condition... conditions);
    public Boolean hasConditions();
    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.ConditionsNested<A> addNewCondition();
    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item);
    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item);
    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.ConditionsNested<A> editCondition(int index);
    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.ConditionsNested<A> editFirstCondition();
    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.ConditionsNested<A> editLastCondition();
    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildLoadBalancer instead.
 * @return The buildable object.
 */
@Deprecated public LoadBalancerStatus getLoadBalancer();
    public LoadBalancerStatus buildLoadBalancer();
    public A withLoadBalancer(LoadBalancerStatus loadBalancer);
    public Boolean hasLoadBalancer();
    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.LoadBalancerNested<A> withNewLoadBalancer();
    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancerStatus item);
    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.LoadBalancerNested<A> editLoadBalancer();
    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.LoadBalancerNested<A> editOrNewLoadBalancer();
    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.LoadBalancerNested<A> editOrNewLoadBalancerLike(LoadBalancerStatus item);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConditionFluent<io.fabric8.kubernetes.api.model.ServiceStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface LoadBalancerNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LoadBalancerStatusFluent<io.fabric8.kubernetes.api.model.ServiceStatusFluent.LoadBalancerNested<N>> {

            public N and();
            public N endLoadBalancer();    }


}
