package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ServiceSpecFluent<A extends ServiceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Boolean getAllocateLoadBalancerNodePorts();
    public A withAllocateLoadBalancerNodePorts(Boolean allocateLoadBalancerNodePorts);
    public Boolean hasAllocateLoadBalancerNodePorts();
    public A withNewAllocateLoadBalancerNodePorts(String arg1);
    public A withNewAllocateLoadBalancerNodePorts(boolean arg1);
    public String getClusterIP();
    public A withClusterIP(String clusterIP);
    public Boolean hasClusterIP();
    public A withNewClusterIP(StringBuilder arg1);
    public A withNewClusterIP(int[] arg1,int arg2,int arg3);
    public A withNewClusterIP(char[] arg1);
    public A withNewClusterIP(StringBuffer arg1);
    public A withNewClusterIP(byte[] arg1,int arg2);
    public A withNewClusterIP(byte[] arg1);
    public A withNewClusterIP(char[] arg1,int arg2,int arg3);
    public A withNewClusterIP(byte[] arg1,int arg2,int arg3);
    public A withNewClusterIP(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewClusterIP(String arg1);
    public A addToClusterIPs(int index,String item);
    public A setToClusterIPs(int index,String item);
    public A addToClusterIPs(String... items);
    public A addAllToClusterIPs(Collection<String> items);
    public A removeFromClusterIPs(String... items);
    public A removeAllFromClusterIPs(Collection<String> items);
    public List<String> getClusterIPs();
    public String getClusterIP(int index);
    public String getFirstClusterIP();
    public String getLastClusterIP();
    public String getMatchingClusterIP(Predicate<String> predicate);
    public Boolean hasMatchingClusterIP(Predicate<String> predicate);
    public A withClusterIPs(List<String> clusterIPs);
    public A withClusterIPs(String... clusterIPs);
    public Boolean hasClusterIPs();
    public A addNewClusterIP(StringBuilder arg1);
    public A addNewClusterIP(int[] arg1,int arg2,int arg3);
    public A addNewClusterIP(char[] arg1);
    public A addNewClusterIP(StringBuffer arg1);
    public A addNewClusterIP(byte[] arg1,int arg2);
    public A addNewClusterIP(byte[] arg1);
    public A addNewClusterIP(char[] arg1,int arg2,int arg3);
    public A addNewClusterIP(byte[] arg1,int arg2,int arg3);
    public A addNewClusterIP(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewClusterIP(String arg1);
    public A addToExternalIPs(int index,String item);
    public A setToExternalIPs(int index,String item);
    public A addToExternalIPs(String... items);
    public A addAllToExternalIPs(Collection<String> items);
    public A removeFromExternalIPs(String... items);
    public A removeAllFromExternalIPs(Collection<String> items);
    public List<String> getExternalIPs();
    public String getExternalIP(int index);
    public String getFirstExternalIP();
    public String getLastExternalIP();
    public String getMatchingExternalIP(Predicate<String> predicate);
    public Boolean hasMatchingExternalIP(Predicate<String> predicate);
    public A withExternalIPs(List<String> externalIPs);
    public A withExternalIPs(String... externalIPs);
    public Boolean hasExternalIPs();
    public A addNewExternalIP(StringBuilder arg1);
    public A addNewExternalIP(int[] arg1,int arg2,int arg3);
    public A addNewExternalIP(char[] arg1);
    public A addNewExternalIP(StringBuffer arg1);
    public A addNewExternalIP(byte[] arg1,int arg2);
    public A addNewExternalIP(byte[] arg1);
    public A addNewExternalIP(char[] arg1,int arg2,int arg3);
    public A addNewExternalIP(byte[] arg1,int arg2,int arg3);
    public A addNewExternalIP(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewExternalIP(String arg1);
    public String getExternalName();
    public A withExternalName(String externalName);
    public Boolean hasExternalName();
    public A withNewExternalName(StringBuilder arg1);
    public A withNewExternalName(int[] arg1,int arg2,int arg3);
    public A withNewExternalName(char[] arg1);
    public A withNewExternalName(StringBuffer arg1);
    public A withNewExternalName(byte[] arg1,int arg2);
    public A withNewExternalName(byte[] arg1);
    public A withNewExternalName(char[] arg1,int arg2,int arg3);
    public A withNewExternalName(byte[] arg1,int arg2,int arg3);
    public A withNewExternalName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewExternalName(String arg1);
    public String getExternalTrafficPolicy();
    public A withExternalTrafficPolicy(String externalTrafficPolicy);
    public Boolean hasExternalTrafficPolicy();
    public A withNewExternalTrafficPolicy(StringBuilder arg1);
    public A withNewExternalTrafficPolicy(int[] arg1,int arg2,int arg3);
    public A withNewExternalTrafficPolicy(char[] arg1);
    public A withNewExternalTrafficPolicy(StringBuffer arg1);
    public A withNewExternalTrafficPolicy(byte[] arg1,int arg2);
    public A withNewExternalTrafficPolicy(byte[] arg1);
    public A withNewExternalTrafficPolicy(char[] arg1,int arg2,int arg3);
    public A withNewExternalTrafficPolicy(byte[] arg1,int arg2,int arg3);
    public A withNewExternalTrafficPolicy(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewExternalTrafficPolicy(String arg1);
    public Integer getHealthCheckNodePort();
    public A withHealthCheckNodePort(Integer healthCheckNodePort);
    public Boolean hasHealthCheckNodePort();
    public A withNewHealthCheckNodePort(int arg0);
    public A addToIpFamilies(int index,String item);
    public A setToIpFamilies(int index,String item);
    public A addToIpFamilies(String... items);
    public A addAllToIpFamilies(Collection<String> items);
    public A removeFromIpFamilies(String... items);
    public A removeAllFromIpFamilies(Collection<String> items);
    public List<String> getIpFamilies();
    public String getIpFamily(int index);
    public String getFirstIpFamily();
    public String getLastIpFamily();
    public String getMatchingIpFamily(Predicate<String> predicate);
    public Boolean hasMatchingIpFamily(Predicate<String> predicate);
    public A withIpFamilies(List<String> ipFamilies);
    public A withIpFamilies(String... ipFamilies);
    public Boolean hasIpFamilies();
    public A addNewIpFamily(StringBuilder arg1);
    public A addNewIpFamily(int[] arg1,int arg2,int arg3);
    public A addNewIpFamily(char[] arg1);
    public A addNewIpFamily(StringBuffer arg1);
    public A addNewIpFamily(byte[] arg1,int arg2);
    public A addNewIpFamily(byte[] arg1);
    public A addNewIpFamily(char[] arg1,int arg2,int arg3);
    public A addNewIpFamily(byte[] arg1,int arg2,int arg3);
    public A addNewIpFamily(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewIpFamily(String arg1);
    public String getIpFamilyPolicy();
    public A withIpFamilyPolicy(String ipFamilyPolicy);
    public Boolean hasIpFamilyPolicy();
    public A withNewIpFamilyPolicy(StringBuilder arg1);
    public A withNewIpFamilyPolicy(int[] arg1,int arg2,int arg3);
    public A withNewIpFamilyPolicy(char[] arg1);
    public A withNewIpFamilyPolicy(StringBuffer arg1);
    public A withNewIpFamilyPolicy(byte[] arg1,int arg2);
    public A withNewIpFamilyPolicy(byte[] arg1);
    public A withNewIpFamilyPolicy(char[] arg1,int arg2,int arg3);
    public A withNewIpFamilyPolicy(byte[] arg1,int arg2,int arg3);
    public A withNewIpFamilyPolicy(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewIpFamilyPolicy(String arg1);
    public String getLoadBalancerIP();
    public A withLoadBalancerIP(String loadBalancerIP);
    public Boolean hasLoadBalancerIP();
    public A withNewLoadBalancerIP(StringBuilder arg1);
    public A withNewLoadBalancerIP(int[] arg1,int arg2,int arg3);
    public A withNewLoadBalancerIP(char[] arg1);
    public A withNewLoadBalancerIP(StringBuffer arg1);
    public A withNewLoadBalancerIP(byte[] arg1,int arg2);
    public A withNewLoadBalancerIP(byte[] arg1);
    public A withNewLoadBalancerIP(char[] arg1,int arg2,int arg3);
    public A withNewLoadBalancerIP(byte[] arg1,int arg2,int arg3);
    public A withNewLoadBalancerIP(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewLoadBalancerIP(String arg1);
    public A addToLoadBalancerSourceRanges(int index,String item);
    public A setToLoadBalancerSourceRanges(int index,String item);
    public A addToLoadBalancerSourceRanges(String... items);
    public A addAllToLoadBalancerSourceRanges(Collection<String> items);
    public A removeFromLoadBalancerSourceRanges(String... items);
    public A removeAllFromLoadBalancerSourceRanges(Collection<String> items);
    public List<String> getLoadBalancerSourceRanges();
    public String getLoadBalancerSourceRange(int index);
    public String getFirstLoadBalancerSourceRange();
    public String getLastLoadBalancerSourceRange();
    public String getMatchingLoadBalancerSourceRange(Predicate<String> predicate);
    public Boolean hasMatchingLoadBalancerSourceRange(Predicate<String> predicate);
    public A withLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges);
    public A withLoadBalancerSourceRanges(String... loadBalancerSourceRanges);
    public Boolean hasLoadBalancerSourceRanges();
    public A addNewLoadBalancerSourceRange(StringBuilder arg1);
    public A addNewLoadBalancerSourceRange(int[] arg1,int arg2,int arg3);
    public A addNewLoadBalancerSourceRange(char[] arg1);
    public A addNewLoadBalancerSourceRange(StringBuffer arg1);
    public A addNewLoadBalancerSourceRange(byte[] arg1,int arg2);
    public A addNewLoadBalancerSourceRange(byte[] arg1);
    public A addNewLoadBalancerSourceRange(char[] arg1,int arg2,int arg3);
    public A addNewLoadBalancerSourceRange(byte[] arg1,int arg2,int arg3);
    public A addNewLoadBalancerSourceRange(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewLoadBalancerSourceRange(String arg1);
    public A addToPorts(int index,ServicePort item);
    public A setToPorts(int index,ServicePort item);
    public A addToPorts(ServicePort... items);
    public A addAllToPorts(Collection<ServicePort> items);
    public A removeFromPorts(ServicePort... items);
    public A removeAllFromPorts(Collection<ServicePort> items);
    public A removeMatchingFromPorts(Predicate<ServicePortBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<ServicePort> getPorts();
    public List<ServicePort> buildPorts();
    public ServicePort buildPort(int index);
    public ServicePort buildFirstPort();
    public ServicePort buildLastPort();
    public ServicePort buildMatchingPort(Predicate<ServicePortBuilder> predicate);
    public Boolean hasMatchingPort(Predicate<ServicePortBuilder> predicate);
    public A withPorts(List<ServicePort> ports);
    public A withPorts(ServicePort... ports);
    public Boolean hasPorts();
    public io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<A> addNewPort();
    public io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<A> addNewPortLike(ServicePort item);
    public io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<A> setNewPortLike(int index,ServicePort item);
    public io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<A> editPort(int index);
    public io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<A> editFirstPort();
    public io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<A> editLastPort();
    public io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<A> editMatchingPort(Predicate<ServicePortBuilder> predicate);
    public Boolean getPublishNotReadyAddresses();
    public A withPublishNotReadyAddresses(Boolean publishNotReadyAddresses);
    public Boolean hasPublishNotReadyAddresses();
    public A withNewPublishNotReadyAddresses(String arg1);
    public A withNewPublishNotReadyAddresses(boolean arg1);
    public A addToSelector(String key,String value);
    public A addToSelector(java.util.Map<String,String> map);
    public A removeFromSelector(String key);
    public A removeFromSelector(java.util.Map<String,String> map);
    public java.util.Map<String,String> getSelector();
    public <K extends Object,V extends Object>A withSelector(java.util.Map<String,String> selector);
    public Boolean hasSelector();
    public String getSessionAffinity();
    public A withSessionAffinity(String sessionAffinity);
    public Boolean hasSessionAffinity();
    public A withNewSessionAffinity(StringBuilder arg1);
    public A withNewSessionAffinity(int[] arg1,int arg2,int arg3);
    public A withNewSessionAffinity(char[] arg1);
    public A withNewSessionAffinity(StringBuffer arg1);
    public A withNewSessionAffinity(byte[] arg1,int arg2);
    public A withNewSessionAffinity(byte[] arg1);
    public A withNewSessionAffinity(char[] arg1,int arg2,int arg3);
    public A withNewSessionAffinity(byte[] arg1,int arg2,int arg3);
    public A withNewSessionAffinity(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewSessionAffinity(String arg1);
    
/**
 * This method has been deprecated, please use method buildSessionAffinityConfig instead.
 * @return The buildable object.
 */
@Deprecated public SessionAffinityConfig getSessionAffinityConfig();
    public SessionAffinityConfig buildSessionAffinityConfig();
    public A withSessionAffinityConfig(SessionAffinityConfig sessionAffinityConfig);
    public Boolean hasSessionAffinityConfig();
    public io.fabric8.kubernetes.api.model.ServiceSpecFluent.SessionAffinityConfigNested<A> withNewSessionAffinityConfig();
    public io.fabric8.kubernetes.api.model.ServiceSpecFluent.SessionAffinityConfigNested<A> withNewSessionAffinityConfigLike(SessionAffinityConfig item);
    public io.fabric8.kubernetes.api.model.ServiceSpecFluent.SessionAffinityConfigNested<A> editSessionAffinityConfig();
    public io.fabric8.kubernetes.api.model.ServiceSpecFluent.SessionAffinityConfigNested<A> editOrNewSessionAffinityConfig();
    public io.fabric8.kubernetes.api.model.ServiceSpecFluent.SessionAffinityConfigNested<A> editOrNewSessionAffinityConfigLike(SessionAffinityConfig item);
    public A addToTopologyKeys(int index,String item);
    public A setToTopologyKeys(int index,String item);
    public A addToTopologyKeys(String... items);
    public A addAllToTopologyKeys(Collection<String> items);
    public A removeFromTopologyKeys(String... items);
    public A removeAllFromTopologyKeys(Collection<String> items);
    public List<String> getTopologyKeys();
    public String getTopologyKey(int index);
    public String getFirstTopologyKey();
    public String getLastTopologyKey();
    public String getMatchingTopologyKey(Predicate<String> predicate);
    public Boolean hasMatchingTopologyKey(Predicate<String> predicate);
    public A withTopologyKeys(List<String> topologyKeys);
    public A withTopologyKeys(String... topologyKeys);
    public Boolean hasTopologyKeys();
    public A addNewTopologyKey(StringBuilder arg1);
    public A addNewTopologyKey(int[] arg1,int arg2,int arg3);
    public A addNewTopologyKey(char[] arg1);
    public A addNewTopologyKey(StringBuffer arg1);
    public A addNewTopologyKey(byte[] arg1,int arg2);
    public A addNewTopologyKey(byte[] arg1);
    public A addNewTopologyKey(char[] arg1,int arg2,int arg3);
    public A addNewTopologyKey(byte[] arg1,int arg2,int arg3);
    public A addNewTopologyKey(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewTopologyKey(String arg1);
    public String getType();
    public A withType(String type);
    public Boolean hasType();
    public A withNewType(StringBuilder arg1);
    public A withNewType(int[] arg1,int arg2,int arg3);
    public A withNewType(char[] arg1);
    public A withNewType(StringBuffer arg1);
    public A withNewType(byte[] arg1,int arg2);
    public A withNewType(byte[] arg1);
    public A withNewType(char[] arg1,int arg2,int arg3);
    public A withNewType(byte[] arg1,int arg2,int arg3);
    public A withNewType(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewType(String arg1);
    public interface PortsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServicePortFluent<io.fabric8.kubernetes.api.model.ServiceSpecFluent.PortsNested<N>> {

            public N and();
            public N endPort();    }


    public interface SessionAffinityConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SessionAffinityConfigFluent<io.fabric8.kubernetes.api.model.ServiceSpecFluent.SessionAffinityConfigNested<N>> {

            public N and();
            public N endSessionAffinityConfig();    }


}
