package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodDNSConfigBuilder extends PodDNSConfigFluentImpl<PodDNSConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<PodDNSConfig,PodDNSConfigBuilder> {

    PodDNSConfigFluent<?> fluent;
    Boolean validationEnabled;

    public PodDNSConfigBuilder() {
        this(true);
    }

    public PodDNSConfigBuilder(Boolean validationEnabled) {
        this(new PodDNSConfig(), validationEnabled);
    }

    public PodDNSConfigBuilder(PodDNSConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public PodDNSConfigBuilder(PodDNSConfigFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PodDNSConfig(), validationEnabled);
    }

    public PodDNSConfigBuilder(PodDNSConfigFluent<?> fluent,PodDNSConfig instance) {
        this(fluent, instance, true);
    }

    public PodDNSConfigBuilder(PodDNSConfigFluent<?> fluent,PodDNSConfig instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withNameservers(instance.getNameservers()); 
        fluent.withOptions(instance.getOptions()); 
        fluent.withSearches(instance.getSearches()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodDNSConfigBuilder(PodDNSConfig instance) {
        this(instance,true);
    }

    public PodDNSConfigBuilder(PodDNSConfig instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withNameservers(instance.getNameservers()); 
        this.withOptions(instance.getOptions()); 
        this.withSearches(instance.getSearches()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodDNSConfig build() {
        PodDNSConfig buildable = new PodDNSConfig(fluent.getNameservers(),fluent.getOptions(),fluent.getSearches());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodDNSConfigBuilder that = (PodDNSConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
