package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class NamedAuthInfoFluentImpl<A extends NamedAuthInfoFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NamedAuthInfoFluent<A> {

    private String name;
    private AuthInfoBuilder user;

    public NamedAuthInfoFluentImpl() {
    }

    public NamedAuthInfoFluentImpl(NamedAuthInfo instance) {
        this.withName(instance.getName()); 
        this.withUser(instance.getUser()); 
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildUser instead.
 * @return The buildable object.
 */
@Deprecated public AuthInfo getUser() {
        return this.user!=null?this.user.build():null;
    }

    public AuthInfo buildUser() {
        return this.user!=null?this.user.build():null;
    }

    public A withUser(AuthInfo user) {
        _visitables.get("user").remove(this.user);
        if (user!=null){ this.user= new AuthInfoBuilder(user); _visitables.get("user").add(this.user);} return (A) this;
    }

    public Boolean hasUser() {
        return this.user != null;
    }

    public io.fabric8.kubernetes.api.model.NamedAuthInfoFluent.UserNested<A> withNewUser() {
        return new UserNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.NamedAuthInfoFluent.UserNested<A> withNewUserLike(AuthInfo item) {
        return new UserNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.NamedAuthInfoFluent.UserNested<A> editUser() {
        return withNewUserLike(getUser());
    }

    public io.fabric8.kubernetes.api.model.NamedAuthInfoFluent.UserNested<A> editOrNewUser() {
        return withNewUserLike(getUser() != null ? getUser(): new AuthInfoBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.NamedAuthInfoFluent.UserNested<A> editOrNewUserLike(AuthInfo item) {
        return withNewUserLike(getUser() != null ? getUser(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NamedAuthInfoFluentImpl that = (NamedAuthInfoFluentImpl) o;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (user != null ? !user.equals(that.user) :that.user != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(name,  user,  super.hashCode());
    }

    public class UserNestedImpl<N> extends AuthInfoFluentImpl<io.fabric8.kubernetes.api.model.NamedAuthInfoFluent.UserNested<N>> implements io.fabric8.kubernetes.api.model.NamedAuthInfoFluent.UserNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AuthInfoBuilder builder;

            UserNestedImpl(AuthInfo item) {
                this.builder = new AuthInfoBuilder(this, item);
                        
            }

            UserNestedImpl() {
                this.builder = new AuthInfoBuilder(this);
                        
            }

            public N and() {
                return (N) NamedAuthInfoFluentImpl.this.withUser(builder.build());
            }

            public N endUser() {
                return and();
            }
    }


}
