package io.fabric8.kubernetes.api.model;

import java.lang.String;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Deprecated;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.lang.StringBuffer;
import java.lang.Override;
import java.lang.Long;
import java.lang.StringBuilder;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.core.JsonParser;
import io.fabric8.kubernetes.api.model.version.Info;
import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.version.InfoBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import io.fabric8.kubernetes.api.model.version.InfoFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.DeserializationContext;

public class KubeSchemaFluentImpl<A extends KubeSchemaFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KubeSchemaFluent<A> {

    private APIGroupBuilder aPIGroup;
    private APIGroupListBuilder aPIGroupList;
    private APIServiceBuilder aPIService;
    private APIServiceListBuilder aPIServiceList;
    private BaseKubernetesListBuilder baseKubernetesList;
    private BindingBuilder binding;
    private ComponentStatusBuilder componentStatus;
    private ComponentStatusListBuilder componentStatusList;
    private ConditionBuilder condition;
    private ConfigBuilder config;
    private ConfigMapBuilder configMap;
    private ConfigMapListBuilder configMapList;
    private ContainerStatusBuilder containerStatus;
    private CreateOptionsBuilder createOptions;
    private DeleteOptionsBuilder deleteOptions;
    private EndpointPortBuilder endpointPort;
    private EndpointsBuilder endpoints;
    private EndpointsListBuilder endpointsList;
    private EnvVarBuilder envVar;
    private EventBuilder event;
    private EventListBuilder eventList;
    private EventSeriesBuilder eventSeries;
    private EventSourceBuilder eventSource;
    private GetOptionsBuilder getOptions;
    private GroupVersionKindBuilder groupVersionKind;
    private GroupVersionResourceBuilder groupVersionResource;
    private InfoBuilder info;
    private LimitRangeListBuilder limitRangeList;
    private ListOptionsBuilder listOptions;
    private MicroTimeBuilder microTime;
    private NamespaceBuilder namespace;
    private NamespaceListBuilder namespaceList;
    private NodeBuilder node;
    private NodeListBuilder nodeList;
    private ObjectMetaBuilder objectMeta;
    private PatchBuilder patch;
    private PatchOptionsBuilder patchOptions;
    private PersistentVolumeBuilder persistentVolume;
    private PersistentVolumeClaimBuilder persistentVolumeClaim;
    private PersistentVolumeClaimListBuilder persistentVolumeClaimList;
    private PersistentVolumeListBuilder persistentVolumeList;
    private PodExecOptionsBuilder podExecOptions;
    private PodListBuilder podList;
    private PodTemplateListBuilder podTemplateList;
    private QuantityBuilder quantity;
    private ReplicationControllerListBuilder replicationControllerList;
    private ResourceQuotaBuilder resourceQuota;
    private ResourceQuotaListBuilder resourceQuotaList;
    private RootPathsBuilder rootPaths;
    private SecretBuilder secret;
    private SecretListBuilder secretList;
    private ServiceAccountBuilder serviceAccount;
    private ServiceAccountListBuilder serviceAccountList;
    private ServiceListBuilder serviceList;
    private StatusBuilder status;
    private String time;
    private TolerationBuilder toleration;
    private TopologySelectorTermBuilder topologySelectorTerm;
    private TypeMetaBuilder typeMeta;
    private UpdateOptionsBuilder updateOptions;
    private WatchEventBuilder watchEvent;

    public KubeSchemaFluentImpl() {
    }

    public KubeSchemaFluentImpl(KubeSchema instance) {
        this.withAPIGroup(instance.getAPIGroup()); 
        this.withAPIGroupList(instance.getAPIGroupList()); 
        this.withAPIService(instance.getAPIService()); 
        this.withAPIServiceList(instance.getAPIServiceList()); 
        this.withBaseKubernetesList(instance.getBaseKubernetesList()); 
        this.withBinding(instance.getBinding()); 
        this.withComponentStatus(instance.getComponentStatus()); 
        this.withComponentStatusList(instance.getComponentStatusList()); 
        this.withCondition(instance.getCondition()); 
        this.withConfig(instance.getConfig()); 
        this.withConfigMap(instance.getConfigMap()); 
        this.withConfigMapList(instance.getConfigMapList()); 
        this.withContainerStatus(instance.getContainerStatus()); 
        this.withCreateOptions(instance.getCreateOptions()); 
        this.withDeleteOptions(instance.getDeleteOptions()); 
        this.withEndpointPort(instance.getEndpointPort()); 
        this.withEndpoints(instance.getEndpoints()); 
        this.withEndpointsList(instance.getEndpointsList()); 
        this.withEnvVar(instance.getEnvVar()); 
        this.withEvent(instance.getEvent()); 
        this.withEventList(instance.getEventList()); 
        this.withEventSeries(instance.getEventSeries()); 
        this.withEventSource(instance.getEventSource()); 
        this.withGetOptions(instance.getGetOptions()); 
        this.withGroupVersionKind(instance.getGroupVersionKind()); 
        this.withGroupVersionResource(instance.getGroupVersionResource()); 
        this.withInfo(instance.getInfo()); 
        this.withLimitRangeList(instance.getLimitRangeList()); 
        this.withListOptions(instance.getListOptions()); 
        this.withMicroTime(instance.getMicroTime()); 
        this.withNamespace(instance.getNamespace()); 
        this.withNamespaceList(instance.getNamespaceList()); 
        this.withNode(instance.getNode()); 
        this.withNodeList(instance.getNodeList()); 
        this.withObjectMeta(instance.getObjectMeta()); 
        this.withPatch(instance.getPatch()); 
        this.withPatchOptions(instance.getPatchOptions()); 
        this.withPersistentVolume(instance.getPersistentVolume()); 
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); 
        this.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList()); 
        this.withPersistentVolumeList(instance.getPersistentVolumeList()); 
        this.withPodExecOptions(instance.getPodExecOptions()); 
        this.withPodList(instance.getPodList()); 
        this.withPodTemplateList(instance.getPodTemplateList()); 
        this.withQuantity(instance.getQuantity()); 
        this.withReplicationControllerList(instance.getReplicationControllerList()); 
        this.withResourceQuota(instance.getResourceQuota()); 
        this.withResourceQuotaList(instance.getResourceQuotaList()); 
        this.withRootPaths(instance.getRootPaths()); 
        this.withSecret(instance.getSecret()); 
        this.withSecretList(instance.getSecretList()); 
        this.withServiceAccount(instance.getServiceAccount()); 
        this.withServiceAccountList(instance.getServiceAccountList()); 
        this.withServiceList(instance.getServiceList()); 
        this.withStatus(instance.getStatus()); 
        this.withTime(instance.getTime()); 
        this.withToleration(instance.getToleration()); 
        this.withTopologySelectorTerm(instance.getTopologySelectorTerm()); 
        this.withTypeMeta(instance.getTypeMeta()); 
        this.withUpdateOptions(instance.getUpdateOptions()); 
        this.withWatchEvent(instance.getWatchEvent()); 
    }

    
/**
 * This method has been deprecated, please use method buildAPIGroup instead.
 * @return The buildable object.
 */
@Deprecated public APIGroup getAPIGroup() {
        return this.aPIGroup!=null?this.aPIGroup.build():null;
    }

    public APIGroup buildAPIGroup() {
        return this.aPIGroup!=null?this.aPIGroup.build():null;
    }

    public A withAPIGroup(APIGroup aPIGroup) {
        _visitables.get("aPIGroup").remove(this.aPIGroup);
        if (aPIGroup!=null){ this.aPIGroup= new APIGroupBuilder(aPIGroup); _visitables.get("aPIGroup").add(this.aPIGroup);} return (A) this;
    }

    public Boolean hasAPIGroup() {
        return this.aPIGroup != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIGroupNested<A> withNewAPIGroup() {
        return new APIGroupNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIGroupNested<A> withNewAPIGroupLike(APIGroup item) {
        return new APIGroupNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIGroupNested<A> editAPIGroup() {
        return withNewAPIGroupLike(getAPIGroup());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIGroupNested<A> editOrNewAPIGroup() {
        return withNewAPIGroupLike(getAPIGroup() != null ? getAPIGroup(): new APIGroupBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIGroupNested<A> editOrNewAPIGroupLike(APIGroup item) {
        return withNewAPIGroupLike(getAPIGroup() != null ? getAPIGroup(): item);
    }

    
/**
 * This method has been deprecated, please use method buildAPIGroupList instead.
 * @return The buildable object.
 */
@Deprecated public APIGroupList getAPIGroupList() {
        return this.aPIGroupList!=null?this.aPIGroupList.build():null;
    }

    public APIGroupList buildAPIGroupList() {
        return this.aPIGroupList!=null?this.aPIGroupList.build():null;
    }

    public A withAPIGroupList(APIGroupList aPIGroupList) {
        _visitables.get("aPIGroupList").remove(this.aPIGroupList);
        if (aPIGroupList!=null){ this.aPIGroupList= new APIGroupListBuilder(aPIGroupList); _visitables.get("aPIGroupList").add(this.aPIGroupList);} return (A) this;
    }

    public Boolean hasAPIGroupList() {
        return this.aPIGroupList != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIGroupListNested<A> withNewAPIGroupList() {
        return new APIGroupListNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIGroupListNested<A> withNewAPIGroupListLike(APIGroupList item) {
        return new APIGroupListNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIGroupListNested<A> editAPIGroupList() {
        return withNewAPIGroupListLike(getAPIGroupList());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIGroupListNested<A> editOrNewAPIGroupList() {
        return withNewAPIGroupListLike(getAPIGroupList() != null ? getAPIGroupList(): new APIGroupListBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIGroupListNested<A> editOrNewAPIGroupListLike(APIGroupList item) {
        return withNewAPIGroupListLike(getAPIGroupList() != null ? getAPIGroupList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildAPIService instead.
 * @return The buildable object.
 */
@Deprecated public APIService getAPIService() {
        return this.aPIService!=null?this.aPIService.build():null;
    }

    public APIService buildAPIService() {
        return this.aPIService!=null?this.aPIService.build():null;
    }

    public A withAPIService(APIService aPIService) {
        _visitables.get("aPIService").remove(this.aPIService);
        if (aPIService!=null){ this.aPIService= new APIServiceBuilder(aPIService); _visitables.get("aPIService").add(this.aPIService);} return (A) this;
    }

    public Boolean hasAPIService() {
        return this.aPIService != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIServiceNested<A> withNewAPIService() {
        return new APIServiceNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIServiceNested<A> withNewAPIServiceLike(APIService item) {
        return new APIServiceNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIServiceNested<A> editAPIService() {
        return withNewAPIServiceLike(getAPIService());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIServiceNested<A> editOrNewAPIService() {
        return withNewAPIServiceLike(getAPIService() != null ? getAPIService(): new APIServiceBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIServiceNested<A> editOrNewAPIServiceLike(APIService item) {
        return withNewAPIServiceLike(getAPIService() != null ? getAPIService(): item);
    }

    
/**
 * This method has been deprecated, please use method buildAPIServiceList instead.
 * @return The buildable object.
 */
@Deprecated public APIServiceList getAPIServiceList() {
        return this.aPIServiceList!=null?this.aPIServiceList.build():null;
    }

    public APIServiceList buildAPIServiceList() {
        return this.aPIServiceList!=null?this.aPIServiceList.build():null;
    }

    public A withAPIServiceList(APIServiceList aPIServiceList) {
        _visitables.get("aPIServiceList").remove(this.aPIServiceList);
        if (aPIServiceList!=null){ this.aPIServiceList= new APIServiceListBuilder(aPIServiceList); _visitables.get("aPIServiceList").add(this.aPIServiceList);} return (A) this;
    }

    public Boolean hasAPIServiceList() {
        return this.aPIServiceList != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIServiceListNested<A> withNewAPIServiceList() {
        return new APIServiceListNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIServiceListNested<A> withNewAPIServiceListLike(APIServiceList item) {
        return new APIServiceListNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIServiceListNested<A> editAPIServiceList() {
        return withNewAPIServiceListLike(getAPIServiceList());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIServiceListNested<A> editOrNewAPIServiceList() {
        return withNewAPIServiceListLike(getAPIServiceList() != null ? getAPIServiceList(): new APIServiceListBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIServiceListNested<A> editOrNewAPIServiceListLike(APIServiceList item) {
        return withNewAPIServiceListLike(getAPIServiceList() != null ? getAPIServiceList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildBaseKubernetesList instead.
 * @return The buildable object.
 */
@Deprecated public BaseKubernetesList getBaseKubernetesList() {
        return this.baseKubernetesList!=null?this.baseKubernetesList.build():null;
    }

    public BaseKubernetesList buildBaseKubernetesList() {
        return this.baseKubernetesList!=null?this.baseKubernetesList.build():null;
    }

    public A withBaseKubernetesList(BaseKubernetesList baseKubernetesList) {
        _visitables.get("baseKubernetesList").remove(this.baseKubernetesList);
        if (baseKubernetesList!=null){ this.baseKubernetesList= new BaseKubernetesListBuilder(baseKubernetesList); _visitables.get("baseKubernetesList").add(this.baseKubernetesList);} return (A) this;
    }

    public Boolean hasBaseKubernetesList() {
        return this.baseKubernetesList != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.BaseKubernetesListNested<A> withNewBaseKubernetesList() {
        return new BaseKubernetesListNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.BaseKubernetesListNested<A> withNewBaseKubernetesListLike(BaseKubernetesList item) {
        return new BaseKubernetesListNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.BaseKubernetesListNested<A> editBaseKubernetesList() {
        return withNewBaseKubernetesListLike(getBaseKubernetesList());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.BaseKubernetesListNested<A> editOrNewBaseKubernetesList() {
        return withNewBaseKubernetesListLike(getBaseKubernetesList() != null ? getBaseKubernetesList(): new BaseKubernetesListBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.BaseKubernetesListNested<A> editOrNewBaseKubernetesListLike(BaseKubernetesList item) {
        return withNewBaseKubernetesListLike(getBaseKubernetesList() != null ? getBaseKubernetesList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildBinding instead.
 * @return The buildable object.
 */
@Deprecated public Binding getBinding() {
        return this.binding!=null?this.binding.build():null;
    }

    public Binding buildBinding() {
        return this.binding!=null?this.binding.build():null;
    }

    public A withBinding(Binding binding) {
        _visitables.get("binding").remove(this.binding);
        if (binding!=null){ this.binding= new BindingBuilder(binding); _visitables.get("binding").add(this.binding);} return (A) this;
    }

    public Boolean hasBinding() {
        return this.binding != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.BindingNested<A> withNewBinding() {
        return new BindingNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.BindingNested<A> withNewBindingLike(Binding item) {
        return new BindingNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.BindingNested<A> editBinding() {
        return withNewBindingLike(getBinding());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.BindingNested<A> editOrNewBinding() {
        return withNewBindingLike(getBinding() != null ? getBinding(): new BindingBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.BindingNested<A> editOrNewBindingLike(Binding item) {
        return withNewBindingLike(getBinding() != null ? getBinding(): item);
    }

    
/**
 * This method has been deprecated, please use method buildComponentStatus instead.
 * @return The buildable object.
 */
@Deprecated public ComponentStatus getComponentStatus() {
        return this.componentStatus!=null?this.componentStatus.build():null;
    }

    public ComponentStatus buildComponentStatus() {
        return this.componentStatus!=null?this.componentStatus.build():null;
    }

    public A withComponentStatus(ComponentStatus componentStatus) {
        _visitables.get("componentStatus").remove(this.componentStatus);
        if (componentStatus!=null){ this.componentStatus= new ComponentStatusBuilder(componentStatus); _visitables.get("componentStatus").add(this.componentStatus);} return (A) this;
    }

    public Boolean hasComponentStatus() {
        return this.componentStatus != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ComponentStatusNested<A> withNewComponentStatus() {
        return new ComponentStatusNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ComponentStatusNested<A> withNewComponentStatusLike(ComponentStatus item) {
        return new ComponentStatusNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ComponentStatusNested<A> editComponentStatus() {
        return withNewComponentStatusLike(getComponentStatus());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ComponentStatusNested<A> editOrNewComponentStatus() {
        return withNewComponentStatusLike(getComponentStatus() != null ? getComponentStatus(): new ComponentStatusBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ComponentStatusNested<A> editOrNewComponentStatusLike(ComponentStatus item) {
        return withNewComponentStatusLike(getComponentStatus() != null ? getComponentStatus(): item);
    }

    
/**
 * This method has been deprecated, please use method buildComponentStatusList instead.
 * @return The buildable object.
 */
@Deprecated public ComponentStatusList getComponentStatusList() {
        return this.componentStatusList!=null?this.componentStatusList.build():null;
    }

    public ComponentStatusList buildComponentStatusList() {
        return this.componentStatusList!=null?this.componentStatusList.build():null;
    }

    public A withComponentStatusList(ComponentStatusList componentStatusList) {
        _visitables.get("componentStatusList").remove(this.componentStatusList);
        if (componentStatusList!=null){ this.componentStatusList= new ComponentStatusListBuilder(componentStatusList); _visitables.get("componentStatusList").add(this.componentStatusList);} return (A) this;
    }

    public Boolean hasComponentStatusList() {
        return this.componentStatusList != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ComponentStatusListNested<A> withNewComponentStatusList() {
        return new ComponentStatusListNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ComponentStatusListNested<A> withNewComponentStatusListLike(ComponentStatusList item) {
        return new ComponentStatusListNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ComponentStatusListNested<A> editComponentStatusList() {
        return withNewComponentStatusListLike(getComponentStatusList());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ComponentStatusListNested<A> editOrNewComponentStatusList() {
        return withNewComponentStatusListLike(getComponentStatusList() != null ? getComponentStatusList(): new ComponentStatusListBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ComponentStatusListNested<A> editOrNewComponentStatusListLike(ComponentStatusList item) {
        return withNewComponentStatusListLike(getComponentStatusList() != null ? getComponentStatusList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildCondition instead.
 * @return The buildable object.
 */
@Deprecated public Condition getCondition() {
        return this.condition!=null?this.condition.build():null;
    }

    public Condition buildCondition() {
        return this.condition!=null?this.condition.build():null;
    }

    public A withCondition(Condition condition) {
        _visitables.get("condition").remove(this.condition);
        if (condition!=null){ this.condition= new ConditionBuilder(condition); _visitables.get("condition").add(this.condition);} return (A) this;
    }

    public Boolean hasCondition() {
        return this.condition != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConditionNested<A> withNewCondition() {
        return new ConditionNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConditionNested<A> withNewConditionLike(Condition item) {
        return new ConditionNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConditionNested<A> editCondition() {
        return withNewConditionLike(getCondition());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConditionNested<A> editOrNewCondition() {
        return withNewConditionLike(getCondition() != null ? getCondition(): new ConditionBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConditionNested<A> editOrNewConditionLike(Condition item) {
        return withNewConditionLike(getCondition() != null ? getCondition(): item);
    }

    
/**
 * This method has been deprecated, please use method buildConfig instead.
 * @return The buildable object.
 */
@Deprecated public Config getConfig() {
        return this.config!=null?this.config.build():null;
    }

    public Config buildConfig() {
        return this.config!=null?this.config.build():null;
    }

    public A withConfig(Config config) {
        _visitables.get("config").remove(this.config);
        if (config!=null){ this.config= new ConfigBuilder(config); _visitables.get("config").add(this.config);} return (A) this;
    }

    public Boolean hasConfig() {
        return this.config != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigNested<A> withNewConfig() {
        return new ConfigNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigNested<A> withNewConfigLike(Config item) {
        return new ConfigNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigNested<A> editConfig() {
        return withNewConfigLike(getConfig());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigNested<A> editOrNewConfig() {
        return withNewConfigLike(getConfig() != null ? getConfig(): new ConfigBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigNested<A> editOrNewConfigLike(Config item) {
        return withNewConfigLike(getConfig() != null ? getConfig(): item);
    }

    
/**
 * This method has been deprecated, please use method buildConfigMap instead.
 * @return The buildable object.
 */
@Deprecated public ConfigMap getConfigMap() {
        return this.configMap!=null?this.configMap.build():null;
    }

    public ConfigMap buildConfigMap() {
        return this.configMap!=null?this.configMap.build():null;
    }

    public A withConfigMap(ConfigMap configMap) {
        _visitables.get("configMap").remove(this.configMap);
        if (configMap!=null){ this.configMap= new ConfigMapBuilder(configMap); _visitables.get("configMap").add(this.configMap);} return (A) this;
    }

    public Boolean hasConfigMap() {
        return this.configMap != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigMapNested<A> withNewConfigMap() {
        return new ConfigMapNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigMapNested<A> withNewConfigMapLike(ConfigMap item) {
        return new ConfigMapNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigMapNested<A> editConfigMap() {
        return withNewConfigMapLike(getConfigMap());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigMapNested<A> editOrNewConfigMap() {
        return withNewConfigMapLike(getConfigMap() != null ? getConfigMap(): new ConfigMapBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigMapNested<A> editOrNewConfigMapLike(ConfigMap item) {
        return withNewConfigMapLike(getConfigMap() != null ? getConfigMap(): item);
    }

    
/**
 * This method has been deprecated, please use method buildConfigMapList instead.
 * @return The buildable object.
 */
@Deprecated public ConfigMapList getConfigMapList() {
        return this.configMapList!=null?this.configMapList.build():null;
    }

    public ConfigMapList buildConfigMapList() {
        return this.configMapList!=null?this.configMapList.build():null;
    }

    public A withConfigMapList(ConfigMapList configMapList) {
        _visitables.get("configMapList").remove(this.configMapList);
        if (configMapList!=null){ this.configMapList= new ConfigMapListBuilder(configMapList); _visitables.get("configMapList").add(this.configMapList);} return (A) this;
    }

    public Boolean hasConfigMapList() {
        return this.configMapList != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigMapListNested<A> withNewConfigMapList() {
        return new ConfigMapListNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigMapListNested<A> withNewConfigMapListLike(ConfigMapList item) {
        return new ConfigMapListNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigMapListNested<A> editConfigMapList() {
        return withNewConfigMapListLike(getConfigMapList());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigMapListNested<A> editOrNewConfigMapList() {
        return withNewConfigMapListLike(getConfigMapList() != null ? getConfigMapList(): new ConfigMapListBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigMapListNested<A> editOrNewConfigMapListLike(ConfigMapList item) {
        return withNewConfigMapListLike(getConfigMapList() != null ? getConfigMapList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildContainerStatus instead.
 * @return The buildable object.
 */
@Deprecated public ContainerStatus getContainerStatus() {
        return this.containerStatus!=null?this.containerStatus.build():null;
    }

    public ContainerStatus buildContainerStatus() {
        return this.containerStatus!=null?this.containerStatus.build():null;
    }

    public A withContainerStatus(ContainerStatus containerStatus) {
        _visitables.get("containerStatus").remove(this.containerStatus);
        if (containerStatus!=null){ this.containerStatus= new ContainerStatusBuilder(containerStatus); _visitables.get("containerStatus").add(this.containerStatus);} return (A) this;
    }

    public Boolean hasContainerStatus() {
        return this.containerStatus != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ContainerStatusNested<A> withNewContainerStatus() {
        return new ContainerStatusNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ContainerStatusNested<A> withNewContainerStatusLike(ContainerStatus item) {
        return new ContainerStatusNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ContainerStatusNested<A> editContainerStatus() {
        return withNewContainerStatusLike(getContainerStatus());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ContainerStatusNested<A> editOrNewContainerStatus() {
        return withNewContainerStatusLike(getContainerStatus() != null ? getContainerStatus(): new ContainerStatusBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ContainerStatusNested<A> editOrNewContainerStatusLike(ContainerStatus item) {
        return withNewContainerStatusLike(getContainerStatus() != null ? getContainerStatus(): item);
    }

    
/**
 * This method has been deprecated, please use method buildCreateOptions instead.
 * @return The buildable object.
 */
@Deprecated public CreateOptions getCreateOptions() {
        return this.createOptions!=null?this.createOptions.build():null;
    }

    public CreateOptions buildCreateOptions() {
        return this.createOptions!=null?this.createOptions.build():null;
    }

    public A withCreateOptions(CreateOptions createOptions) {
        _visitables.get("createOptions").remove(this.createOptions);
        if (createOptions!=null){ this.createOptions= new CreateOptionsBuilder(createOptions); _visitables.get("createOptions").add(this.createOptions);} return (A) this;
    }

    public Boolean hasCreateOptions() {
        return this.createOptions != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.CreateOptionsNested<A> withNewCreateOptions() {
        return new CreateOptionsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.CreateOptionsNested<A> withNewCreateOptionsLike(CreateOptions item) {
        return new CreateOptionsNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.CreateOptionsNested<A> editCreateOptions() {
        return withNewCreateOptionsLike(getCreateOptions());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.CreateOptionsNested<A> editOrNewCreateOptions() {
        return withNewCreateOptionsLike(getCreateOptions() != null ? getCreateOptions(): new CreateOptionsBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.CreateOptionsNested<A> editOrNewCreateOptionsLike(CreateOptions item) {
        return withNewCreateOptionsLike(getCreateOptions() != null ? getCreateOptions(): item);
    }

    
/**
 * This method has been deprecated, please use method buildDeleteOptions instead.
 * @return The buildable object.
 */
@Deprecated public DeleteOptions getDeleteOptions() {
        return this.deleteOptions!=null?this.deleteOptions.build():null;
    }

    public DeleteOptions buildDeleteOptions() {
        return this.deleteOptions!=null?this.deleteOptions.build():null;
    }

    public A withDeleteOptions(DeleteOptions deleteOptions) {
        _visitables.get("deleteOptions").remove(this.deleteOptions);
        if (deleteOptions!=null){ this.deleteOptions= new DeleteOptionsBuilder(deleteOptions); _visitables.get("deleteOptions").add(this.deleteOptions);} return (A) this;
    }

    public Boolean hasDeleteOptions() {
        return this.deleteOptions != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.DeleteOptionsNested<A> withNewDeleteOptions() {
        return new DeleteOptionsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.DeleteOptionsNested<A> withNewDeleteOptionsLike(DeleteOptions item) {
        return new DeleteOptionsNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.DeleteOptionsNested<A> editDeleteOptions() {
        return withNewDeleteOptionsLike(getDeleteOptions());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.DeleteOptionsNested<A> editOrNewDeleteOptions() {
        return withNewDeleteOptionsLike(getDeleteOptions() != null ? getDeleteOptions(): new DeleteOptionsBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.DeleteOptionsNested<A> editOrNewDeleteOptionsLike(DeleteOptions item) {
        return withNewDeleteOptionsLike(getDeleteOptions() != null ? getDeleteOptions(): item);
    }

    
/**
 * This method has been deprecated, please use method buildEndpointPort instead.
 * @return The buildable object.
 */
@Deprecated public EndpointPort getEndpointPort() {
        return this.endpointPort!=null?this.endpointPort.build():null;
    }

    public EndpointPort buildEndpointPort() {
        return this.endpointPort!=null?this.endpointPort.build():null;
    }

    public A withEndpointPort(EndpointPort endpointPort) {
        _visitables.get("endpointPort").remove(this.endpointPort);
        if (endpointPort!=null){ this.endpointPort= new EndpointPortBuilder(endpointPort); _visitables.get("endpointPort").add(this.endpointPort);} return (A) this;
    }

    public Boolean hasEndpointPort() {
        return this.endpointPort != null;
    }

    public A withNewEndpointPort(String appProtocol,String name,Integer port,String protocol) {
        return (A)withEndpointPort(new EndpointPort(appProtocol, name, port, protocol));
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointPortNested<A> withNewEndpointPort() {
        return new EndpointPortNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointPortNested<A> withNewEndpointPortLike(EndpointPort item) {
        return new EndpointPortNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointPortNested<A> editEndpointPort() {
        return withNewEndpointPortLike(getEndpointPort());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointPortNested<A> editOrNewEndpointPort() {
        return withNewEndpointPortLike(getEndpointPort() != null ? getEndpointPort(): new EndpointPortBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointPortNested<A> editOrNewEndpointPortLike(EndpointPort item) {
        return withNewEndpointPortLike(getEndpointPort() != null ? getEndpointPort(): item);
    }

    
/**
 * This method has been deprecated, please use method buildEndpoints instead.
 * @return The buildable object.
 */
@Deprecated public Endpoints getEndpoints() {
        return this.endpoints!=null?this.endpoints.build():null;
    }

    public Endpoints buildEndpoints() {
        return this.endpoints!=null?this.endpoints.build():null;
    }

    public A withEndpoints(Endpoints endpoints) {
        _visitables.get("endpoints").remove(this.endpoints);
        if (endpoints!=null){ this.endpoints= new EndpointsBuilder(endpoints); _visitables.get("endpoints").add(this.endpoints);} return (A) this;
    }

    public Boolean hasEndpoints() {
        return this.endpoints != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointsNested<A> withNewEndpoints() {
        return new EndpointsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointsNested<A> withNewEndpointsLike(Endpoints item) {
        return new EndpointsNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointsNested<A> editEndpoints() {
        return withNewEndpointsLike(getEndpoints());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointsNested<A> editOrNewEndpoints() {
        return withNewEndpointsLike(getEndpoints() != null ? getEndpoints(): new EndpointsBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointsNested<A> editOrNewEndpointsLike(Endpoints item) {
        return withNewEndpointsLike(getEndpoints() != null ? getEndpoints(): item);
    }

    
/**
 * This method has been deprecated, please use method buildEndpointsList instead.
 * @return The buildable object.
 */
@Deprecated public EndpointsList getEndpointsList() {
        return this.endpointsList!=null?this.endpointsList.build():null;
    }

    public EndpointsList buildEndpointsList() {
        return this.endpointsList!=null?this.endpointsList.build():null;
    }

    public A withEndpointsList(EndpointsList endpointsList) {
        _visitables.get("endpointsList").remove(this.endpointsList);
        if (endpointsList!=null){ this.endpointsList= new EndpointsListBuilder(endpointsList); _visitables.get("endpointsList").add(this.endpointsList);} return (A) this;
    }

    public Boolean hasEndpointsList() {
        return this.endpointsList != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointsListNested<A> withNewEndpointsList() {
        return new EndpointsListNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointsListNested<A> withNewEndpointsListLike(EndpointsList item) {
        return new EndpointsListNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointsListNested<A> editEndpointsList() {
        return withNewEndpointsListLike(getEndpointsList());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointsListNested<A> editOrNewEndpointsList() {
        return withNewEndpointsListLike(getEndpointsList() != null ? getEndpointsList(): new EndpointsListBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointsListNested<A> editOrNewEndpointsListLike(EndpointsList item) {
        return withNewEndpointsListLike(getEndpointsList() != null ? getEndpointsList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildEnvVar instead.
 * @return The buildable object.
 */
@Deprecated public EnvVar getEnvVar() {
        return this.envVar!=null?this.envVar.build():null;
    }

    public EnvVar buildEnvVar() {
        return this.envVar!=null?this.envVar.build():null;
    }

    public A withEnvVar(EnvVar envVar) {
        _visitables.get("envVar").remove(this.envVar);
        if (envVar!=null){ this.envVar= new EnvVarBuilder(envVar); _visitables.get("envVar").add(this.envVar);} return (A) this;
    }

    public Boolean hasEnvVar() {
        return this.envVar != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EnvVarNested<A> withNewEnvVar() {
        return new EnvVarNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EnvVarNested<A> withNewEnvVarLike(EnvVar item) {
        return new EnvVarNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EnvVarNested<A> editEnvVar() {
        return withNewEnvVarLike(getEnvVar());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EnvVarNested<A> editOrNewEnvVar() {
        return withNewEnvVarLike(getEnvVar() != null ? getEnvVar(): new EnvVarBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EnvVarNested<A> editOrNewEnvVarLike(EnvVar item) {
        return withNewEnvVarLike(getEnvVar() != null ? getEnvVar(): item);
    }

    
/**
 * This method has been deprecated, please use method buildEvent instead.
 * @return The buildable object.
 */
@Deprecated public Event getEvent() {
        return this.event!=null?this.event.build():null;
    }

    public Event buildEvent() {
        return this.event!=null?this.event.build():null;
    }

    public A withEvent(Event event) {
        _visitables.get("event").remove(this.event);
        if (event!=null){ this.event= new EventBuilder(event); _visitables.get("event").add(this.event);} return (A) this;
    }

    public Boolean hasEvent() {
        return this.event != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventNested<A> withNewEvent() {
        return new EventNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventNested<A> withNewEventLike(Event item) {
        return new EventNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventNested<A> editEvent() {
        return withNewEventLike(getEvent());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventNested<A> editOrNewEvent() {
        return withNewEventLike(getEvent() != null ? getEvent(): new EventBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventNested<A> editOrNewEventLike(Event item) {
        return withNewEventLike(getEvent() != null ? getEvent(): item);
    }

    
/**
 * This method has been deprecated, please use method buildEventList instead.
 * @return The buildable object.
 */
@Deprecated public EventList getEventList() {
        return this.eventList!=null?this.eventList.build():null;
    }

    public EventList buildEventList() {
        return this.eventList!=null?this.eventList.build():null;
    }

    public A withEventList(EventList eventList) {
        _visitables.get("eventList").remove(this.eventList);
        if (eventList!=null){ this.eventList= new EventListBuilder(eventList); _visitables.get("eventList").add(this.eventList);} return (A) this;
    }

    public Boolean hasEventList() {
        return this.eventList != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventListNested<A> withNewEventList() {
        return new EventListNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventListNested<A> withNewEventListLike(EventList item) {
        return new EventListNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventListNested<A> editEventList() {
        return withNewEventListLike(getEventList());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventListNested<A> editOrNewEventList() {
        return withNewEventListLike(getEventList() != null ? getEventList(): new EventListBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventListNested<A> editOrNewEventListLike(EventList item) {
        return withNewEventListLike(getEventList() != null ? getEventList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildEventSeries instead.
 * @return The buildable object.
 */
@Deprecated public EventSeries getEventSeries() {
        return this.eventSeries!=null?this.eventSeries.build():null;
    }

    public EventSeries buildEventSeries() {
        return this.eventSeries!=null?this.eventSeries.build():null;
    }

    public A withEventSeries(EventSeries eventSeries) {
        _visitables.get("eventSeries").remove(this.eventSeries);
        if (eventSeries!=null){ this.eventSeries= new EventSeriesBuilder(eventSeries); _visitables.get("eventSeries").add(this.eventSeries);} return (A) this;
    }

    public Boolean hasEventSeries() {
        return this.eventSeries != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventSeriesNested<A> withNewEventSeries() {
        return new EventSeriesNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventSeriesNested<A> withNewEventSeriesLike(EventSeries item) {
        return new EventSeriesNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventSeriesNested<A> editEventSeries() {
        return withNewEventSeriesLike(getEventSeries());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventSeriesNested<A> editOrNewEventSeries() {
        return withNewEventSeriesLike(getEventSeries() != null ? getEventSeries(): new EventSeriesBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventSeriesNested<A> editOrNewEventSeriesLike(EventSeries item) {
        return withNewEventSeriesLike(getEventSeries() != null ? getEventSeries(): item);
    }

    
/**
 * This method has been deprecated, please use method buildEventSource instead.
 * @return The buildable object.
 */
@Deprecated public EventSource getEventSource() {
        return this.eventSource!=null?this.eventSource.build():null;
    }

    public EventSource buildEventSource() {
        return this.eventSource!=null?this.eventSource.build():null;
    }

    public A withEventSource(EventSource eventSource) {
        _visitables.get("eventSource").remove(this.eventSource);
        if (eventSource!=null){ this.eventSource= new EventSourceBuilder(eventSource); _visitables.get("eventSource").add(this.eventSource);} return (A) this;
    }

    public Boolean hasEventSource() {
        return this.eventSource != null;
    }

    public A withNewEventSource(String component,String host) {
        return (A)withEventSource(new EventSource(component, host));
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventSourceNested<A> withNewEventSource() {
        return new EventSourceNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventSourceNested<A> withNewEventSourceLike(EventSource item) {
        return new EventSourceNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventSourceNested<A> editEventSource() {
        return withNewEventSourceLike(getEventSource());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventSourceNested<A> editOrNewEventSource() {
        return withNewEventSourceLike(getEventSource() != null ? getEventSource(): new EventSourceBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventSourceNested<A> editOrNewEventSourceLike(EventSource item) {
        return withNewEventSourceLike(getEventSource() != null ? getEventSource(): item);
    }

    
/**
 * This method has been deprecated, please use method buildGetOptions instead.
 * @return The buildable object.
 */
@Deprecated public GetOptions getGetOptions() {
        return this.getOptions!=null?this.getOptions.build():null;
    }

    public GetOptions buildGetOptions() {
        return this.getOptions!=null?this.getOptions.build():null;
    }

    public A withGetOptions(GetOptions getOptions) {
        _visitables.get("getOptions").remove(this.getOptions);
        if (getOptions!=null){ this.getOptions= new GetOptionsBuilder(getOptions); _visitables.get("getOptions").add(this.getOptions);} return (A) this;
    }

    public Boolean hasGetOptions() {
        return this.getOptions != null;
    }

    public A withNewGetOptions(String apiVersion,String kind,String resourceVersion) {
        return (A)withGetOptions(new GetOptions(apiVersion, kind, resourceVersion));
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.GetOptionsNested<A> withNewGetOptions() {
        return new GetOptionsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.GetOptionsNested<A> withNewGetOptionsLike(GetOptions item) {
        return new GetOptionsNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.GetOptionsNested<A> editGetOptions() {
        return withNewGetOptionsLike(getGetOptions());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.GetOptionsNested<A> editOrNewGetOptions() {
        return withNewGetOptionsLike(getGetOptions() != null ? getGetOptions(): new GetOptionsBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.GetOptionsNested<A> editOrNewGetOptionsLike(GetOptions item) {
        return withNewGetOptionsLike(getGetOptions() != null ? getGetOptions(): item);
    }

    
/**
 * This method has been deprecated, please use method buildGroupVersionKind instead.
 * @return The buildable object.
 */
@Deprecated public GroupVersionKind getGroupVersionKind() {
        return this.groupVersionKind!=null?this.groupVersionKind.build():null;
    }

    public GroupVersionKind buildGroupVersionKind() {
        return this.groupVersionKind!=null?this.groupVersionKind.build():null;
    }

    public A withGroupVersionKind(GroupVersionKind groupVersionKind) {
        _visitables.get("groupVersionKind").remove(this.groupVersionKind);
        if (groupVersionKind!=null){ this.groupVersionKind= new GroupVersionKindBuilder(groupVersionKind); _visitables.get("groupVersionKind").add(this.groupVersionKind);} return (A) this;
    }

    public Boolean hasGroupVersionKind() {
        return this.groupVersionKind != null;
    }

    public A withNewGroupVersionKind(String group,String kind,String version) {
        return (A)withGroupVersionKind(new GroupVersionKind(group, kind, version));
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.GroupVersionKindNested<A> withNewGroupVersionKind() {
        return new GroupVersionKindNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.GroupVersionKindNested<A> withNewGroupVersionKindLike(GroupVersionKind item) {
        return new GroupVersionKindNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.GroupVersionKindNested<A> editGroupVersionKind() {
        return withNewGroupVersionKindLike(getGroupVersionKind());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.GroupVersionKindNested<A> editOrNewGroupVersionKind() {
        return withNewGroupVersionKindLike(getGroupVersionKind() != null ? getGroupVersionKind(): new GroupVersionKindBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.GroupVersionKindNested<A> editOrNewGroupVersionKindLike(GroupVersionKind item) {
        return withNewGroupVersionKindLike(getGroupVersionKind() != null ? getGroupVersionKind(): item);
    }

    
/**
 * This method has been deprecated, please use method buildGroupVersionResource instead.
 * @return The buildable object.
 */
@Deprecated public GroupVersionResource getGroupVersionResource() {
        return this.groupVersionResource!=null?this.groupVersionResource.build():null;
    }

    public GroupVersionResource buildGroupVersionResource() {
        return this.groupVersionResource!=null?this.groupVersionResource.build():null;
    }

    public A withGroupVersionResource(GroupVersionResource groupVersionResource) {
        _visitables.get("groupVersionResource").remove(this.groupVersionResource);
        if (groupVersionResource!=null){ this.groupVersionResource= new GroupVersionResourceBuilder(groupVersionResource); _visitables.get("groupVersionResource").add(this.groupVersionResource);} return (A) this;
    }

    public Boolean hasGroupVersionResource() {
        return this.groupVersionResource != null;
    }

    public A withNewGroupVersionResource(String group,String resource,String version) {
        return (A)withGroupVersionResource(new GroupVersionResource(group, resource, version));
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.GroupVersionResourceNested<A> withNewGroupVersionResource() {
        return new GroupVersionResourceNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.GroupVersionResourceNested<A> withNewGroupVersionResourceLike(GroupVersionResource item) {
        return new GroupVersionResourceNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.GroupVersionResourceNested<A> editGroupVersionResource() {
        return withNewGroupVersionResourceLike(getGroupVersionResource());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.GroupVersionResourceNested<A> editOrNewGroupVersionResource() {
        return withNewGroupVersionResourceLike(getGroupVersionResource() != null ? getGroupVersionResource(): new GroupVersionResourceBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.GroupVersionResourceNested<A> editOrNewGroupVersionResourceLike(GroupVersionResource item) {
        return withNewGroupVersionResourceLike(getGroupVersionResource() != null ? getGroupVersionResource(): item);
    }

    
/**
 * This method has been deprecated, please use method buildInfo instead.
 * @return The buildable object.
 */
@Deprecated public Info getInfo() {
        return this.info!=null?this.info.build():null;
    }

    public Info buildInfo() {
        return this.info!=null?this.info.build():null;
    }

    public A withInfo(Info info) {
        _visitables.get("info").remove(this.info);
        if (info!=null){ this.info= new InfoBuilder(info); _visitables.get("info").add(this.info);} return (A) this;
    }

    public Boolean hasInfo() {
        return this.info != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.InfoNested<A> withNewInfo() {
        return new InfoNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.InfoNested<A> withNewInfoLike(Info item) {
        return new InfoNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.InfoNested<A> editInfo() {
        return withNewInfoLike(getInfo());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.InfoNested<A> editOrNewInfo() {
        return withNewInfoLike(getInfo() != null ? getInfo(): new InfoBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.InfoNested<A> editOrNewInfoLike(Info item) {
        return withNewInfoLike(getInfo() != null ? getInfo(): item);
    }

    
/**
 * This method has been deprecated, please use method buildLimitRangeList instead.
 * @return The buildable object.
 */
@Deprecated public LimitRangeList getLimitRangeList() {
        return this.limitRangeList!=null?this.limitRangeList.build():null;
    }

    public LimitRangeList buildLimitRangeList() {
        return this.limitRangeList!=null?this.limitRangeList.build():null;
    }

    public A withLimitRangeList(LimitRangeList limitRangeList) {
        _visitables.get("limitRangeList").remove(this.limitRangeList);
        if (limitRangeList!=null){ this.limitRangeList= new LimitRangeListBuilder(limitRangeList); _visitables.get("limitRangeList").add(this.limitRangeList);} return (A) this;
    }

    public Boolean hasLimitRangeList() {
        return this.limitRangeList != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.LimitRangeListNested<A> withNewLimitRangeList() {
        return new LimitRangeListNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.LimitRangeListNested<A> withNewLimitRangeListLike(LimitRangeList item) {
        return new LimitRangeListNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.LimitRangeListNested<A> editLimitRangeList() {
        return withNewLimitRangeListLike(getLimitRangeList());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.LimitRangeListNested<A> editOrNewLimitRangeList() {
        return withNewLimitRangeListLike(getLimitRangeList() != null ? getLimitRangeList(): new LimitRangeListBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.LimitRangeListNested<A> editOrNewLimitRangeListLike(LimitRangeList item) {
        return withNewLimitRangeListLike(getLimitRangeList() != null ? getLimitRangeList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildListOptions instead.
 * @return The buildable object.
 */
@Deprecated public ListOptions getListOptions() {
        return this.listOptions!=null?this.listOptions.build():null;
    }

    public ListOptions buildListOptions() {
        return this.listOptions!=null?this.listOptions.build():null;
    }

    public A withListOptions(ListOptions listOptions) {
        _visitables.get("listOptions").remove(this.listOptions);
        if (listOptions!=null){ this.listOptions= new ListOptionsBuilder(listOptions); _visitables.get("listOptions").add(this.listOptions);} return (A) this;
    }

    public Boolean hasListOptions() {
        return this.listOptions != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ListOptionsNested<A> withNewListOptions() {
        return new ListOptionsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ListOptionsNested<A> withNewListOptionsLike(ListOptions item) {
        return new ListOptionsNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ListOptionsNested<A> editListOptions() {
        return withNewListOptionsLike(getListOptions());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ListOptionsNested<A> editOrNewListOptions() {
        return withNewListOptionsLike(getListOptions() != null ? getListOptions(): new ListOptionsBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ListOptionsNested<A> editOrNewListOptionsLike(ListOptions item) {
        return withNewListOptionsLike(getListOptions() != null ? getListOptions(): item);
    }

    
/**
 * This method has been deprecated, please use method buildMicroTime instead.
 * @return The buildable object.
 */
@Deprecated public MicroTime getMicroTime() {
        return this.microTime!=null?this.microTime.build():null;
    }

    public MicroTime buildMicroTime() {
        return this.microTime!=null?this.microTime.build():null;
    }

    public A withMicroTime(MicroTime microTime) {
        _visitables.get("microTime").remove(this.microTime);
        if (microTime!=null){ this.microTime= new MicroTimeBuilder(microTime); _visitables.get("microTime").add(this.microTime);} return (A) this;
    }

    public Boolean hasMicroTime() {
        return this.microTime != null;
    }

    public A withNewMicroTime(String time) {
        return (A)withMicroTime(new MicroTime(time));
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.MicroTimeNested<A> withNewMicroTime() {
        return new MicroTimeNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.MicroTimeNested<A> withNewMicroTimeLike(MicroTime item) {
        return new MicroTimeNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.MicroTimeNested<A> editMicroTime() {
        return withNewMicroTimeLike(getMicroTime());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.MicroTimeNested<A> editOrNewMicroTime() {
        return withNewMicroTimeLike(getMicroTime() != null ? getMicroTime(): new MicroTimeBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.MicroTimeNested<A> editOrNewMicroTimeLike(MicroTime item) {
        return withNewMicroTimeLike(getMicroTime() != null ? getMicroTime(): item);
    }

    
/**
 * This method has been deprecated, please use method buildNamespace instead.
 * @return The buildable object.
 */
@Deprecated public Namespace getNamespace() {
        return this.namespace!=null?this.namespace.build():null;
    }

    public Namespace buildNamespace() {
        return this.namespace!=null?this.namespace.build():null;
    }

    public A withNamespace(Namespace namespace) {
        _visitables.get("namespace").remove(this.namespace);
        if (namespace!=null){ this.namespace= new NamespaceBuilder(namespace); _visitables.get("namespace").add(this.namespace);} return (A) this;
    }

    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.NamespaceNested<A> withNewNamespace() {
        return new NamespaceNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.NamespaceNested<A> withNewNamespaceLike(Namespace item) {
        return new NamespaceNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.NamespaceNested<A> editNamespace() {
        return withNewNamespaceLike(getNamespace());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.NamespaceNested<A> editOrNewNamespace() {
        return withNewNamespaceLike(getNamespace() != null ? getNamespace(): new NamespaceBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.NamespaceNested<A> editOrNewNamespaceLike(Namespace item) {
        return withNewNamespaceLike(getNamespace() != null ? getNamespace(): item);
    }

    
/**
 * This method has been deprecated, please use method buildNamespaceList instead.
 * @return The buildable object.
 */
@Deprecated public NamespaceList getNamespaceList() {
        return this.namespaceList!=null?this.namespaceList.build():null;
    }

    public NamespaceList buildNamespaceList() {
        return this.namespaceList!=null?this.namespaceList.build():null;
    }

    public A withNamespaceList(NamespaceList namespaceList) {
        _visitables.get("namespaceList").remove(this.namespaceList);
        if (namespaceList!=null){ this.namespaceList= new NamespaceListBuilder(namespaceList); _visitables.get("namespaceList").add(this.namespaceList);} return (A) this;
    }

    public Boolean hasNamespaceList() {
        return this.namespaceList != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.NamespaceListNested<A> withNewNamespaceList() {
        return new NamespaceListNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.NamespaceListNested<A> withNewNamespaceListLike(NamespaceList item) {
        return new NamespaceListNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.NamespaceListNested<A> editNamespaceList() {
        return withNewNamespaceListLike(getNamespaceList());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.NamespaceListNested<A> editOrNewNamespaceList() {
        return withNewNamespaceListLike(getNamespaceList() != null ? getNamespaceList(): new NamespaceListBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.NamespaceListNested<A> editOrNewNamespaceListLike(NamespaceList item) {
        return withNewNamespaceListLike(getNamespaceList() != null ? getNamespaceList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildNode instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.Node getNode() {
        return this.node!=null?this.node.build():null;
    }

    public io.fabric8.kubernetes.api.model.Node buildNode() {
        return this.node!=null?this.node.build():null;
    }

    public A withNode(io.fabric8.kubernetes.api.model.Node node) {
        _visitables.get("node").remove(this.node);
        if (node!=null){ this.node= new NodeBuilder(node); _visitables.get("node").add(this.node);} return (A) this;
    }

    public Boolean hasNode() {
        return this.node != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.NodeNested<A> withNewNode() {
        return new NodeNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.NodeNested<A> withNewNodeLike(io.fabric8.kubernetes.api.model.Node item) {
        return new NodeNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.NodeNested<A> editNode() {
        return withNewNodeLike(getNode());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.NodeNested<A> editOrNewNode() {
        return withNewNodeLike(getNode() != null ? getNode(): new NodeBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.NodeNested<A> editOrNewNodeLike(io.fabric8.kubernetes.api.model.Node item) {
        return withNewNodeLike(getNode() != null ? getNode(): item);
    }

    
/**
 * This method has been deprecated, please use method buildNodeList instead.
 * @return The buildable object.
 */
@Deprecated public NodeList getNodeList() {
        return this.nodeList!=null?this.nodeList.build():null;
    }

    public NodeList buildNodeList() {
        return this.nodeList!=null?this.nodeList.build():null;
    }

    public A withNodeList(NodeList nodeList) {
        _visitables.get("nodeList").remove(this.nodeList);
        if (nodeList!=null){ this.nodeList= new NodeListBuilder(nodeList); _visitables.get("nodeList").add(this.nodeList);} return (A) this;
    }

    public Boolean hasNodeList() {
        return this.nodeList != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.NodeListNested<A> withNewNodeList() {
        return new NodeListNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.NodeListNested<A> withNewNodeListLike(NodeList item) {
        return new NodeListNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.NodeListNested<A> editNodeList() {
        return withNewNodeListLike(getNodeList());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.NodeListNested<A> editOrNewNodeList() {
        return withNewNodeListLike(getNodeList() != null ? getNodeList(): new NodeListBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.NodeListNested<A> editOrNewNodeListLike(NodeList item) {
        return withNewNodeListLike(getNodeList() != null ? getNodeList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildObjectMeta instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getObjectMeta() {
        return this.objectMeta!=null?this.objectMeta.build():null;
    }

    public ObjectMeta buildObjectMeta() {
        return this.objectMeta!=null?this.objectMeta.build():null;
    }

    public A withObjectMeta(ObjectMeta objectMeta) {
        _visitables.get("objectMeta").remove(this.objectMeta);
        if (objectMeta!=null){ this.objectMeta= new ObjectMetaBuilder(objectMeta); _visitables.get("objectMeta").add(this.objectMeta);} return (A) this;
    }

    public Boolean hasObjectMeta() {
        return this.objectMeta != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ObjectMetaNested<A> withNewObjectMeta() {
        return new ObjectMetaNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ObjectMetaNested<A> withNewObjectMetaLike(ObjectMeta item) {
        return new ObjectMetaNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ObjectMetaNested<A> editObjectMeta() {
        return withNewObjectMetaLike(getObjectMeta());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ObjectMetaNested<A> editOrNewObjectMeta() {
        return withNewObjectMetaLike(getObjectMeta() != null ? getObjectMeta(): new ObjectMetaBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ObjectMetaNested<A> editOrNewObjectMetaLike(ObjectMeta item) {
        return withNewObjectMetaLike(getObjectMeta() != null ? getObjectMeta(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPatch instead.
 * @return The buildable object.
 */
@Deprecated public Patch getPatch() {
        return this.patch!=null?this.patch.build():null;
    }

    public Patch buildPatch() {
        return this.patch!=null?this.patch.build():null;
    }

    public A withPatch(Patch patch) {
        _visitables.get("patch").remove(this.patch);
        if (patch!=null){ this.patch= new PatchBuilder(patch); _visitables.get("patch").add(this.patch);} return (A) this;
    }

    public Boolean hasPatch() {
        return this.patch != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PatchNested<A> withNewPatch() {
        return new PatchNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PatchNested<A> withNewPatchLike(Patch item) {
        return new PatchNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PatchNested<A> editPatch() {
        return withNewPatchLike(getPatch());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PatchNested<A> editOrNewPatch() {
        return withNewPatchLike(getPatch() != null ? getPatch(): new PatchBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PatchNested<A> editOrNewPatchLike(Patch item) {
        return withNewPatchLike(getPatch() != null ? getPatch(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPatchOptions instead.
 * @return The buildable object.
 */
@Deprecated public PatchOptions getPatchOptions() {
        return this.patchOptions!=null?this.patchOptions.build():null;
    }

    public PatchOptions buildPatchOptions() {
        return this.patchOptions!=null?this.patchOptions.build():null;
    }

    public A withPatchOptions(PatchOptions patchOptions) {
        _visitables.get("patchOptions").remove(this.patchOptions);
        if (patchOptions!=null){ this.patchOptions= new PatchOptionsBuilder(patchOptions); _visitables.get("patchOptions").add(this.patchOptions);} return (A) this;
    }

    public Boolean hasPatchOptions() {
        return this.patchOptions != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PatchOptionsNested<A> withNewPatchOptions() {
        return new PatchOptionsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PatchOptionsNested<A> withNewPatchOptionsLike(PatchOptions item) {
        return new PatchOptionsNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PatchOptionsNested<A> editPatchOptions() {
        return withNewPatchOptionsLike(getPatchOptions());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PatchOptionsNested<A> editOrNewPatchOptions() {
        return withNewPatchOptionsLike(getPatchOptions() != null ? getPatchOptions(): new PatchOptionsBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PatchOptionsNested<A> editOrNewPatchOptionsLike(PatchOptions item) {
        return withNewPatchOptionsLike(getPatchOptions() != null ? getPatchOptions(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPersistentVolume instead.
 * @return The buildable object.
 */
@Deprecated public PersistentVolume getPersistentVolume() {
        return this.persistentVolume!=null?this.persistentVolume.build():null;
    }

    public PersistentVolume buildPersistentVolume() {
        return this.persistentVolume!=null?this.persistentVolume.build():null;
    }

    public A withPersistentVolume(PersistentVolume persistentVolume) {
        _visitables.get("persistentVolume").remove(this.persistentVolume);
        if (persistentVolume!=null){ this.persistentVolume= new PersistentVolumeBuilder(persistentVolume); _visitables.get("persistentVolume").add(this.persistentVolume);} return (A) this;
    }

    public Boolean hasPersistentVolume() {
        return this.persistentVolume != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeNested<A> withNewPersistentVolume() {
        return new PersistentVolumeNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeNested<A> withNewPersistentVolumeLike(PersistentVolume item) {
        return new PersistentVolumeNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeNested<A> editPersistentVolume() {
        return withNewPersistentVolumeLike(getPersistentVolume());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeNested<A> editOrNewPersistentVolume() {
        return withNewPersistentVolumeLike(getPersistentVolume() != null ? getPersistentVolume(): new PersistentVolumeBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeNested<A> editOrNewPersistentVolumeLike(PersistentVolume item) {
        return withNewPersistentVolumeLike(getPersistentVolume() != null ? getPersistentVolume(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPersistentVolumeClaim instead.
 * @return The buildable object.
 */
@Deprecated public PersistentVolumeClaim getPersistentVolumeClaim() {
        return this.persistentVolumeClaim!=null?this.persistentVolumeClaim.build():null;
    }

    public PersistentVolumeClaim buildPersistentVolumeClaim() {
        return this.persistentVolumeClaim!=null?this.persistentVolumeClaim.build():null;
    }

    public A withPersistentVolumeClaim(PersistentVolumeClaim persistentVolumeClaim) {
        _visitables.get("persistentVolumeClaim").remove(this.persistentVolumeClaim);
        if (persistentVolumeClaim!=null){ this.persistentVolumeClaim= new PersistentVolumeClaimBuilder(persistentVolumeClaim); _visitables.get("persistentVolumeClaim").add(this.persistentVolumeClaim);} return (A) this;
    }

    public Boolean hasPersistentVolumeClaim() {
        return this.persistentVolumeClaim != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim() {
        return new PersistentVolumeClaimNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(PersistentVolumeClaim item) {
        return new PersistentVolumeClaimNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeClaimNested<A> editPersistentVolumeClaim() {
        return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaim() {
        return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim() != null ? getPersistentVolumeClaim(): new PersistentVolumeClaimBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaimLike(PersistentVolumeClaim item) {
        return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim() != null ? getPersistentVolumeClaim(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPersistentVolumeClaimList instead.
 * @return The buildable object.
 */
@Deprecated public PersistentVolumeClaimList getPersistentVolumeClaimList() {
        return this.persistentVolumeClaimList!=null?this.persistentVolumeClaimList.build():null;
    }

    public PersistentVolumeClaimList buildPersistentVolumeClaimList() {
        return this.persistentVolumeClaimList!=null?this.persistentVolumeClaimList.build():null;
    }

    public A withPersistentVolumeClaimList(PersistentVolumeClaimList persistentVolumeClaimList) {
        _visitables.get("persistentVolumeClaimList").remove(this.persistentVolumeClaimList);
        if (persistentVolumeClaimList!=null){ this.persistentVolumeClaimList= new PersistentVolumeClaimListBuilder(persistentVolumeClaimList); _visitables.get("persistentVolumeClaimList").add(this.persistentVolumeClaimList);} return (A) this;
    }

    public Boolean hasPersistentVolumeClaimList() {
        return this.persistentVolumeClaimList != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeClaimListNested<A> withNewPersistentVolumeClaimList() {
        return new PersistentVolumeClaimListNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeClaimListNested<A> withNewPersistentVolumeClaimListLike(PersistentVolumeClaimList item) {
        return new PersistentVolumeClaimListNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeClaimListNested<A> editPersistentVolumeClaimList() {
        return withNewPersistentVolumeClaimListLike(getPersistentVolumeClaimList());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeClaimListNested<A> editOrNewPersistentVolumeClaimList() {
        return withNewPersistentVolumeClaimListLike(getPersistentVolumeClaimList() != null ? getPersistentVolumeClaimList(): new PersistentVolumeClaimListBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeClaimListNested<A> editOrNewPersistentVolumeClaimListLike(PersistentVolumeClaimList item) {
        return withNewPersistentVolumeClaimListLike(getPersistentVolumeClaimList() != null ? getPersistentVolumeClaimList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPersistentVolumeList instead.
 * @return The buildable object.
 */
@Deprecated public PersistentVolumeList getPersistentVolumeList() {
        return this.persistentVolumeList!=null?this.persistentVolumeList.build():null;
    }

    public PersistentVolumeList buildPersistentVolumeList() {
        return this.persistentVolumeList!=null?this.persistentVolumeList.build():null;
    }

    public A withPersistentVolumeList(PersistentVolumeList persistentVolumeList) {
        _visitables.get("persistentVolumeList").remove(this.persistentVolumeList);
        if (persistentVolumeList!=null){ this.persistentVolumeList= new PersistentVolumeListBuilder(persistentVolumeList); _visitables.get("persistentVolumeList").add(this.persistentVolumeList);} return (A) this;
    }

    public Boolean hasPersistentVolumeList() {
        return this.persistentVolumeList != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeListNested<A> withNewPersistentVolumeList() {
        return new PersistentVolumeListNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeListNested<A> withNewPersistentVolumeListLike(PersistentVolumeList item) {
        return new PersistentVolumeListNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeListNested<A> editPersistentVolumeList() {
        return withNewPersistentVolumeListLike(getPersistentVolumeList());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeListNested<A> editOrNewPersistentVolumeList() {
        return withNewPersistentVolumeListLike(getPersistentVolumeList() != null ? getPersistentVolumeList(): new PersistentVolumeListBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeListNested<A> editOrNewPersistentVolumeListLike(PersistentVolumeList item) {
        return withNewPersistentVolumeListLike(getPersistentVolumeList() != null ? getPersistentVolumeList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPodExecOptions instead.
 * @return The buildable object.
 */
@Deprecated public PodExecOptions getPodExecOptions() {
        return this.podExecOptions!=null?this.podExecOptions.build():null;
    }

    public PodExecOptions buildPodExecOptions() {
        return this.podExecOptions!=null?this.podExecOptions.build():null;
    }

    public A withPodExecOptions(PodExecOptions podExecOptions) {
        _visitables.get("podExecOptions").remove(this.podExecOptions);
        if (podExecOptions!=null){ this.podExecOptions= new PodExecOptionsBuilder(podExecOptions); _visitables.get("podExecOptions").add(this.podExecOptions);} return (A) this;
    }

    public Boolean hasPodExecOptions() {
        return this.podExecOptions != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodExecOptionsNested<A> withNewPodExecOptions() {
        return new PodExecOptionsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodExecOptionsNested<A> withNewPodExecOptionsLike(PodExecOptions item) {
        return new PodExecOptionsNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodExecOptionsNested<A> editPodExecOptions() {
        return withNewPodExecOptionsLike(getPodExecOptions());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodExecOptionsNested<A> editOrNewPodExecOptions() {
        return withNewPodExecOptionsLike(getPodExecOptions() != null ? getPodExecOptions(): new PodExecOptionsBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodExecOptionsNested<A> editOrNewPodExecOptionsLike(PodExecOptions item) {
        return withNewPodExecOptionsLike(getPodExecOptions() != null ? getPodExecOptions(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPodList instead.
 * @return The buildable object.
 */
@Deprecated public PodList getPodList() {
        return this.podList!=null?this.podList.build():null;
    }

    public PodList buildPodList() {
        return this.podList!=null?this.podList.build():null;
    }

    public A withPodList(PodList podList) {
        _visitables.get("podList").remove(this.podList);
        if (podList!=null){ this.podList= new PodListBuilder(podList); _visitables.get("podList").add(this.podList);} return (A) this;
    }

    public Boolean hasPodList() {
        return this.podList != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodListNested<A> withNewPodList() {
        return new PodListNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodListNested<A> withNewPodListLike(PodList item) {
        return new PodListNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodListNested<A> editPodList() {
        return withNewPodListLike(getPodList());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodListNested<A> editOrNewPodList() {
        return withNewPodListLike(getPodList() != null ? getPodList(): new PodListBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodListNested<A> editOrNewPodListLike(PodList item) {
        return withNewPodListLike(getPodList() != null ? getPodList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPodTemplateList instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplateList getPodTemplateList() {
        return this.podTemplateList!=null?this.podTemplateList.build():null;
    }

    public PodTemplateList buildPodTemplateList() {
        return this.podTemplateList!=null?this.podTemplateList.build():null;
    }

    public A withPodTemplateList(PodTemplateList podTemplateList) {
        _visitables.get("podTemplateList").remove(this.podTemplateList);
        if (podTemplateList!=null){ this.podTemplateList= new PodTemplateListBuilder(podTemplateList); _visitables.get("podTemplateList").add(this.podTemplateList);} return (A) this;
    }

    public Boolean hasPodTemplateList() {
        return this.podTemplateList != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodTemplateListNested<A> withNewPodTemplateList() {
        return new PodTemplateListNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodTemplateListNested<A> withNewPodTemplateListLike(PodTemplateList item) {
        return new PodTemplateListNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodTemplateListNested<A> editPodTemplateList() {
        return withNewPodTemplateListLike(getPodTemplateList());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodTemplateListNested<A> editOrNewPodTemplateList() {
        return withNewPodTemplateListLike(getPodTemplateList() != null ? getPodTemplateList(): new PodTemplateListBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodTemplateListNested<A> editOrNewPodTemplateListLike(PodTemplateList item) {
        return withNewPodTemplateListLike(getPodTemplateList() != null ? getPodTemplateList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildQuantity instead.
 * @return The buildable object.
 */
@Deprecated public Quantity getQuantity() {
        return this.quantity!=null?this.quantity.build():null;
    }

    public Quantity buildQuantity() {
        return this.quantity!=null?this.quantity.build():null;
    }

    public A withQuantity(Quantity quantity) {
        _visitables.get("quantity").remove(this.quantity);
        if (quantity!=null){ this.quantity= new QuantityBuilder(quantity); _visitables.get("quantity").add(this.quantity);} return (A) this;
    }

    public Boolean hasQuantity() {
        return this.quantity != null;
    }

    public A withNewQuantity(String amount) {
        return (A)withQuantity(new Quantity(amount));
    }

    public A withNewQuantity(String amount,String format) {
        return (A)withQuantity(new Quantity(amount, format));
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.QuantityNested<A> withNewQuantity() {
        return new QuantityNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.QuantityNested<A> withNewQuantityLike(Quantity item) {
        return new QuantityNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.QuantityNested<A> editQuantity() {
        return withNewQuantityLike(getQuantity());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.QuantityNested<A> editOrNewQuantity() {
        return withNewQuantityLike(getQuantity() != null ? getQuantity(): new QuantityBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.QuantityNested<A> editOrNewQuantityLike(Quantity item) {
        return withNewQuantityLike(getQuantity() != null ? getQuantity(): item);
    }

    
/**
 * This method has been deprecated, please use method buildReplicationControllerList instead.
 * @return The buildable object.
 */
@Deprecated public ReplicationControllerList getReplicationControllerList() {
        return this.replicationControllerList!=null?this.replicationControllerList.build():null;
    }

    public ReplicationControllerList buildReplicationControllerList() {
        return this.replicationControllerList!=null?this.replicationControllerList.build():null;
    }

    public A withReplicationControllerList(ReplicationControllerList replicationControllerList) {
        _visitables.get("replicationControllerList").remove(this.replicationControllerList);
        if (replicationControllerList!=null){ this.replicationControllerList= new ReplicationControllerListBuilder(replicationControllerList); _visitables.get("replicationControllerList").add(this.replicationControllerList);} return (A) this;
    }

    public Boolean hasReplicationControllerList() {
        return this.replicationControllerList != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ReplicationControllerListNested<A> withNewReplicationControllerList() {
        return new ReplicationControllerListNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ReplicationControllerListNested<A> withNewReplicationControllerListLike(ReplicationControllerList item) {
        return new ReplicationControllerListNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ReplicationControllerListNested<A> editReplicationControllerList() {
        return withNewReplicationControllerListLike(getReplicationControllerList());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ReplicationControllerListNested<A> editOrNewReplicationControllerList() {
        return withNewReplicationControllerListLike(getReplicationControllerList() != null ? getReplicationControllerList(): new ReplicationControllerListBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ReplicationControllerListNested<A> editOrNewReplicationControllerListLike(ReplicationControllerList item) {
        return withNewReplicationControllerListLike(getReplicationControllerList() != null ? getReplicationControllerList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildResourceQuota instead.
 * @return The buildable object.
 */
@Deprecated public ResourceQuota getResourceQuota() {
        return this.resourceQuota!=null?this.resourceQuota.build():null;
    }

    public ResourceQuota buildResourceQuota() {
        return this.resourceQuota!=null?this.resourceQuota.build():null;
    }

    public A withResourceQuota(ResourceQuota resourceQuota) {
        _visitables.get("resourceQuota").remove(this.resourceQuota);
        if (resourceQuota!=null){ this.resourceQuota= new ResourceQuotaBuilder(resourceQuota); _visitables.get("resourceQuota").add(this.resourceQuota);} return (A) this;
    }

    public Boolean hasResourceQuota() {
        return this.resourceQuota != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ResourceQuotaNested<A> withNewResourceQuota() {
        return new ResourceQuotaNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ResourceQuotaNested<A> withNewResourceQuotaLike(ResourceQuota item) {
        return new ResourceQuotaNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ResourceQuotaNested<A> editResourceQuota() {
        return withNewResourceQuotaLike(getResourceQuota());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ResourceQuotaNested<A> editOrNewResourceQuota() {
        return withNewResourceQuotaLike(getResourceQuota() != null ? getResourceQuota(): new ResourceQuotaBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ResourceQuotaNested<A> editOrNewResourceQuotaLike(ResourceQuota item) {
        return withNewResourceQuotaLike(getResourceQuota() != null ? getResourceQuota(): item);
    }

    
/**
 * This method has been deprecated, please use method buildResourceQuotaList instead.
 * @return The buildable object.
 */
@Deprecated public ResourceQuotaList getResourceQuotaList() {
        return this.resourceQuotaList!=null?this.resourceQuotaList.build():null;
    }

    public ResourceQuotaList buildResourceQuotaList() {
        return this.resourceQuotaList!=null?this.resourceQuotaList.build():null;
    }

    public A withResourceQuotaList(ResourceQuotaList resourceQuotaList) {
        _visitables.get("resourceQuotaList").remove(this.resourceQuotaList);
        if (resourceQuotaList!=null){ this.resourceQuotaList= new ResourceQuotaListBuilder(resourceQuotaList); _visitables.get("resourceQuotaList").add(this.resourceQuotaList);} return (A) this;
    }

    public Boolean hasResourceQuotaList() {
        return this.resourceQuotaList != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ResourceQuotaListNested<A> withNewResourceQuotaList() {
        return new ResourceQuotaListNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ResourceQuotaListNested<A> withNewResourceQuotaListLike(ResourceQuotaList item) {
        return new ResourceQuotaListNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ResourceQuotaListNested<A> editResourceQuotaList() {
        return withNewResourceQuotaListLike(getResourceQuotaList());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ResourceQuotaListNested<A> editOrNewResourceQuotaList() {
        return withNewResourceQuotaListLike(getResourceQuotaList() != null ? getResourceQuotaList(): new ResourceQuotaListBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ResourceQuotaListNested<A> editOrNewResourceQuotaListLike(ResourceQuotaList item) {
        return withNewResourceQuotaListLike(getResourceQuotaList() != null ? getResourceQuotaList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRootPaths instead.
 * @return The buildable object.
 */
@Deprecated public RootPaths getRootPaths() {
        return this.rootPaths!=null?this.rootPaths.build():null;
    }

    public RootPaths buildRootPaths() {
        return this.rootPaths!=null?this.rootPaths.build():null;
    }

    public A withRootPaths(RootPaths rootPaths) {
        _visitables.get("rootPaths").remove(this.rootPaths);
        if (rootPaths!=null){ this.rootPaths= new RootPathsBuilder(rootPaths); _visitables.get("rootPaths").add(this.rootPaths);} return (A) this;
    }

    public Boolean hasRootPaths() {
        return this.rootPaths != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.RootPathsNested<A> withNewRootPaths() {
        return new RootPathsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.RootPathsNested<A> withNewRootPathsLike(RootPaths item) {
        return new RootPathsNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.RootPathsNested<A> editRootPaths() {
        return withNewRootPathsLike(getRootPaths());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.RootPathsNested<A> editOrNewRootPaths() {
        return withNewRootPathsLike(getRootPaths() != null ? getRootPaths(): new RootPathsBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.RootPathsNested<A> editOrNewRootPathsLike(RootPaths item) {
        return withNewRootPathsLike(getRootPaths() != null ? getRootPaths(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSecret instead.
 * @return The buildable object.
 */
@Deprecated public Secret getSecret() {
        return this.secret!=null?this.secret.build():null;
    }

    public Secret buildSecret() {
        return this.secret!=null?this.secret.build():null;
    }

    public A withSecret(Secret secret) {
        _visitables.get("secret").remove(this.secret);
        if (secret!=null){ this.secret= new SecretBuilder(secret); _visitables.get("secret").add(this.secret);} return (A) this;
    }

    public Boolean hasSecret() {
        return this.secret != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.SecretNested<A> withNewSecret() {
        return new SecretNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.SecretNested<A> withNewSecretLike(Secret item) {
        return new SecretNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.SecretNested<A> editSecret() {
        return withNewSecretLike(getSecret());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.SecretNested<A> editOrNewSecret() {
        return withNewSecretLike(getSecret() != null ? getSecret(): new SecretBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.SecretNested<A> editOrNewSecretLike(Secret item) {
        return withNewSecretLike(getSecret() != null ? getSecret(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSecretList instead.
 * @return The buildable object.
 */
@Deprecated public SecretList getSecretList() {
        return this.secretList!=null?this.secretList.build():null;
    }

    public SecretList buildSecretList() {
        return this.secretList!=null?this.secretList.build():null;
    }

    public A withSecretList(SecretList secretList) {
        _visitables.get("secretList").remove(this.secretList);
        if (secretList!=null){ this.secretList= new SecretListBuilder(secretList); _visitables.get("secretList").add(this.secretList);} return (A) this;
    }

    public Boolean hasSecretList() {
        return this.secretList != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.SecretListNested<A> withNewSecretList() {
        return new SecretListNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.SecretListNested<A> withNewSecretListLike(SecretList item) {
        return new SecretListNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.SecretListNested<A> editSecretList() {
        return withNewSecretListLike(getSecretList());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.SecretListNested<A> editOrNewSecretList() {
        return withNewSecretListLike(getSecretList() != null ? getSecretList(): new SecretListBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.SecretListNested<A> editOrNewSecretListLike(SecretList item) {
        return withNewSecretListLike(getSecretList() != null ? getSecretList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildServiceAccount instead.
 * @return The buildable object.
 */
@Deprecated public ServiceAccount getServiceAccount() {
        return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public ServiceAccount buildServiceAccount() {
        return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public A withServiceAccount(ServiceAccount serviceAccount) {
        _visitables.get("serviceAccount").remove(this.serviceAccount);
        if (serviceAccount!=null){ this.serviceAccount= new ServiceAccountBuilder(serviceAccount); _visitables.get("serviceAccount").add(this.serviceAccount);} return (A) this;
    }

    public Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceAccountNested<A> withNewServiceAccount() {
        return new ServiceAccountNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceAccountNested<A> withNewServiceAccountLike(ServiceAccount item) {
        return new ServiceAccountNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceAccountNested<A> editServiceAccount() {
        return withNewServiceAccountLike(getServiceAccount());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceAccountNested<A> editOrNewServiceAccount() {
        return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): new ServiceAccountBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceAccountNested<A> editOrNewServiceAccountLike(ServiceAccount item) {
        return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): item);
    }

    
/**
 * This method has been deprecated, please use method buildServiceAccountList instead.
 * @return The buildable object.
 */
@Deprecated public ServiceAccountList getServiceAccountList() {
        return this.serviceAccountList!=null?this.serviceAccountList.build():null;
    }

    public ServiceAccountList buildServiceAccountList() {
        return this.serviceAccountList!=null?this.serviceAccountList.build():null;
    }

    public A withServiceAccountList(ServiceAccountList serviceAccountList) {
        _visitables.get("serviceAccountList").remove(this.serviceAccountList);
        if (serviceAccountList!=null){ this.serviceAccountList= new ServiceAccountListBuilder(serviceAccountList); _visitables.get("serviceAccountList").add(this.serviceAccountList);} return (A) this;
    }

    public Boolean hasServiceAccountList() {
        return this.serviceAccountList != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceAccountListNested<A> withNewServiceAccountList() {
        return new ServiceAccountListNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceAccountListNested<A> withNewServiceAccountListLike(ServiceAccountList item) {
        return new ServiceAccountListNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceAccountListNested<A> editServiceAccountList() {
        return withNewServiceAccountListLike(getServiceAccountList());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceAccountListNested<A> editOrNewServiceAccountList() {
        return withNewServiceAccountListLike(getServiceAccountList() != null ? getServiceAccountList(): new ServiceAccountListBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceAccountListNested<A> editOrNewServiceAccountListLike(ServiceAccountList item) {
        return withNewServiceAccountListLike(getServiceAccountList() != null ? getServiceAccountList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildServiceList instead.
 * @return The buildable object.
 */
@Deprecated public ServiceList getServiceList() {
        return this.serviceList!=null?this.serviceList.build():null;
    }

    public ServiceList buildServiceList() {
        return this.serviceList!=null?this.serviceList.build():null;
    }

    public A withServiceList(ServiceList serviceList) {
        _visitables.get("serviceList").remove(this.serviceList);
        if (serviceList!=null){ this.serviceList= new ServiceListBuilder(serviceList); _visitables.get("serviceList").add(this.serviceList);} return (A) this;
    }

    public Boolean hasServiceList() {
        return this.serviceList != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceListNested<A> withNewServiceList() {
        return new ServiceListNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceListNested<A> withNewServiceListLike(ServiceList item) {
        return new ServiceListNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceListNested<A> editServiceList() {
        return withNewServiceListLike(getServiceList());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceListNested<A> editOrNewServiceList() {
        return withNewServiceListLike(getServiceList() != null ? getServiceList(): new ServiceListBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceListNested<A> editOrNewServiceListLike(ServiceList item) {
        return withNewServiceListLike(getServiceList() != null ? getServiceList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public Status getStatus() {
        return this.status!=null?this.status.build():null;
    }

    public Status buildStatus() {
        return this.status!=null?this.status.build():null;
    }

    public A withStatus(Status status) {
        _visitables.get("status").remove(this.status);
        if (status!=null){ this.status= new StatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.StatusNested<A> withNewStatusLike(Status item) {
        return new StatusNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.StatusNested<A> editStatus() {
        return withNewStatusLike(getStatus());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.StatusNested<A> editOrNewStatus() {
        return withNewStatusLike(getStatus() != null ? getStatus(): new StatusBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.StatusNested<A> editOrNewStatusLike(Status item) {
        return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public String getTime() {
        return this.time;
    }

    public A withTime(String time) {
        this.time=time; return (A) this;
    }

    public Boolean hasTime() {
        return this.time != null;
    }

    public A withNewTime(StringBuilder arg1) {
        return (A)withTime(new String(arg1));
    }

    public A withNewTime(int[] arg1,int arg2,int arg3) {
        return (A)withTime(new String(arg1, arg2, arg3));
    }

    public A withNewTime(char[] arg1) {
        return (A)withTime(new String(arg1));
    }

    public A withNewTime(StringBuffer arg1) {
        return (A)withTime(new String(arg1));
    }

    public A withNewTime(byte[] arg1,int arg2) {
        return (A)withTime(new String(arg1, arg2));
    }

    public A withNewTime(byte[] arg1) {
        return (A)withTime(new String(arg1));
    }

    public A withNewTime(char[] arg1,int arg2,int arg3) {
        return (A)withTime(new String(arg1, arg2, arg3));
    }

    public A withNewTime(byte[] arg1,int arg2,int arg3) {
        return (A)withTime(new String(arg1, arg2, arg3));
    }

    public A withNewTime(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withTime(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewTime(String arg1) {
        return (A)withTime(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildToleration instead.
 * @return The buildable object.
 */
@Deprecated public Toleration getToleration() {
        return this.toleration!=null?this.toleration.build():null;
    }

    public Toleration buildToleration() {
        return this.toleration!=null?this.toleration.build():null;
    }

    public A withToleration(Toleration toleration) {
        _visitables.get("toleration").remove(this.toleration);
        if (toleration!=null){ this.toleration= new TolerationBuilder(toleration); _visitables.get("toleration").add(this.toleration);} return (A) this;
    }

    public Boolean hasToleration() {
        return this.toleration != null;
    }

    public A withNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
        return (A)withToleration(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.TolerationNested<A> withNewToleration() {
        return new TolerationNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.TolerationNested<A> withNewTolerationLike(Toleration item) {
        return new TolerationNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.TolerationNested<A> editToleration() {
        return withNewTolerationLike(getToleration());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.TolerationNested<A> editOrNewToleration() {
        return withNewTolerationLike(getToleration() != null ? getToleration(): new TolerationBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.TolerationNested<A> editOrNewTolerationLike(Toleration item) {
        return withNewTolerationLike(getToleration() != null ? getToleration(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTopologySelectorTerm instead.
 * @return The buildable object.
 */
@Deprecated public TopologySelectorTerm getTopologySelectorTerm() {
        return this.topologySelectorTerm!=null?this.topologySelectorTerm.build():null;
    }

    public TopologySelectorTerm buildTopologySelectorTerm() {
        return this.topologySelectorTerm!=null?this.topologySelectorTerm.build():null;
    }

    public A withTopologySelectorTerm(TopologySelectorTerm topologySelectorTerm) {
        _visitables.get("topologySelectorTerm").remove(this.topologySelectorTerm);
        if (topologySelectorTerm!=null){ this.topologySelectorTerm= new TopologySelectorTermBuilder(topologySelectorTerm); _visitables.get("topologySelectorTerm").add(this.topologySelectorTerm);} return (A) this;
    }

    public Boolean hasTopologySelectorTerm() {
        return this.topologySelectorTerm != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.TopologySelectorTermNested<A> withNewTopologySelectorTerm() {
        return new TopologySelectorTermNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.TopologySelectorTermNested<A> withNewTopologySelectorTermLike(TopologySelectorTerm item) {
        return new TopologySelectorTermNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.TopologySelectorTermNested<A> editTopologySelectorTerm() {
        return withNewTopologySelectorTermLike(getTopologySelectorTerm());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.TopologySelectorTermNested<A> editOrNewTopologySelectorTerm() {
        return withNewTopologySelectorTermLike(getTopologySelectorTerm() != null ? getTopologySelectorTerm(): new TopologySelectorTermBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.TopologySelectorTermNested<A> editOrNewTopologySelectorTermLike(TopologySelectorTerm item) {
        return withNewTopologySelectorTermLike(getTopologySelectorTerm() != null ? getTopologySelectorTerm(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTypeMeta instead.
 * @return The buildable object.
 */
@Deprecated public TypeMeta getTypeMeta() {
        return this.typeMeta!=null?this.typeMeta.build():null;
    }

    public TypeMeta buildTypeMeta() {
        return this.typeMeta!=null?this.typeMeta.build():null;
    }

    public A withTypeMeta(TypeMeta typeMeta) {
        _visitables.get("typeMeta").remove(this.typeMeta);
        if (typeMeta!=null){ this.typeMeta= new TypeMetaBuilder(typeMeta); _visitables.get("typeMeta").add(this.typeMeta);} return (A) this;
    }

    public Boolean hasTypeMeta() {
        return this.typeMeta != null;
    }

    public A withNewTypeMeta(String apiVersion,String kind) {
        return (A)withTypeMeta(new TypeMeta(apiVersion, kind));
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.TypeMetaNested<A> withNewTypeMeta() {
        return new TypeMetaNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.TypeMetaNested<A> withNewTypeMetaLike(TypeMeta item) {
        return new TypeMetaNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.TypeMetaNested<A> editTypeMeta() {
        return withNewTypeMetaLike(getTypeMeta());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.TypeMetaNested<A> editOrNewTypeMeta() {
        return withNewTypeMetaLike(getTypeMeta() != null ? getTypeMeta(): new TypeMetaBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.TypeMetaNested<A> editOrNewTypeMetaLike(TypeMeta item) {
        return withNewTypeMetaLike(getTypeMeta() != null ? getTypeMeta(): item);
    }

    
/**
 * This method has been deprecated, please use method buildUpdateOptions instead.
 * @return The buildable object.
 */
@Deprecated public UpdateOptions getUpdateOptions() {
        return this.updateOptions!=null?this.updateOptions.build():null;
    }

    public UpdateOptions buildUpdateOptions() {
        return this.updateOptions!=null?this.updateOptions.build():null;
    }

    public A withUpdateOptions(UpdateOptions updateOptions) {
        _visitables.get("updateOptions").remove(this.updateOptions);
        if (updateOptions!=null){ this.updateOptions= new UpdateOptionsBuilder(updateOptions); _visitables.get("updateOptions").add(this.updateOptions);} return (A) this;
    }

    public Boolean hasUpdateOptions() {
        return this.updateOptions != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.UpdateOptionsNested<A> withNewUpdateOptions() {
        return new UpdateOptionsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.UpdateOptionsNested<A> withNewUpdateOptionsLike(UpdateOptions item) {
        return new UpdateOptionsNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.UpdateOptionsNested<A> editUpdateOptions() {
        return withNewUpdateOptionsLike(getUpdateOptions());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.UpdateOptionsNested<A> editOrNewUpdateOptions() {
        return withNewUpdateOptionsLike(getUpdateOptions() != null ? getUpdateOptions(): new UpdateOptionsBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.UpdateOptionsNested<A> editOrNewUpdateOptionsLike(UpdateOptions item) {
        return withNewUpdateOptionsLike(getUpdateOptions() != null ? getUpdateOptions(): item);
    }

    
/**
 * This method has been deprecated, please use method buildWatchEvent instead.
 * @return The buildable object.
 */
@Deprecated public WatchEvent getWatchEvent() {
        return this.watchEvent!=null?this.watchEvent.build():null;
    }

    public WatchEvent buildWatchEvent() {
        return this.watchEvent!=null?this.watchEvent.build():null;
    }

    public A withWatchEvent(WatchEvent watchEvent) {
        _visitables.get("watchEvent").remove(this.watchEvent);
        if (watchEvent!=null){ this.watchEvent= new WatchEventBuilder(watchEvent); _visitables.get("watchEvent").add(this.watchEvent);} return (A) this;
    }

    public Boolean hasWatchEvent() {
        return this.watchEvent != null;
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.WatchEventNested<A> withNewWatchEvent() {
        return new WatchEventNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.WatchEventNested<A> withNewWatchEventLike(WatchEvent item) {
        return new WatchEventNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.WatchEventNested<A> editWatchEvent() {
        return withNewWatchEventLike(getWatchEvent());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.WatchEventNested<A> editOrNewWatchEvent() {
        return withNewWatchEventLike(getWatchEvent() != null ? getWatchEvent(): new WatchEventBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.KubeSchemaFluent.WatchEventNested<A> editOrNewWatchEventLike(WatchEvent item) {
        return withNewWatchEventLike(getWatchEvent() != null ? getWatchEvent(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KubeSchemaFluentImpl that = (KubeSchemaFluentImpl) o;
        if (aPIGroup != null ? !aPIGroup.equals(that.aPIGroup) :that.aPIGroup != null) return false;
        if (aPIGroupList != null ? !aPIGroupList.equals(that.aPIGroupList) :that.aPIGroupList != null) return false;
        if (aPIService != null ? !aPIService.equals(that.aPIService) :that.aPIService != null) return false;
        if (aPIServiceList != null ? !aPIServiceList.equals(that.aPIServiceList) :that.aPIServiceList != null) return false;
        if (baseKubernetesList != null ? !baseKubernetesList.equals(that.baseKubernetesList) :that.baseKubernetesList != null) return false;
        if (binding != null ? !binding.equals(that.binding) :that.binding != null) return false;
        if (componentStatus != null ? !componentStatus.equals(that.componentStatus) :that.componentStatus != null) return false;
        if (componentStatusList != null ? !componentStatusList.equals(that.componentStatusList) :that.componentStatusList != null) return false;
        if (condition != null ? !condition.equals(that.condition) :that.condition != null) return false;
        if (config != null ? !config.equals(that.config) :that.config != null) return false;
        if (configMap != null ? !configMap.equals(that.configMap) :that.configMap != null) return false;
        if (configMapList != null ? !configMapList.equals(that.configMapList) :that.configMapList != null) return false;
        if (containerStatus != null ? !containerStatus.equals(that.containerStatus) :that.containerStatus != null) return false;
        if (createOptions != null ? !createOptions.equals(that.createOptions) :that.createOptions != null) return false;
        if (deleteOptions != null ? !deleteOptions.equals(that.deleteOptions) :that.deleteOptions != null) return false;
        if (endpointPort != null ? !endpointPort.equals(that.endpointPort) :that.endpointPort != null) return false;
        if (endpoints != null ? !endpoints.equals(that.endpoints) :that.endpoints != null) return false;
        if (endpointsList != null ? !endpointsList.equals(that.endpointsList) :that.endpointsList != null) return false;
        if (envVar != null ? !envVar.equals(that.envVar) :that.envVar != null) return false;
        if (event != null ? !event.equals(that.event) :that.event != null) return false;
        if (eventList != null ? !eventList.equals(that.eventList) :that.eventList != null) return false;
        if (eventSeries != null ? !eventSeries.equals(that.eventSeries) :that.eventSeries != null) return false;
        if (eventSource != null ? !eventSource.equals(that.eventSource) :that.eventSource != null) return false;
        if (getOptions != null ? !getOptions.equals(that.getOptions) :that.getOptions != null) return false;
        if (groupVersionKind != null ? !groupVersionKind.equals(that.groupVersionKind) :that.groupVersionKind != null) return false;
        if (groupVersionResource != null ? !groupVersionResource.equals(that.groupVersionResource) :that.groupVersionResource != null) return false;
        if (info != null ? !info.equals(that.info) :that.info != null) return false;
        if (limitRangeList != null ? !limitRangeList.equals(that.limitRangeList) :that.limitRangeList != null) return false;
        if (listOptions != null ? !listOptions.equals(that.listOptions) :that.listOptions != null) return false;
        if (microTime != null ? !microTime.equals(that.microTime) :that.microTime != null) return false;
        if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
        if (namespaceList != null ? !namespaceList.equals(that.namespaceList) :that.namespaceList != null) return false;
        if (node != null ? !node.equals(that.node) :that.node != null) return false;
        if (nodeList != null ? !nodeList.equals(that.nodeList) :that.nodeList != null) return false;
        if (objectMeta != null ? !objectMeta.equals(that.objectMeta) :that.objectMeta != null) return false;
        if (patch != null ? !patch.equals(that.patch) :that.patch != null) return false;
        if (patchOptions != null ? !patchOptions.equals(that.patchOptions) :that.patchOptions != null) return false;
        if (persistentVolume != null ? !persistentVolume.equals(that.persistentVolume) :that.persistentVolume != null) return false;
        if (persistentVolumeClaim != null ? !persistentVolumeClaim.equals(that.persistentVolumeClaim) :that.persistentVolumeClaim != null) return false;
        if (persistentVolumeClaimList != null ? !persistentVolumeClaimList.equals(that.persistentVolumeClaimList) :that.persistentVolumeClaimList != null) return false;
        if (persistentVolumeList != null ? !persistentVolumeList.equals(that.persistentVolumeList) :that.persistentVolumeList != null) return false;
        if (podExecOptions != null ? !podExecOptions.equals(that.podExecOptions) :that.podExecOptions != null) return false;
        if (podList != null ? !podList.equals(that.podList) :that.podList != null) return false;
        if (podTemplateList != null ? !podTemplateList.equals(that.podTemplateList) :that.podTemplateList != null) return false;
        if (quantity != null ? !quantity.equals(that.quantity) :that.quantity != null) return false;
        if (replicationControllerList != null ? !replicationControllerList.equals(that.replicationControllerList) :that.replicationControllerList != null) return false;
        if (resourceQuota != null ? !resourceQuota.equals(that.resourceQuota) :that.resourceQuota != null) return false;
        if (resourceQuotaList != null ? !resourceQuotaList.equals(that.resourceQuotaList) :that.resourceQuotaList != null) return false;
        if (rootPaths != null ? !rootPaths.equals(that.rootPaths) :that.rootPaths != null) return false;
        if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
        if (secretList != null ? !secretList.equals(that.secretList) :that.secretList != null) return false;
        if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
        if (serviceAccountList != null ? !serviceAccountList.equals(that.serviceAccountList) :that.serviceAccountList != null) return false;
        if (serviceList != null ? !serviceList.equals(that.serviceList) :that.serviceList != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        if (time != null ? !time.equals(that.time) :that.time != null) return false;
        if (toleration != null ? !toleration.equals(that.toleration) :that.toleration != null) return false;
        if (topologySelectorTerm != null ? !topologySelectorTerm.equals(that.topologySelectorTerm) :that.topologySelectorTerm != null) return false;
        if (typeMeta != null ? !typeMeta.equals(that.typeMeta) :that.typeMeta != null) return false;
        if (updateOptions != null ? !updateOptions.equals(that.updateOptions) :that.updateOptions != null) return false;
        if (watchEvent != null ? !watchEvent.equals(that.watchEvent) :that.watchEvent != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(aPIGroup,  aPIGroupList,  aPIService,  aPIServiceList,  baseKubernetesList,  binding,  componentStatus,  componentStatusList,  condition,  config,  configMap,  configMapList,  containerStatus,  createOptions,  deleteOptions,  endpointPort,  endpoints,  endpointsList,  envVar,  event,  eventList,  eventSeries,  eventSource,  getOptions,  groupVersionKind,  groupVersionResource,  info,  limitRangeList,  listOptions,  microTime,  namespace,  namespaceList,  node,  nodeList,  objectMeta,  patch,  patchOptions,  persistentVolume,  persistentVolumeClaim,  persistentVolumeClaimList,  persistentVolumeList,  podExecOptions,  podList,  podTemplateList,  quantity,  replicationControllerList,  resourceQuota,  resourceQuotaList,  rootPaths,  secret,  secretList,  serviceAccount,  serviceAccountList,  serviceList,  status,  time,  toleration,  topologySelectorTerm,  typeMeta,  updateOptions,  watchEvent,  super.hashCode());
    }

    public class APIGroupNestedImpl<N> extends APIGroupFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIGroupNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIGroupNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIGroupBuilder builder;

            APIGroupNestedImpl(APIGroup item) {
                this.builder = new APIGroupBuilder(this, item);
                        
            }

            APIGroupNestedImpl() {
                this.builder = new APIGroupBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withAPIGroup(builder.build());
            }

            public N endAPIGroup() {
                return and();
            }
    }


    public class APIGroupListNestedImpl<N> extends APIGroupListFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIGroupListNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIGroupListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIGroupListBuilder builder;

            APIGroupListNestedImpl(APIGroupList item) {
                this.builder = new APIGroupListBuilder(this, item);
                        
            }

            APIGroupListNestedImpl() {
                this.builder = new APIGroupListBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withAPIGroupList(builder.build());
            }

            public N endAPIGroupList() {
                return and();
            }
    }


    public class APIServiceNestedImpl<N> extends APIServiceFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIServiceNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIServiceBuilder builder;

            APIServiceNestedImpl(APIService item) {
                this.builder = new APIServiceBuilder(this, item);
                        
            }

            APIServiceNestedImpl() {
                this.builder = new APIServiceBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withAPIService(builder.build());
            }

            public N endAPIService() {
                return and();
            }
    }


    public class APIServiceListNestedImpl<N> extends APIServiceListFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIServiceListNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.APIServiceListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIServiceListBuilder builder;

            APIServiceListNestedImpl(APIServiceList item) {
                this.builder = new APIServiceListBuilder(this, item);
                        
            }

            APIServiceListNestedImpl() {
                this.builder = new APIServiceListBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withAPIServiceList(builder.build());
            }

            public N endAPIServiceList() {
                return and();
            }
    }


    public class BaseKubernetesListNestedImpl<N> extends BaseKubernetesListFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.BaseKubernetesListNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.BaseKubernetesListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BaseKubernetesListBuilder builder;

            BaseKubernetesListNestedImpl(BaseKubernetesList item) {
                this.builder = new BaseKubernetesListBuilder(this, item);
                        
            }

            BaseKubernetesListNestedImpl() {
                this.builder = new BaseKubernetesListBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withBaseKubernetesList(builder.build());
            }

            public N endBaseKubernetesList() {
                return and();
            }
    }


    public class BindingNestedImpl<N> extends BindingFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.BindingNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.BindingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BindingBuilder builder;

            BindingNestedImpl(Binding item) {
                this.builder = new BindingBuilder(this, item);
                        
            }

            BindingNestedImpl() {
                this.builder = new BindingBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withBinding(builder.build());
            }

            public N endBinding() {
                return and();
            }
    }


    public class ComponentStatusNestedImpl<N> extends ComponentStatusFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.ComponentStatusNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.ComponentStatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ComponentStatusBuilder builder;

            ComponentStatusNestedImpl(ComponentStatus item) {
                this.builder = new ComponentStatusBuilder(this, item);
                        
            }

            ComponentStatusNestedImpl() {
                this.builder = new ComponentStatusBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withComponentStatus(builder.build());
            }

            public N endComponentStatus() {
                return and();
            }
    }


    public class ComponentStatusListNestedImpl<N> extends ComponentStatusListFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.ComponentStatusListNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.ComponentStatusListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ComponentStatusListBuilder builder;

            ComponentStatusListNestedImpl(ComponentStatusList item) {
                this.builder = new ComponentStatusListBuilder(this, item);
                        
            }

            ComponentStatusListNestedImpl() {
                this.builder = new ComponentStatusListBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withComponentStatusList(builder.build());
            }

            public N endComponentStatusList() {
                return and();
            }
    }


    public class ConditionNestedImpl<N> extends ConditionFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConditionNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConditionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConditionBuilder builder;

            ConditionNestedImpl(Condition item) {
                this.builder = new ConditionBuilder(this, item);
                        
            }

            ConditionNestedImpl() {
                this.builder = new ConditionBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withCondition(builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


    public class ConfigNestedImpl<N> extends ConfigFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigBuilder builder;

            ConfigNestedImpl(Config item) {
                this.builder = new ConfigBuilder(this, item);
                        
            }

            ConfigNestedImpl() {
                this.builder = new ConfigBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withConfig(builder.build());
            }

            public N endConfig() {
                return and();
            }
    }


    public class ConfigMapNestedImpl<N> extends ConfigMapFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigMapNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigMapNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigMapBuilder builder;

            ConfigMapNestedImpl(ConfigMap item) {
                this.builder = new ConfigMapBuilder(this, item);
                        
            }

            ConfigMapNestedImpl() {
                this.builder = new ConfigMapBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withConfigMap(builder.build());
            }

            public N endConfigMap() {
                return and();
            }
    }


    public class ConfigMapListNestedImpl<N> extends ConfigMapListFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigMapListNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.ConfigMapListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigMapListBuilder builder;

            ConfigMapListNestedImpl(ConfigMapList item) {
                this.builder = new ConfigMapListBuilder(this, item);
                        
            }

            ConfigMapListNestedImpl() {
                this.builder = new ConfigMapListBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withConfigMapList(builder.build());
            }

            public N endConfigMapList() {
                return and();
            }
    }


    public class ContainerStatusNestedImpl<N> extends ContainerStatusFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.ContainerStatusNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.ContainerStatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerStatusBuilder builder;

            ContainerStatusNestedImpl(ContainerStatus item) {
                this.builder = new ContainerStatusBuilder(this, item);
                        
            }

            ContainerStatusNestedImpl() {
                this.builder = new ContainerStatusBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withContainerStatus(builder.build());
            }

            public N endContainerStatus() {
                return and();
            }
    }


    public class CreateOptionsNestedImpl<N> extends CreateOptionsFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.CreateOptionsNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.CreateOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CreateOptionsBuilder builder;

            CreateOptionsNestedImpl(CreateOptions item) {
                this.builder = new CreateOptionsBuilder(this, item);
                        
            }

            CreateOptionsNestedImpl() {
                this.builder = new CreateOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withCreateOptions(builder.build());
            }

            public N endCreateOptions() {
                return and();
            }
    }


    public class DeleteOptionsNestedImpl<N> extends DeleteOptionsFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.DeleteOptionsNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.DeleteOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DeleteOptionsBuilder builder;

            DeleteOptionsNestedImpl(DeleteOptions item) {
                this.builder = new DeleteOptionsBuilder(this, item);
                        
            }

            DeleteOptionsNestedImpl() {
                this.builder = new DeleteOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withDeleteOptions(builder.build());
            }

            public N endDeleteOptions() {
                return and();
            }
    }


    public class EndpointPortNestedImpl<N> extends EndpointPortFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointPortNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointPortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EndpointPortBuilder builder;

            EndpointPortNestedImpl(EndpointPort item) {
                this.builder = new EndpointPortBuilder(this, item);
                        
            }

            EndpointPortNestedImpl() {
                this.builder = new EndpointPortBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withEndpointPort(builder.build());
            }

            public N endEndpointPort() {
                return and();
            }
    }


    public class EndpointsNestedImpl<N> extends EndpointsFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointsNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EndpointsBuilder builder;

            EndpointsNestedImpl(Endpoints item) {
                this.builder = new EndpointsBuilder(this, item);
                        
            }

            EndpointsNestedImpl() {
                this.builder = new EndpointsBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withEndpoints(builder.build());
            }

            public N endEndpoints() {
                return and();
            }
    }


    public class EndpointsListNestedImpl<N> extends EndpointsListFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointsListNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.EndpointsListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EndpointsListBuilder builder;

            EndpointsListNestedImpl(EndpointsList item) {
                this.builder = new EndpointsListBuilder(this, item);
                        
            }

            EndpointsListNestedImpl() {
                this.builder = new EndpointsListBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withEndpointsList(builder.build());
            }

            public N endEndpointsList() {
                return and();
            }
    }


    public class EnvVarNestedImpl<N> extends EnvVarFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.EnvVarNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.EnvVarNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EnvVarBuilder builder;

            EnvVarNestedImpl(EnvVar item) {
                this.builder = new EnvVarBuilder(this, item);
                        
            }

            EnvVarNestedImpl() {
                this.builder = new EnvVarBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withEnvVar(builder.build());
            }

            public N endEnvVar() {
                return and();
            }
    }


    public class EventNestedImpl<N> extends EventFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EventBuilder builder;

            EventNestedImpl(Event item) {
                this.builder = new EventBuilder(this, item);
                        
            }

            EventNestedImpl() {
                this.builder = new EventBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withEvent(builder.build());
            }

            public N endEvent() {
                return and();
            }
    }


    public class EventListNestedImpl<N> extends EventListFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventListNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EventListBuilder builder;

            EventListNestedImpl(EventList item) {
                this.builder = new EventListBuilder(this, item);
                        
            }

            EventListNestedImpl() {
                this.builder = new EventListBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withEventList(builder.build());
            }

            public N endEventList() {
                return and();
            }
    }


    public class EventSeriesNestedImpl<N> extends EventSeriesFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventSeriesNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventSeriesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EventSeriesBuilder builder;

            EventSeriesNestedImpl(EventSeries item) {
                this.builder = new EventSeriesBuilder(this, item);
                        
            }

            EventSeriesNestedImpl() {
                this.builder = new EventSeriesBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withEventSeries(builder.build());
            }

            public N endEventSeries() {
                return and();
            }
    }


    public class EventSourceNestedImpl<N> extends EventSourceFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventSourceNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.EventSourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EventSourceBuilder builder;

            EventSourceNestedImpl(EventSource item) {
                this.builder = new EventSourceBuilder(this, item);
                        
            }

            EventSourceNestedImpl() {
                this.builder = new EventSourceBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withEventSource(builder.build());
            }

            public N endEventSource() {
                return and();
            }
    }


    public class GetOptionsNestedImpl<N> extends GetOptionsFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.GetOptionsNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.GetOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GetOptionsBuilder builder;

            GetOptionsNestedImpl(GetOptions item) {
                this.builder = new GetOptionsBuilder(this, item);
                        
            }

            GetOptionsNestedImpl() {
                this.builder = new GetOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withGetOptions(builder.build());
            }

            public N endGetOptions() {
                return and();
            }
    }


    public class GroupVersionKindNestedImpl<N> extends GroupVersionKindFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.GroupVersionKindNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.GroupVersionKindNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GroupVersionKindBuilder builder;

            GroupVersionKindNestedImpl(GroupVersionKind item) {
                this.builder = new GroupVersionKindBuilder(this, item);
                        
            }

            GroupVersionKindNestedImpl() {
                this.builder = new GroupVersionKindBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withGroupVersionKind(builder.build());
            }

            public N endGroupVersionKind() {
                return and();
            }
    }


    public class GroupVersionResourceNestedImpl<N> extends GroupVersionResourceFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.GroupVersionResourceNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.GroupVersionResourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GroupVersionResourceBuilder builder;

            GroupVersionResourceNestedImpl(GroupVersionResource item) {
                this.builder = new GroupVersionResourceBuilder(this, item);
                        
            }

            GroupVersionResourceNestedImpl() {
                this.builder = new GroupVersionResourceBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withGroupVersionResource(builder.build());
            }

            public N endGroupVersionResource() {
                return and();
            }
    }


    public class InfoNestedImpl<N> extends InfoFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.InfoNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.InfoNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final InfoBuilder builder;

            InfoNestedImpl(Info item) {
                this.builder = new InfoBuilder(this, item);
                        
            }

            InfoNestedImpl() {
                this.builder = new InfoBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withInfo(builder.build());
            }

            public N endInfo() {
                return and();
            }
    }


    public class LimitRangeListNestedImpl<N> extends LimitRangeListFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.LimitRangeListNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.LimitRangeListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LimitRangeListBuilder builder;

            LimitRangeListNestedImpl(LimitRangeList item) {
                this.builder = new LimitRangeListBuilder(this, item);
                        
            }

            LimitRangeListNestedImpl() {
                this.builder = new LimitRangeListBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withLimitRangeList(builder.build());
            }

            public N endLimitRangeList() {
                return and();
            }
    }


    public class ListOptionsNestedImpl<N> extends ListOptionsFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.ListOptionsNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.ListOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ListOptionsBuilder builder;

            ListOptionsNestedImpl(ListOptions item) {
                this.builder = new ListOptionsBuilder(this, item);
                        
            }

            ListOptionsNestedImpl() {
                this.builder = new ListOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withListOptions(builder.build());
            }

            public N endListOptions() {
                return and();
            }
    }


    public class MicroTimeNestedImpl<N> extends MicroTimeFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.MicroTimeNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.MicroTimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final MicroTimeBuilder builder;

            MicroTimeNestedImpl(MicroTime item) {
                this.builder = new MicroTimeBuilder(this, item);
                        
            }

            MicroTimeNestedImpl() {
                this.builder = new MicroTimeBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withMicroTime(builder.build());
            }

            public N endMicroTime() {
                return and();
            }
    }


    public class NamespaceNestedImpl<N> extends NamespaceFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.NamespaceNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.NamespaceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NamespaceBuilder builder;

            NamespaceNestedImpl(Namespace item) {
                this.builder = new NamespaceBuilder(this, item);
                        
            }

            NamespaceNestedImpl() {
                this.builder = new NamespaceBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withNamespace(builder.build());
            }

            public N endNamespace() {
                return and();
            }
    }


    public class NamespaceListNestedImpl<N> extends NamespaceListFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.NamespaceListNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.NamespaceListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NamespaceListBuilder builder;

            NamespaceListNestedImpl(NamespaceList item) {
                this.builder = new NamespaceListBuilder(this, item);
                        
            }

            NamespaceListNestedImpl() {
                this.builder = new NamespaceListBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withNamespaceList(builder.build());
            }

            public N endNamespaceList() {
                return and();
            }
    }


    public class NodeNestedImpl<N> extends NodeFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.NodeNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.NodeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodeBuilder builder;

            NodeNestedImpl(io.fabric8.kubernetes.api.model.Node item) {
                this.builder = new NodeBuilder(this, item);
                        
            }

            NodeNestedImpl() {
                this.builder = new NodeBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withNode(builder.build());
            }

            public N endNode() {
                return and();
            }
    }


    public class NodeListNestedImpl<N> extends NodeListFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.NodeListNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.NodeListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodeListBuilder builder;

            NodeListNestedImpl(NodeList item) {
                this.builder = new NodeListBuilder(this, item);
                        
            }

            NodeListNestedImpl() {
                this.builder = new NodeListBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withNodeList(builder.build());
            }

            public N endNodeList() {
                return and();
            }
    }


    public class ObjectMetaNestedImpl<N> extends ObjectMetaFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.ObjectMetaNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.ObjectMetaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

            ObjectMetaNestedImpl(ObjectMeta item) {
                this.builder = new ObjectMetaBuilder(this, item);
                        
            }

            ObjectMetaNestedImpl() {
                this.builder = new ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withObjectMeta(builder.build());
            }

            public N endObjectMeta() {
                return and();
            }
    }


    public class PatchNestedImpl<N> extends PatchFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.PatchNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.PatchNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PatchBuilder builder;

            PatchNestedImpl(Patch item) {
                this.builder = new PatchBuilder(this, item);
                        
            }

            PatchNestedImpl() {
                this.builder = new PatchBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withPatch(builder.build());
            }

            public N endPatch() {
                return and();
            }
    }


    public class PatchOptionsNestedImpl<N> extends PatchOptionsFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.PatchOptionsNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.PatchOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PatchOptionsBuilder builder;

            PatchOptionsNestedImpl(PatchOptions item) {
                this.builder = new PatchOptionsBuilder(this, item);
                        
            }

            PatchOptionsNestedImpl() {
                this.builder = new PatchOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withPatchOptions(builder.build());
            }

            public N endPatchOptions() {
                return and();
            }
    }


    public class PersistentVolumeNestedImpl<N> extends PersistentVolumeFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeBuilder builder;

            PersistentVolumeNestedImpl(PersistentVolume item) {
                this.builder = new PersistentVolumeBuilder(this, item);
                        
            }

            PersistentVolumeNestedImpl() {
                this.builder = new PersistentVolumeBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withPersistentVolume(builder.build());
            }

            public N endPersistentVolume() {
                return and();
            }
    }


    public class PersistentVolumeClaimNestedImpl<N> extends PersistentVolumeClaimFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeClaimNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeClaimNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeClaimBuilder builder;

            PersistentVolumeClaimNestedImpl(PersistentVolumeClaim item) {
                this.builder = new PersistentVolumeClaimBuilder(this, item);
                        
            }

            PersistentVolumeClaimNestedImpl() {
                this.builder = new PersistentVolumeClaimBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withPersistentVolumeClaim(builder.build());
            }

            public N endPersistentVolumeClaim() {
                return and();
            }
    }


    public class PersistentVolumeClaimListNestedImpl<N> extends PersistentVolumeClaimListFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeClaimListNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeClaimListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeClaimListBuilder builder;

            PersistentVolumeClaimListNestedImpl(PersistentVolumeClaimList item) {
                this.builder = new PersistentVolumeClaimListBuilder(this, item);
                        
            }

            PersistentVolumeClaimListNestedImpl() {
                this.builder = new PersistentVolumeClaimListBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withPersistentVolumeClaimList(builder.build());
            }

            public N endPersistentVolumeClaimList() {
                return and();
            }
    }


    public class PersistentVolumeListNestedImpl<N> extends PersistentVolumeListFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeListNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.PersistentVolumeListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeListBuilder builder;

            PersistentVolumeListNestedImpl(PersistentVolumeList item) {
                this.builder = new PersistentVolumeListBuilder(this, item);
                        
            }

            PersistentVolumeListNestedImpl() {
                this.builder = new PersistentVolumeListBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withPersistentVolumeList(builder.build());
            }

            public N endPersistentVolumeList() {
                return and();
            }
    }


    public class PodExecOptionsNestedImpl<N> extends PodExecOptionsFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodExecOptionsNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodExecOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodExecOptionsBuilder builder;

            PodExecOptionsNestedImpl(PodExecOptions item) {
                this.builder = new PodExecOptionsBuilder(this, item);
                        
            }

            PodExecOptionsNestedImpl() {
                this.builder = new PodExecOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withPodExecOptions(builder.build());
            }

            public N endPodExecOptions() {
                return and();
            }
    }


    public class PodListNestedImpl<N> extends PodListFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodListNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodListBuilder builder;

            PodListNestedImpl(PodList item) {
                this.builder = new PodListBuilder(this, item);
                        
            }

            PodListNestedImpl() {
                this.builder = new PodListBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withPodList(builder.build());
            }

            public N endPodList() {
                return and();
            }
    }


    public class PodTemplateListNestedImpl<N> extends PodTemplateListFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodTemplateListNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.PodTemplateListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodTemplateListBuilder builder;

            PodTemplateListNestedImpl(PodTemplateList item) {
                this.builder = new PodTemplateListBuilder(this, item);
                        
            }

            PodTemplateListNestedImpl() {
                this.builder = new PodTemplateListBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withPodTemplateList(builder.build());
            }

            public N endPodTemplateList() {
                return and();
            }
    }


    public class QuantityNestedImpl<N> extends QuantityFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.QuantityNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.QuantityNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final QuantityBuilder builder;

            QuantityNestedImpl(Quantity item) {
                this.builder = new QuantityBuilder(this, item);
                        
            }

            QuantityNestedImpl() {
                this.builder = new QuantityBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withQuantity(builder.build());
            }

            public N endQuantity() {
                return and();
            }
    }


    public class ReplicationControllerListNestedImpl<N> extends ReplicationControllerListFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.ReplicationControllerListNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.ReplicationControllerListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ReplicationControllerListBuilder builder;

            ReplicationControllerListNestedImpl(ReplicationControllerList item) {
                this.builder = new ReplicationControllerListBuilder(this, item);
                        
            }

            ReplicationControllerListNestedImpl() {
                this.builder = new ReplicationControllerListBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withReplicationControllerList(builder.build());
            }

            public N endReplicationControllerList() {
                return and();
            }
    }


    public class ResourceQuotaNestedImpl<N> extends ResourceQuotaFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.ResourceQuotaNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.ResourceQuotaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceQuotaBuilder builder;

            ResourceQuotaNestedImpl(ResourceQuota item) {
                this.builder = new ResourceQuotaBuilder(this, item);
                        
            }

            ResourceQuotaNestedImpl() {
                this.builder = new ResourceQuotaBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withResourceQuota(builder.build());
            }

            public N endResourceQuota() {
                return and();
            }
    }


    public class ResourceQuotaListNestedImpl<N> extends ResourceQuotaListFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.ResourceQuotaListNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.ResourceQuotaListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceQuotaListBuilder builder;

            ResourceQuotaListNestedImpl(ResourceQuotaList item) {
                this.builder = new ResourceQuotaListBuilder(this, item);
                        
            }

            ResourceQuotaListNestedImpl() {
                this.builder = new ResourceQuotaListBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withResourceQuotaList(builder.build());
            }

            public N endResourceQuotaList() {
                return and();
            }
    }


    public class RootPathsNestedImpl<N> extends RootPathsFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.RootPathsNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.RootPathsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RootPathsBuilder builder;

            RootPathsNestedImpl(RootPaths item) {
                this.builder = new RootPathsBuilder(this, item);
                        
            }

            RootPathsNestedImpl() {
                this.builder = new RootPathsBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withRootPaths(builder.build());
            }

            public N endRootPaths() {
                return and();
            }
    }


    public class SecretNestedImpl<N> extends SecretFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.SecretNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.SecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretBuilder builder;

            SecretNestedImpl(Secret item) {
                this.builder = new SecretBuilder(this, item);
                        
            }

            SecretNestedImpl() {
                this.builder = new SecretBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withSecret(builder.build());
            }

            public N endSecret() {
                return and();
            }
    }


    public class SecretListNestedImpl<N> extends SecretListFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.SecretListNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.SecretListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretListBuilder builder;

            SecretListNestedImpl(SecretList item) {
                this.builder = new SecretListBuilder(this, item);
                        
            }

            SecretListNestedImpl() {
                this.builder = new SecretListBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withSecretList(builder.build());
            }

            public N endSecretList() {
                return and();
            }
    }


    public class ServiceAccountNestedImpl<N> extends ServiceAccountFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceAccountNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceAccountNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceAccountBuilder builder;

            ServiceAccountNestedImpl(ServiceAccount item) {
                this.builder = new ServiceAccountBuilder(this, item);
                        
            }

            ServiceAccountNestedImpl() {
                this.builder = new ServiceAccountBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withServiceAccount(builder.build());
            }

            public N endServiceAccount() {
                return and();
            }
    }


    public class ServiceAccountListNestedImpl<N> extends ServiceAccountListFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceAccountListNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceAccountListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceAccountListBuilder builder;

            ServiceAccountListNestedImpl(ServiceAccountList item) {
                this.builder = new ServiceAccountListBuilder(this, item);
                        
            }

            ServiceAccountListNestedImpl() {
                this.builder = new ServiceAccountListBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withServiceAccountList(builder.build());
            }

            public N endServiceAccountList() {
                return and();
            }
    }


    public class ServiceListNestedImpl<N> extends ServiceListFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceListNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.ServiceListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceListBuilder builder;

            ServiceListNestedImpl(ServiceList item) {
                this.builder = new ServiceListBuilder(this, item);
                        
            }

            ServiceListNestedImpl() {
                this.builder = new ServiceListBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withServiceList(builder.build());
            }

            public N endServiceList() {
                return and();
            }
    }


    public class StatusNestedImpl<N> extends StatusFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.StatusNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final StatusBuilder builder;

            StatusNestedImpl(Status item) {
                this.builder = new StatusBuilder(this, item);
                        
            }

            StatusNestedImpl() {
                this.builder = new StatusBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withStatus(builder.build());
            }

            public N endStatus() {
                return and();
            }
    }


    public class TolerationNestedImpl<N> extends TolerationFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.TolerationNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.TolerationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TolerationBuilder builder;

            TolerationNestedImpl(Toleration item) {
                this.builder = new TolerationBuilder(this, item);
                        
            }

            TolerationNestedImpl() {
                this.builder = new TolerationBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withToleration(builder.build());
            }

            public N endToleration() {
                return and();
            }
    }


    public class TopologySelectorTermNestedImpl<N> extends TopologySelectorTermFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.TopologySelectorTermNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.TopologySelectorTermNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TopologySelectorTermBuilder builder;

            TopologySelectorTermNestedImpl(TopologySelectorTerm item) {
                this.builder = new TopologySelectorTermBuilder(this, item);
                        
            }

            TopologySelectorTermNestedImpl() {
                this.builder = new TopologySelectorTermBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withTopologySelectorTerm(builder.build());
            }

            public N endTopologySelectorTerm() {
                return and();
            }
    }


    public class TypeMetaNestedImpl<N> extends TypeMetaFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.TypeMetaNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.TypeMetaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TypeMetaBuilder builder;

            TypeMetaNestedImpl(TypeMeta item) {
                this.builder = new TypeMetaBuilder(this, item);
                        
            }

            TypeMetaNestedImpl() {
                this.builder = new TypeMetaBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withTypeMeta(builder.build());
            }

            public N endTypeMeta() {
                return and();
            }
    }


    public class UpdateOptionsNestedImpl<N> extends UpdateOptionsFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.UpdateOptionsNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.UpdateOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final UpdateOptionsBuilder builder;

            UpdateOptionsNestedImpl(UpdateOptions item) {
                this.builder = new UpdateOptionsBuilder(this, item);
                        
            }

            UpdateOptionsNestedImpl() {
                this.builder = new UpdateOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withUpdateOptions(builder.build());
            }

            public N endUpdateOptions() {
                return and();
            }
    }


    public class WatchEventNestedImpl<N> extends WatchEventFluentImpl<io.fabric8.kubernetes.api.model.KubeSchemaFluent.WatchEventNested<N>> implements io.fabric8.kubernetes.api.model.KubeSchemaFluent.WatchEventNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final WatchEventBuilder builder;

            WatchEventNestedImpl(WatchEvent item) {
                this.builder = new WatchEventBuilder(this, item);
                        
            }

            WatchEventNestedImpl() {
                this.builder = new WatchEventBuilder(this);
                        
            }

            public N and() {
                return (N) KubeSchemaFluentImpl.this.withWatchEvent(builder.build());
            }

            public N endWatchEvent() {
                return and();
            }
    }


}
