package io.fabric8.kubernetes.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class HostPathVolumeSourceFluentImpl<A extends HostPathVolumeSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HostPathVolumeSourceFluent<A> {

    private String path;
    private String type;

    public HostPathVolumeSourceFluentImpl() {
    }

    public HostPathVolumeSourceFluentImpl(HostPathVolumeSource instance) {
        this.withPath(instance.getPath()); 
        this.withType(instance.getType()); 
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path=path; return (A) this;
    }

    public Boolean hasPath() {
        return this.path != null;
    }

    public A withNewPath(StringBuilder arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(int[] arg1,int arg2,int arg3) {
        return (A)withPath(new String(arg1, arg2, arg3));
    }

    public A withNewPath(char[] arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(byte[] arg1,int arg2) {
        return (A)withPath(new String(arg1, arg2));
    }

    public A withNewPath(byte[] arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(char[] arg1,int arg2,int arg3) {
        return (A)withPath(new String(arg1, arg2, arg3));
    }

    public A withNewPath(byte[] arg1,int arg2,int arg3) {
        return (A)withPath(new String(arg1, arg2, arg3));
    }

    public A withNewPath(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPath(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPath(String arg1) {
        return (A)withPath(new String(arg1));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(int[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(char[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(byte[] arg1,int arg2) {
        return (A)withType(new String(arg1, arg2));
    }

    public A withNewType(byte[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(char[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        HostPathVolumeSourceFluentImpl that = (HostPathVolumeSourceFluentImpl) o;
        if (path != null ? !path.equals(that.path) :that.path != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(path,  type,  super.hashCode());
    }

}
