package io.fabric8.kubernetes.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class VsphereVirtualDiskVolumeSourceFluentImpl<A extends VsphereVirtualDiskVolumeSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements VsphereVirtualDiskVolumeSourceFluent<A> {

    private String fsType;
    private String storagePolicyID;
    private String storagePolicyName;
    private String volumePath;

    public VsphereVirtualDiskVolumeSourceFluentImpl() {
    }

    public VsphereVirtualDiskVolumeSourceFluentImpl(VsphereVirtualDiskVolumeSource instance) {
        this.withFsType(instance.getFsType()); 
        this.withStoragePolicyID(instance.getStoragePolicyID()); 
        this.withStoragePolicyName(instance.getStoragePolicyName()); 
        this.withVolumePath(instance.getVolumePath()); 
    }

    public String getFsType() {
        return this.fsType;
    }

    public A withFsType(String fsType) {
        this.fsType=fsType; return (A) this;
    }

    public Boolean hasFsType() {
        return this.fsType != null;
    }

    public A withNewFsType(StringBuilder arg1) {
        return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(int[] arg1,int arg2,int arg3) {
        return (A)withFsType(new String(arg1, arg2, arg3));
    }

    public A withNewFsType(char[] arg1) {
        return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(StringBuffer arg1) {
        return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(byte[] arg1,int arg2) {
        return (A)withFsType(new String(arg1, arg2));
    }

    public A withNewFsType(byte[] arg1) {
        return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(char[] arg1,int arg2,int arg3) {
        return (A)withFsType(new String(arg1, arg2, arg3));
    }

    public A withNewFsType(byte[] arg1,int arg2,int arg3) {
        return (A)withFsType(new String(arg1, arg2, arg3));
    }

    public A withNewFsType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withFsType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewFsType(String arg1) {
        return (A)withFsType(new String(arg1));
    }

    public String getStoragePolicyID() {
        return this.storagePolicyID;
    }

    public A withStoragePolicyID(String storagePolicyID) {
        this.storagePolicyID=storagePolicyID; return (A) this;
    }

    public Boolean hasStoragePolicyID() {
        return this.storagePolicyID != null;
    }

    public A withNewStoragePolicyID(StringBuilder arg1) {
        return (A)withStoragePolicyID(new String(arg1));
    }

    public A withNewStoragePolicyID(int[] arg1,int arg2,int arg3) {
        return (A)withStoragePolicyID(new String(arg1, arg2, arg3));
    }

    public A withNewStoragePolicyID(char[] arg1) {
        return (A)withStoragePolicyID(new String(arg1));
    }

    public A withNewStoragePolicyID(StringBuffer arg1) {
        return (A)withStoragePolicyID(new String(arg1));
    }

    public A withNewStoragePolicyID(byte[] arg1,int arg2) {
        return (A)withStoragePolicyID(new String(arg1, arg2));
    }

    public A withNewStoragePolicyID(byte[] arg1) {
        return (A)withStoragePolicyID(new String(arg1));
    }

    public A withNewStoragePolicyID(char[] arg1,int arg2,int arg3) {
        return (A)withStoragePolicyID(new String(arg1, arg2, arg3));
    }

    public A withNewStoragePolicyID(byte[] arg1,int arg2,int arg3) {
        return (A)withStoragePolicyID(new String(arg1, arg2, arg3));
    }

    public A withNewStoragePolicyID(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withStoragePolicyID(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewStoragePolicyID(String arg1) {
        return (A)withStoragePolicyID(new String(arg1));
    }

    public String getStoragePolicyName() {
        return this.storagePolicyName;
    }

    public A withStoragePolicyName(String storagePolicyName) {
        this.storagePolicyName=storagePolicyName; return (A) this;
    }

    public Boolean hasStoragePolicyName() {
        return this.storagePolicyName != null;
    }

    public A withNewStoragePolicyName(StringBuilder arg1) {
        return (A)withStoragePolicyName(new String(arg1));
    }

    public A withNewStoragePolicyName(int[] arg1,int arg2,int arg3) {
        return (A)withStoragePolicyName(new String(arg1, arg2, arg3));
    }

    public A withNewStoragePolicyName(char[] arg1) {
        return (A)withStoragePolicyName(new String(arg1));
    }

    public A withNewStoragePolicyName(StringBuffer arg1) {
        return (A)withStoragePolicyName(new String(arg1));
    }

    public A withNewStoragePolicyName(byte[] arg1,int arg2) {
        return (A)withStoragePolicyName(new String(arg1, arg2));
    }

    public A withNewStoragePolicyName(byte[] arg1) {
        return (A)withStoragePolicyName(new String(arg1));
    }

    public A withNewStoragePolicyName(char[] arg1,int arg2,int arg3) {
        return (A)withStoragePolicyName(new String(arg1, arg2, arg3));
    }

    public A withNewStoragePolicyName(byte[] arg1,int arg2,int arg3) {
        return (A)withStoragePolicyName(new String(arg1, arg2, arg3));
    }

    public A withNewStoragePolicyName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withStoragePolicyName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewStoragePolicyName(String arg1) {
        return (A)withStoragePolicyName(new String(arg1));
    }

    public String getVolumePath() {
        return this.volumePath;
    }

    public A withVolumePath(String volumePath) {
        this.volumePath=volumePath; return (A) this;
    }

    public Boolean hasVolumePath() {
        return this.volumePath != null;
    }

    public A withNewVolumePath(StringBuilder arg1) {
        return (A)withVolumePath(new String(arg1));
    }

    public A withNewVolumePath(int[] arg1,int arg2,int arg3) {
        return (A)withVolumePath(new String(arg1, arg2, arg3));
    }

    public A withNewVolumePath(char[] arg1) {
        return (A)withVolumePath(new String(arg1));
    }

    public A withNewVolumePath(StringBuffer arg1) {
        return (A)withVolumePath(new String(arg1));
    }

    public A withNewVolumePath(byte[] arg1,int arg2) {
        return (A)withVolumePath(new String(arg1, arg2));
    }

    public A withNewVolumePath(byte[] arg1) {
        return (A)withVolumePath(new String(arg1));
    }

    public A withNewVolumePath(char[] arg1,int arg2,int arg3) {
        return (A)withVolumePath(new String(arg1, arg2, arg3));
    }

    public A withNewVolumePath(byte[] arg1,int arg2,int arg3) {
        return (A)withVolumePath(new String(arg1, arg2, arg3));
    }

    public A withNewVolumePath(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withVolumePath(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewVolumePath(String arg1) {
        return (A)withVolumePath(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        VsphereVirtualDiskVolumeSourceFluentImpl that = (VsphereVirtualDiskVolumeSourceFluentImpl) o;
        if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
        if (storagePolicyID != null ? !storagePolicyID.equals(that.storagePolicyID) :that.storagePolicyID != null) return false;
        if (storagePolicyName != null ? !storagePolicyName.equals(that.storagePolicyName) :that.storagePolicyName != null) return false;
        if (volumePath != null ? !volumePath.equals(that.volumePath) :that.volumePath != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fsType,  storagePolicyID,  storagePolicyName,  volumePath,  super.hashCode());
    }

}
