package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class EphemeralVolumeSourceFluentImpl<A extends EphemeralVolumeSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EphemeralVolumeSourceFluent<A> {

    private Boolean readOnly;
    private PersistentVolumeClaimTemplateBuilder volumeClaimTemplate;

    public EphemeralVolumeSourceFluentImpl() {
    }

    public EphemeralVolumeSourceFluentImpl(EphemeralVolumeSource instance) {
        this.withReadOnly(instance.getReadOnly()); 
        this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate()); 
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly=readOnly; return (A) this;
    }

    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public A withNewReadOnly(String arg1) {
        return (A)withReadOnly(new Boolean(arg1));
    }

    public A withNewReadOnly(boolean arg1) {
        return (A)withReadOnly(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildVolumeClaimTemplate instead.
 * @return The buildable object.
 */
@Deprecated public PersistentVolumeClaimTemplate getVolumeClaimTemplate() {
        return this.volumeClaimTemplate!=null?this.volumeClaimTemplate.build():null;
    }

    public PersistentVolumeClaimTemplate buildVolumeClaimTemplate() {
        return this.volumeClaimTemplate!=null?this.volumeClaimTemplate.build():null;
    }

    public A withVolumeClaimTemplate(PersistentVolumeClaimTemplate volumeClaimTemplate) {
        _visitables.get("volumeClaimTemplate").remove(this.volumeClaimTemplate);
        if (volumeClaimTemplate!=null){ this.volumeClaimTemplate= new PersistentVolumeClaimTemplateBuilder(volumeClaimTemplate); _visitables.get("volumeClaimTemplate").add(this.volumeClaimTemplate);} return (A) this;
    }

    public Boolean hasVolumeClaimTemplate() {
        return this.volumeClaimTemplate != null;
    }

    public EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<A> withNewVolumeClaimTemplate() {
        return new VolumeClaimTemplateNestedImpl();
    }

    public EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<A> withNewVolumeClaimTemplateLike(PersistentVolumeClaimTemplate item) {
        return new VolumeClaimTemplateNestedImpl(item);
    }

    public EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<A> editVolumeClaimTemplate() {
        return withNewVolumeClaimTemplateLike(getVolumeClaimTemplate());
    }

    public EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplate() {
        return withNewVolumeClaimTemplateLike(getVolumeClaimTemplate() != null ? getVolumeClaimTemplate(): new PersistentVolumeClaimTemplateBuilder().build());
    }

    public EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplateLike(PersistentVolumeClaimTemplate item) {
        return withNewVolumeClaimTemplateLike(getVolumeClaimTemplate() != null ? getVolumeClaimTemplate(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EphemeralVolumeSourceFluentImpl that = (EphemeralVolumeSourceFluentImpl) o;
        if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
        if (volumeClaimTemplate != null ? !volumeClaimTemplate.equals(that.volumeClaimTemplate) :that.volumeClaimTemplate != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(readOnly,  volumeClaimTemplate,  super.hashCode());
    }

    public class VolumeClaimTemplateNestedImpl<N> extends PersistentVolumeClaimTemplateFluentImpl<EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<N>> implements EphemeralVolumeSourceFluent.VolumeClaimTemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeClaimTemplateBuilder builder;

            VolumeClaimTemplateNestedImpl(PersistentVolumeClaimTemplate item) {
                this.builder = new PersistentVolumeClaimTemplateBuilder(this, item);
                        
            }

            VolumeClaimTemplateNestedImpl() {
                this.builder = new PersistentVolumeClaimTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) EphemeralVolumeSourceFluentImpl.this.withVolumeClaimTemplate(builder.build());
            }

            public N endVolumeClaimTemplate() {
                return and();
            }
    }


}
