package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EphemeralVolumeSourceBuilder extends EphemeralVolumeSourceFluentImpl<EphemeralVolumeSourceBuilder> implements VisitableBuilder<EphemeralVolumeSource,EphemeralVolumeSourceBuilder> {

    EphemeralVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public EphemeralVolumeSourceBuilder() {
        this(true);
    }

    public EphemeralVolumeSourceBuilder(Boolean validationEnabled) {
        this(new EphemeralVolumeSource(), validationEnabled);
    }

    public EphemeralVolumeSourceBuilder(EphemeralVolumeSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public EphemeralVolumeSourceBuilder(EphemeralVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new EphemeralVolumeSource(), validationEnabled);
    }

    public EphemeralVolumeSourceBuilder(EphemeralVolumeSourceFluent<?> fluent,EphemeralVolumeSource instance) {
        this(fluent, instance, true);
    }

    public EphemeralVolumeSourceBuilder(EphemeralVolumeSourceFluent<?> fluent,EphemeralVolumeSource instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withReadOnly(instance.getReadOnly()); 
        fluent.withVolumeClaimTemplate(instance.getVolumeClaimTemplate()); 
        this.validationEnabled = validationEnabled; 
    }

    public EphemeralVolumeSourceBuilder(EphemeralVolumeSource instance) {
        this(instance,true);
    }

    public EphemeralVolumeSourceBuilder(EphemeralVolumeSource instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withReadOnly(instance.getReadOnly()); 
        this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate()); 
        this.validationEnabled = validationEnabled; 
    }

    public EphemeralVolumeSource build() {
        EphemeralVolumeSource buildable = new EphemeralVolumeSource(fluent.getReadOnly(),fluent.getVolumeClaimTemplate());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EphemeralVolumeSourceBuilder that = (EphemeralVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
