package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface StatusDetailsFluent<A extends StatusDetailsFluent<A>> extends Fluent<A> {


    public A addToCauses(int index,StatusCause item);
    public A setToCauses(int index,StatusCause item);
    public A addToCauses(StatusCause... items);
    public A addAllToCauses(Collection<StatusCause> items);
    public A removeFromCauses(StatusCause... items);
    public A removeAllFromCauses(Collection<StatusCause> items);
    public A removeMatchingFromCauses(Predicate<StatusCauseBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildCauses instead.
 * @return The buildable object.
 */
@Deprecated public List<StatusCause> getCauses();
    public List<StatusCause> buildCauses();
    public StatusCause buildCause(int index);
    public StatusCause buildFirstCause();
    public StatusCause buildLastCause();
    public StatusCause buildMatchingCause(Predicate<StatusCauseBuilder> predicate);
    public Boolean hasMatchingCause(Predicate<StatusCauseBuilder> predicate);
    public A withCauses(List<StatusCause> causes);
    public A withCauses(StatusCause... causes);
    public Boolean hasCauses();
    public A addNewCause(String field,String message,String reason);
    public StatusDetailsFluent.CausesNested<A> addNewCause();
    public StatusDetailsFluent.CausesNested<A> addNewCauseLike(StatusCause item);
    public StatusDetailsFluent.CausesNested<A> setNewCauseLike(int index,StatusCause item);
    public StatusDetailsFluent.CausesNested<A> editCause(int index);
    public StatusDetailsFluent.CausesNested<A> editFirstCause();
    public StatusDetailsFluent.CausesNested<A> editLastCause();
    public StatusDetailsFluent.CausesNested<A> editMatchingCause(Predicate<StatusCauseBuilder> predicate);
    public String getGroup();
    public A withGroup(String group);
    public Boolean hasGroup();
    public A withNewGroup(StringBuilder arg1);
    public A withNewGroup(int[] arg1,int arg2,int arg3);
    public A withNewGroup(char[] arg1);
    public A withNewGroup(StringBuffer arg1);
    public A withNewGroup(byte[] arg1,int arg2);
    public A withNewGroup(byte[] arg1);
    public A withNewGroup(char[] arg1,int arg2,int arg3);
    public A withNewGroup(byte[] arg1,int arg2,int arg3);
    public A withNewGroup(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewGroup(String arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(StringBuilder arg1);
    public A withNewName(int[] arg1,int arg2,int arg3);
    public A withNewName(char[] arg1);
    public A withNewName(StringBuffer arg1);
    public A withNewName(byte[] arg1,int arg2);
    public A withNewName(byte[] arg1);
    public A withNewName(char[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewName(String arg1);
    public Integer getRetryAfterSeconds();
    public A withRetryAfterSeconds(Integer retryAfterSeconds);
    public Boolean hasRetryAfterSeconds();
    public A withNewRetryAfterSeconds(int arg1);
    public String getUid();
    public A withUid(String uid);
    public Boolean hasUid();
    public A withNewUid(StringBuilder arg1);
    public A withNewUid(int[] arg1,int arg2,int arg3);
    public A withNewUid(char[] arg1);
    public A withNewUid(StringBuffer arg1);
    public A withNewUid(byte[] arg1,int arg2);
    public A withNewUid(byte[] arg1);
    public A withNewUid(char[] arg1,int arg2,int arg3);
    public A withNewUid(byte[] arg1,int arg2,int arg3);
    public A withNewUid(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewUid(String arg1);
    public interface CausesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,StatusCauseFluent<StatusDetailsFluent.CausesNested<N>> {

            public N and();
            public N endCause();    }


}
