package io.fabric8.kubernetes.api.model;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class PortStatusFluentImpl<A extends PortStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PortStatusFluent<A> {

    private String error;
    private Integer port;
    private String protocol;

    public PortStatusFluentImpl() {
    }

    public PortStatusFluentImpl(PortStatus instance) {
        this.withError(instance.getError()); 
        this.withPort(instance.getPort()); 
        this.withProtocol(instance.getProtocol()); 
    }

    public String getError() {
        return this.error;
    }

    public A withError(String error) {
        this.error=error; return (A) this;
    }

    public Boolean hasError() {
        return this.error != null;
    }

    public A withNewError(StringBuilder arg1) {
        return (A)withError(new String(arg1));
    }

    public A withNewError(int[] arg1,int arg2,int arg3) {
        return (A)withError(new String(arg1, arg2, arg3));
    }

    public A withNewError(char[] arg1) {
        return (A)withError(new String(arg1));
    }

    public A withNewError(StringBuffer arg1) {
        return (A)withError(new String(arg1));
    }

    public A withNewError(byte[] arg1,int arg2) {
        return (A)withError(new String(arg1, arg2));
    }

    public A withNewError(byte[] arg1) {
        return (A)withError(new String(arg1));
    }

    public A withNewError(char[] arg1,int arg2,int arg3) {
        return (A)withError(new String(arg1, arg2, arg3));
    }

    public A withNewError(byte[] arg1,int arg2,int arg3) {
        return (A)withError(new String(arg1, arg2, arg3));
    }

    public A withNewError(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withError(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewError(String arg1) {
        return (A)withError(new String(arg1));
    }

    public Integer getPort() {
        return this.port;
    }

    public A withPort(Integer port) {
        this.port=port; return (A) this;
    }

    public Boolean hasPort() {
        return this.port != null;
    }

    public A withNewPort(int arg1) {
        return (A)withPort(new Integer(arg1));
    }

    public String getProtocol() {
        return this.protocol;
    }

    public A withProtocol(String protocol) {
        this.protocol=protocol; return (A) this;
    }

    public Boolean hasProtocol() {
        return this.protocol != null;
    }

    public A withNewProtocol(StringBuilder arg1) {
        return (A)withProtocol(new String(arg1));
    }

    public A withNewProtocol(int[] arg1,int arg2,int arg3) {
        return (A)withProtocol(new String(arg1, arg2, arg3));
    }

    public A withNewProtocol(char[] arg1) {
        return (A)withProtocol(new String(arg1));
    }

    public A withNewProtocol(StringBuffer arg1) {
        return (A)withProtocol(new String(arg1));
    }

    public A withNewProtocol(byte[] arg1,int arg2) {
        return (A)withProtocol(new String(arg1, arg2));
    }

    public A withNewProtocol(byte[] arg1) {
        return (A)withProtocol(new String(arg1));
    }

    public A withNewProtocol(char[] arg1,int arg2,int arg3) {
        return (A)withProtocol(new String(arg1, arg2, arg3));
    }

    public A withNewProtocol(byte[] arg1,int arg2,int arg3) {
        return (A)withProtocol(new String(arg1, arg2, arg3));
    }

    public A withNewProtocol(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withProtocol(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewProtocol(String arg1) {
        return (A)withProtocol(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PortStatusFluentImpl that = (PortStatusFluentImpl) o;
        if (error != null ? !error.equals(that.error) :that.error != null) return false;
        if (port != null ? !port.equals(that.port) :that.port != null) return false;
        if (protocol != null ? !protocol.equals(that.protocol) :that.protocol != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(error,  port,  protocol,  super.hashCode());
    }

}
