package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface NodeListFluent<A extends NodeListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToItems(int index,Node item);
    public A setToItems(int index,Node item);
    public A addToItems(Node... items);
    public A addAllToItems(Collection<Node> items);
    public A removeFromItems(Node... items);
    public A removeAllFromItems(Collection<Node> items);
    public A removeMatchingFromItems(Predicate<NodeBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Node> getItems();
    public List<Node> buildItems();
    public Node buildItem(int index);
    public Node buildFirstItem();
    public Node buildLastItem();
    public Node buildMatchingItem(Predicate<NodeBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<NodeBuilder> predicate);
    public A withItems(List<Node> items);
    public A withItems(Node... items);
    public Boolean hasItems();
    public NodeListFluent.ItemsNested<A> addNewItem();
    public NodeListFluent.ItemsNested<A> addNewItemLike(Node item);
    public NodeListFluent.ItemsNested<A> setNewItemLike(int index,Node item);
    public NodeListFluent.ItemsNested<A> editItem(int index);
    public NodeListFluent.ItemsNested<A> editFirstItem();
    public NodeListFluent.ItemsNested<A> editLastItem();
    public NodeListFluent.ItemsNested<A> editMatchingItem(Predicate<NodeBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ListMeta getMetadata();
    public ListMeta buildMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public NodeListFluent.MetadataNested<A> withNewMetadata();
    public NodeListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public NodeListFluent.MetadataNested<A> editMetadata();
    public NodeListFluent.MetadataNested<A> editOrNewMetadata();
    public NodeListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NodeFluent<NodeListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<NodeListFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


}
