package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class LoadBalancerIngressFluentImpl<A extends LoadBalancerIngressFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements LoadBalancerIngressFluent<A> {

    private String hostname;
    private String ip;
    private List<PortStatusBuilder> ports =  new ArrayList<PortStatusBuilder>();

    public LoadBalancerIngressFluentImpl() {
    }

    public LoadBalancerIngressFluentImpl(LoadBalancerIngress instance) {
        this.withHostname(instance.getHostname()); 
        this.withIp(instance.getIp()); 
        this.withPorts(instance.getPorts()); 
    }

    public String getHostname() {
        return this.hostname;
    }

    public A withHostname(String hostname) {
        this.hostname=hostname; return (A) this;
    }

    public Boolean hasHostname() {
        return this.hostname != null;
    }

    public A withNewHostname(StringBuilder arg1) {
        return (A)withHostname(new String(arg1));
    }

    public A withNewHostname(int[] arg1,int arg2,int arg3) {
        return (A)withHostname(new String(arg1, arg2, arg3));
    }

    public A withNewHostname(char[] arg1) {
        return (A)withHostname(new String(arg1));
    }

    public A withNewHostname(StringBuffer arg1) {
        return (A)withHostname(new String(arg1));
    }

    public A withNewHostname(byte[] arg1,int arg2) {
        return (A)withHostname(new String(arg1, arg2));
    }

    public A withNewHostname(byte[] arg1) {
        return (A)withHostname(new String(arg1));
    }

    public A withNewHostname(char[] arg1,int arg2,int arg3) {
        return (A)withHostname(new String(arg1, arg2, arg3));
    }

    public A withNewHostname(byte[] arg1,int arg2,int arg3) {
        return (A)withHostname(new String(arg1, arg2, arg3));
    }

    public A withNewHostname(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withHostname(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewHostname(String arg1) {
        return (A)withHostname(new String(arg1));
    }

    public String getIp() {
        return this.ip;
    }

    public A withIp(String ip) {
        this.ip=ip; return (A) this;
    }

    public Boolean hasIp() {
        return this.ip != null;
    }

    public A withNewIp(StringBuilder arg1) {
        return (A)withIp(new String(arg1));
    }

    public A withNewIp(int[] arg1,int arg2,int arg3) {
        return (A)withIp(new String(arg1, arg2, arg3));
    }

    public A withNewIp(char[] arg1) {
        return (A)withIp(new String(arg1));
    }

    public A withNewIp(StringBuffer arg1) {
        return (A)withIp(new String(arg1));
    }

    public A withNewIp(byte[] arg1,int arg2) {
        return (A)withIp(new String(arg1, arg2));
    }

    public A withNewIp(byte[] arg1) {
        return (A)withIp(new String(arg1));
    }

    public A withNewIp(char[] arg1,int arg2,int arg3) {
        return (A)withIp(new String(arg1, arg2, arg3));
    }

    public A withNewIp(byte[] arg1,int arg2,int arg3) {
        return (A)withIp(new String(arg1, arg2, arg3));
    }

    public A withNewIp(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withIp(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewIp(String arg1) {
        return (A)withIp(new String(arg1));
    }

    public A addToPorts(int index,PortStatus item) {
        if (this.ports == null) {this.ports = new ArrayList<PortStatusBuilder>();}
        PortStatusBuilder builder = new PortStatusBuilder(item);_visitables.get("ports").add(index >= 0 ? index : _visitables.get("ports").size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
    }

    public A setToPorts(int index,PortStatus item) {
        if (this.ports == null) {this.ports = new ArrayList<PortStatusBuilder>();}
        PortStatusBuilder builder = new PortStatusBuilder(item);
        if (index < 0 || index >= _visitables.get("ports").size()) { _visitables.get("ports").add(builder); } else { _visitables.get("ports").set(index, builder);}
        if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
         return (A)this;
    }

    public A addToPorts(PortStatus... items) {
        if (this.ports == null) {this.ports = new ArrayList<PortStatusBuilder>();}
        for (PortStatus item : items) {PortStatusBuilder builder = new PortStatusBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
    }

    public A addAllToPorts(Collection<PortStatus> items) {
        if (this.ports == null) {this.ports = new ArrayList<PortStatusBuilder>();}
        for (PortStatus item : items) {PortStatusBuilder builder = new PortStatusBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
    }

    public A removeFromPorts(PortStatus... items) {
        for (PortStatus item : items) {PortStatusBuilder builder = new PortStatusBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeAllFromPorts(Collection<PortStatus> items) {
        for (PortStatus item : items) {PortStatusBuilder builder = new PortStatusBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPorts(Predicate<PortStatusBuilder> predicate) {
        if (ports == null) return (A) this;
        final Iterator<PortStatusBuilder> each = ports.iterator();
        final List visitables = _visitables.get("ports");
        while (each.hasNext()) {
          PortStatusBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<PortStatus> getPorts() {
        return build(ports);
    }

    public List<PortStatus> buildPorts() {
        return build(ports);
    }

    public PortStatus buildPort(int index) {
        return this.ports.get(index).build();
    }

    public PortStatus buildFirstPort() {
        return this.ports.get(0).build();
    }

    public PortStatus buildLastPort() {
        return this.ports.get(ports.size() - 1).build();
    }

    public PortStatus buildMatchingPort(Predicate<PortStatusBuilder> predicate) {
        for (PortStatusBuilder item: ports) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingPort(Predicate<PortStatusBuilder> predicate) {
        for (PortStatusBuilder item: ports) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withPorts(List<PortStatus> ports) {
        if (this.ports != null) { _visitables.get("ports").removeAll(this.ports);}
        if (ports != null) {this.ports = new ArrayList<PortStatusBuilder>(); for (PortStatus item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
    }

    public A withPorts(PortStatus... ports) {
        if (this.ports != null) {this.ports.clear();}
        if (ports != null) {for (PortStatus item :ports){ this.addToPorts(item);}} return (A) this;
    }

    public Boolean hasPorts() {
        return ports != null && !ports.isEmpty();
    }

    public A addNewPort(String error,Integer port,String protocol) {
        return (A)addToPorts(new PortStatus(error, port, protocol));
    }

    public LoadBalancerIngressFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    public LoadBalancerIngressFluent.PortsNested<A> addNewPortLike(PortStatus item) {
        return new PortsNestedImpl(-1, item);
    }

    public LoadBalancerIngressFluent.PortsNested<A> setNewPortLike(int index,PortStatus item) {
        return new PortsNestedImpl(index, item);
    }

    public LoadBalancerIngressFluent.PortsNested<A> editPort(int index) {
        if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
        return setNewPortLike(index, buildPort(index));
    }

    public LoadBalancerIngressFluent.PortsNested<A> editFirstPort() {
        if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
        return setNewPortLike(0, buildPort(0));
    }

    public LoadBalancerIngressFluent.PortsNested<A> editLastPort() {
        int index = ports.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
        return setNewPortLike(index, buildPort(index));
    }

    public LoadBalancerIngressFluent.PortsNested<A> editMatchingPort(Predicate<PortStatusBuilder> predicate) {
        int index = -1;
        for (int i=0;i<ports.size();i++) { 
        if (predicate.test(ports.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
        return setNewPortLike(index, buildPort(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LoadBalancerIngressFluentImpl that = (LoadBalancerIngressFluentImpl) o;
        if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
        if (ip != null ? !ip.equals(that.ip) :that.ip != null) return false;
        if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(hostname,  ip,  ports,  super.hashCode());
    }

    public class PortsNestedImpl<N> extends PortStatusFluentImpl<LoadBalancerIngressFluent.PortsNested<N>> implements LoadBalancerIngressFluent.PortsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PortStatusBuilder builder;
        private final int index;

            PortsNestedImpl(int index,PortStatus item) {
                this.index = index;
                this.builder = new PortStatusBuilder(this, item);
                        
            }

            PortsNestedImpl() {
                this.index = -1;
                this.builder = new PortStatusBuilder(this);
                        
            }

            public N and() {
                return (N) LoadBalancerIngressFluentImpl.this.setToPorts(index,builder.build());
            }

            public N endPort() {
                return and();
            }
    }


}
